/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tooling;

import com.azul.tooling.Handler;
import com.azul.tooling.in.NetConnectionEvent;
import com.azul.tooling.in.Tooling;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

public class AnyConnectionEventModel
implements Handler.EventModel {
    private static final boolean canSendHeaders = "true".equals(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("com.azul.tooling.http.dumpHeaders");
        }
    }));
    private String protocol;
    private String toAddress;
    private Integer toPort;
    private String toHost = "";
    private String fromAddress;
    private Integer fromPort;
    private String fromHost = "";
    private Long connectionInitiatedTime = -1L;
    private Long connectionEstablishedTime = -1L;
    private String headers = "";
    private String url = "";
    private boolean originating;

    public String getProtocol() {
        return this.protocol;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public int getToPort() {
        return this.toPort;
    }

    public String getToHost() {
        return this.toHost;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public String getFromHost() {
        return this.fromHost;
    }

    public long getConnectionInitiatedTime() {
        return this.connectionInitiatedTime;
    }

    public long getConnectionEstablishedTime() {
        return this.connectionEstablishedTime;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getOriginating() {
        return this.originating;
    }

    @Override
    public void init(Tooling.ToolingEvent toolingEvent) {
        NetConnectionEvent netConnectionEvent = (NetConnectionEvent)toolingEvent;
        this.protocol = netConnectionEvent.protocol;
        if (netConnectionEvent.toAddress == null) {
            this.toAddress = "";
            this.toHost = "";
        } else {
            this.toAddress = netConnectionEvent.toAddress.getHostAddress();
            this.toHost = netConnectionEvent.toAddress.getHostName();
        }
        this.toPort = netConnectionEvent.toPort;
        if (netConnectionEvent.fromAddress == null) {
            this.fromAddress = "";
            this.fromHost = "";
        } else {
            this.fromAddress = netConnectionEvent.fromAddress.getHostAddress();
            this.fromHost = netConnectionEvent.fromAddress.getHostName();
        }
        this.fromPort = netConnectionEvent.fromPort;
        this.connectionInitiatedTime = netConnectionEvent.connectionInitiatedTime;
        this.connectionEstablishedTime = netConnectionEvent.connectionEstablishedTime;
        this.headers = canSendHeaders && netConnectionEvent.headers != null ? AnyConnectionEventModel.dumpHeaders(netConnectionEvent.headers) : "";
        this.url = netConnectionEvent.url;
        this.originating = netConnectionEvent.originating;
    }

    private static String dumpHeaders(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

