/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ReferenceFinder {
    private final Filter filter;
    private final Visitor visitor;
    private ConstantPool.Visitor<Boolean, ConstantPool> cpVisitor = new ConstantPool.Visitor<Boolean, ConstantPool>(){

        @Override
        public Boolean visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, ConstantPool constantPool) {
            return ReferenceFinder.this.filter.accept(constantPool, cONSTANT_InterfaceMethodref_info);
        }

        @Override
        public Boolean visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, ConstantPool constantPool) {
            return ReferenceFinder.this.filter.accept(constantPool, cONSTANT_Methodref_info);
        }

        @Override
        public Boolean visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, ConstantPool constantPool) {
            return ReferenceFinder.this.filter.accept(constantPool, cONSTANT_Fieldref_info);
        }

        @Override
        public Boolean visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info cONSTANT_InvokeDynamic_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info cONSTANT_MethodHandle_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitMethodType(ConstantPool.CONSTANT_MethodType_info cONSTANT_MethodType_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, ConstantPool constantPool) {
            return false;
        }

        @Override
        public Boolean visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, ConstantPool constantPool) {
            return false;
        }
    };
    private Instruction.KindVisitor<Integer, List<Integer>> codeVisitor = new Instruction.KindVisitor<Integer, List<Integer>>(){

        @Override
        public Integer visitNoOperands(Instruction instruction, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitArrayType(Instruction instruction, Instruction.TypeKind typeKind, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitBranch(Instruction instruction, int n, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitConstantPoolRef(Instruction instruction, int n, List<Integer> list) {
            return list.contains(n) ? n : 0;
        }

        @Override
        public Integer visitConstantPoolRefAndValue(Instruction instruction, int n, int n2, List<Integer> list) {
            return list.contains(n) ? n : 0;
        }

        @Override
        public Integer visitLocal(Instruction instruction, int n, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitLocalAndValue(Instruction instruction, int n, int n2, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitLookupSwitch(Instruction instruction, int n, int n2, int[] nArray, int[] nArray2, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitTableSwitch(Instruction instruction, int n, int n2, int n3, int[] nArray, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitValue(Instruction instruction, int n, List<Integer> list) {
            return 0;
        }

        @Override
        public Integer visitUnknown(Instruction instruction, List<Integer> list) {
            return 0;
        }
    };

    public ReferenceFinder(Filter filter, Visitor visitor) {
        this.filter = Objects.requireNonNull(filter);
        this.visitor = Objects.requireNonNull(visitor);
    }

    public boolean parse(ClassFile classFile) throws ConstantPoolException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 1;
        for (ConstantPool.CPInfo cPInfo : classFile.constant_pool.entries()) {
            if (cPInfo.accept(this.cpVisitor, classFile.constant_pool).booleanValue()) {
                arrayList.add(n);
            }
            n += cPInfo.size();
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        for (Method method : classFile.methods) {
            int n2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Code_attribute code_attribute = (Code_attribute)method.attributes.get("Code");
            if (code_attribute != null) {
                for (Instruction instruction : code_attribute.getInstructions()) {
                    n2 = instruction.accept(this.codeVisitor, arrayList);
                    if (n2 <= 0) continue;
                    hashSet.add(n2);
                }
            }
            if (hashSet.size() <= 0) continue;
            ArrayList arrayList2 = new ArrayList(hashSet.size());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                arrayList2.add(ConstantPool.CPRefInfo.class.cast(classFile.constant_pool.get(n2)));
            }
            this.visitor.visit(classFile, method, arrayList2);
        }
        return true;
    }

    public static interface Visitor {
        public void visit(ClassFile var1, Method var2, List<ConstantPool.CPRefInfo> var3);
    }

    public static interface Filter {
        public boolean accept(ConstantPool var1, ConstantPool.CPRefInfo var2);
    }
}

