/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.sun.tools.doclets.formats.html.ClassWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.util.MethodTypes;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMemberWriter {
    protected final ConfigurationImpl configuration;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    protected Map<String, Integer> typeMap = new LinkedHashMap<String, Integer>();
    protected Set<MethodTypes> methodTypes = EnumSet.noneOf(MethodTypes.class);
    private int methodTypesOr = 0;
    public final boolean nodepr;
    protected boolean printedSummaryHeader = false;

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        this.configuration = subWriterHolderWriter.configuration;
        this.writer = subWriterHolderWriter;
        this.nodepr = this.configuration.nodeprecated;
        this.classdoc = classDoc;
    }

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter) {
        this(subWriterHolderWriter, null);
    }

    public abstract void addSummaryLabel(Content var1);

    public abstract String getTableSummary();

    public abstract Content getCaption();

    public abstract String[] getSummaryTableHeader(ProgramElementDoc var1);

    public abstract void addInheritedSummaryLabel(ClassDoc var1, Content var2);

    public abstract void addSummaryAnchor(ClassDoc var1, Content var2);

    public abstract void addInheritedSummaryAnchor(ClassDoc var1, Content var2);

    protected abstract void addSummaryType(ProgramElementDoc var1, Content var2);

    protected void addSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc, Content content) {
        this.addSummaryLink(LinkInfoImpl.Kind.MEMBER, classDoc, programElementDoc, content);
    }

    protected abstract void addSummaryLink(LinkInfoImpl.Kind var1, ClassDoc var2, ProgramElementDoc var3, Content var4);

    protected abstract void addInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2, Content var3);

    protected abstract Content getDeprecatedLink(ProgramElementDoc var1);

    protected abstract Content getNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void addNavDetailLink(boolean var1, Content var2);

    protected void addName(String string, Content content) {
        content.addContent(string);
    }

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String typeString(MemberDoc memberDoc) {
        String string = "";
        if (memberDoc instanceof MethodDoc) {
            string = ((MethodDoc)memberDoc).returnType().toString();
        } else if (memberDoc instanceof FieldDoc) {
            string = ((FieldDoc)memberDoc).type().toString();
        }
        return string;
    }

    protected void addModifiers(MemberDoc memberDoc, Content content) {
        String string = this.modifierString(memberDoc);
        if ((memberDoc.isField() || memberDoc.isMethod()) && this.writer instanceof ClassWriterImpl && ((ClassWriterImpl)this.writer).getClassDoc().isInterface()) {
            String string2 = string = memberDoc.isMethod() && ((MethodDoc)memberDoc).isDefault() ? Util.replaceText(string, "public", "default").trim() : Util.replaceText(string, "public", "").trim();
        }
        if (string.length() > 0) {
            content.addContent(string);
            content.addContent(this.writer.getSpace());
        }
    }

    protected String makeSpace(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    protected void addModifierAndType(ProgramElementDoc programElementDoc, Type type, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.CODE);
        this.addModifier(programElementDoc, htmlTree);
        if (type == null) {
            if (programElementDoc.isClass()) {
                htmlTree.addContent("class");
            } else {
                htmlTree.addContent("interface");
            }
            htmlTree.addContent(this.writer.getSpace());
        } else if (programElementDoc instanceof ExecutableMemberDoc && ((ExecutableMemberDoc)programElementDoc).typeParameters().length > 0) {
            Content content2 = ((AbstractExecutableMemberWriter)this).getTypeParameters((ExecutableMemberDoc)programElementDoc);
            htmlTree.addContent(content2);
            if (content2.charCount() > 10) {
                htmlTree.addContent(new HtmlTree(HtmlTag.BR));
            } else {
                htmlTree.addContent(this.writer.getSpace());
            }
            htmlTree.addContent(this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SUMMARY_RETURN_TYPE, type)));
        } else {
            htmlTree.addContent(this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SUMMARY_RETURN_TYPE, type)));
        }
        content.addContent(htmlTree);
    }

    private void addModifier(ProgramElementDoc programElementDoc, Content content) {
        if (programElementDoc.isProtected()) {
            content.addContent("protected ");
        } else if (programElementDoc.isPrivate()) {
            content.addContent("private ");
        } else if (!programElementDoc.isPublic()) {
            content.addContent(this.configuration.getText("doclet.Package_private"));
            content.addContent(" ");
        }
        if (programElementDoc.isMethod()) {
            if (!programElementDoc.containingClass().isInterface() && ((MethodDoc)programElementDoc).isAbstract()) {
                content.addContent("abstract ");
            }
            if (((MethodDoc)programElementDoc).isDefault()) {
                content.addContent("default ");
            }
        }
        if (programElementDoc.isStatic()) {
            content.addContent("static ");
        }
    }

    protected void addDeprecatedInfo(ProgramElementDoc programElementDoc, Content content) {
        Content content2 = new DeprecatedTaglet().getTagletOutput((Doc)programElementDoc, this.writer.getTagletWriterInstance(false));
        if (!content2.isEmpty()) {
            Content content3 = content2;
            HtmlTree htmlTree = HtmlTree.DIV(HtmlStyle.block, content3);
            content.addContent(htmlTree);
        }
    }

    protected void addComment(ProgramElementDoc programElementDoc, Content content) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.addInlineComment((Doc)programElementDoc, content);
        }
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected Content getHead(MemberDoc memberDoc) {
        StringContent stringContent = new StringContent(memberDoc.name());
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, stringContent);
        return htmlTree;
    }

    protected boolean isInherited(ProgramElementDoc programElementDoc) {
        return !programElementDoc.isPrivate() && (!programElementDoc.isPackagePrivate() || programElementDoc.containingPackage().equals(this.classdoc.containingPackage()));
    }

    protected void addDeprecatedAPI(List<Doc> list, String string, String string2, String[] stringArray, Content content) {
        if (list.size() > 0) {
            Object object;
            HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.deprecatedSummary, 0, 3, 0, string2, this.writer.getTableCaption(this.configuration.getResource(string)));
            ((Content)htmlTree).addContent(this.writer.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < list.size(); ++i) {
                object = (ProgramElementDoc)list.get(i);
                HtmlTree htmlTree3 = HtmlTree.TD(HtmlStyle.colOne, this.getDeprecatedLink((ProgramElementDoc)object));
                if (object.tags("deprecated").length > 0) {
                    this.writer.addInlineDeprecatedComment((Doc)object, object.tags("deprecated")[0], htmlTree3);
                }
                HtmlTree htmlTree4 = HtmlTree.TR(htmlTree3);
                if (i % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                ((Content)htmlTree2).addContent(htmlTree4);
            }
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree5 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
            object = HtmlTree.UL(HtmlStyle.blockList, htmlTree5);
            content.addContent((Content)object);
        }
    }

    protected void addUseInfo(List<? extends ProgramElementDoc> list, Content content, String string, Content content2) {
        if (list == null) {
            return;
        }
        List<? extends ProgramElementDoc> list2 = list;
        boolean bl = false;
        if (list2.size() > 0) {
            HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.useSummary, 0, 3, 0, string, this.writer.getTableCaption(content));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            Iterator<? extends ProgramElementDoc> iterator = list2.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ProgramElementDoc programElementDoc = iterator.next();
                ClassDoc classDoc = programElementDoc.containingClass();
                if (!bl) {
                    ((Content)htmlTree).addContent(this.writer.getSummaryTableHeader(this.getSummaryTableHeader(programElementDoc), "col"));
                    bl = true;
                }
                HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TR);
                if (n % 2 == 0) {
                    htmlTree3.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree3.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree htmlTree4 = new HtmlTree(HtmlTag.TD);
                htmlTree4.addStyle(HtmlStyle.colFirst);
                this.writer.addSummaryType(this, programElementDoc, htmlTree4);
                htmlTree3.addContent(htmlTree4);
                HtmlTree htmlTree5 = new HtmlTree(HtmlTag.TD);
                htmlTree5.addStyle(HtmlStyle.colLast);
                if (classDoc != null && !(programElementDoc instanceof ConstructorDoc) && !(programElementDoc instanceof ClassDoc)) {
                    HtmlTree htmlTree6 = new HtmlTree(HtmlTag.SPAN);
                    htmlTree6.addStyle(HtmlStyle.typeNameLabel);
                    htmlTree6.addContent(classDoc.name() + ".");
                    htmlTree5.addContent(htmlTree6);
                }
                this.addSummaryLink(programElementDoc instanceof ClassDoc ? LinkInfoImpl.Kind.CLASS_USE : LinkInfoImpl.Kind.MEMBER, classDoc, programElementDoc, htmlTree5);
                this.writer.addSummaryLinkComment(this, programElementDoc, htmlTree5);
                htmlTree3.addContent(htmlTree5);
                ((Content)htmlTree2).addContent(htmlTree3);
                ++n;
            }
            ((Content)htmlTree).addContent(htmlTree2);
            content2.addContent(htmlTree);
        }
    }

    protected void addNavDetailLink(List<?> list, Content content) {
        this.addNavDetailLink(list.size() > 0, content);
    }

    protected void addNavSummaryLink(List<?> list, VisibleMemberMap visibleMemberMap, Content content) {
        if (list.size() > 0) {
            content.addContent(this.getNavSummaryLink(null, true));
            return;
        }
        for (ClassDoc classDoc = this.classdoc.superclass(); classDoc != null; classDoc = classDoc.superclass()) {
            List<ProgramElementDoc> list2 = visibleMemberMap.getMembersFor(classDoc);
            if (list2.size() <= 0) continue;
            content.addContent(this.getNavSummaryLink(classDoc, true));
            return;
        }
        content.addContent(this.getNavSummaryLink(null, false));
    }

    protected void serialWarning(SourcePosition sourcePosition, String string, String string2, String string3) {
        if (this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(sourcePosition, string, string2, string3);
        }
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] programElementDocArray) {
        return this.nodepr ? Util.excludeDeprecatedMembers(programElementDocArray) : programElementDocArray;
    }

    public void addMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, Tag[] tagArray, List<Content> list, int n) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TD);
        htmlTree.addStyle(HtmlStyle.colFirst);
        this.writer.addSummaryType(this, programElementDoc, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TD);
        this.setSummaryColumnStyle(htmlTree2);
        this.addSummaryLink(classDoc, programElementDoc, htmlTree2);
        this.writer.addSummaryLinkComment(this, programElementDoc, tagArray, htmlTree2);
        HtmlTree htmlTree3 = HtmlTree.TR(htmlTree);
        htmlTree3.addContent(htmlTree2);
        if (programElementDoc instanceof MethodDoc && !programElementDoc.isAnnotationTypeElement()) {
            int n2;
            int n3 = n2 = programElementDoc.isStatic() ? MethodTypes.STATIC.value() : MethodTypes.INSTANCE.value();
            if (programElementDoc.containingClass().isInterface()) {
                n2 = ((MethodDoc)programElementDoc).isAbstract() ? n2 | MethodTypes.ABSTRACT.value() : n2 | MethodTypes.DEFAULT.value();
            } else {
                int n4 = n2 = ((MethodDoc)programElementDoc).isAbstract() ? n2 | MethodTypes.ABSTRACT.value() : n2 | MethodTypes.CONCRETE.value();
            }
            if (Util.isDeprecated((Doc)programElementDoc) || Util.isDeprecated((Doc)this.classdoc)) {
                n2 |= MethodTypes.DEPRECATED.value();
            }
            this.methodTypesOr |= n2;
            String string = "i" + n;
            this.typeMap.put(string, n2);
            htmlTree3.addAttr(HtmlAttr.ID, string);
        }
        if (n % 2 == 0) {
            htmlTree3.addStyle(HtmlStyle.altColor);
        } else {
            htmlTree3.addStyle(HtmlStyle.rowColor);
        }
        list.add(htmlTree3);
    }

    public boolean showTabs() {
        boolean bl;
        for (MethodTypes methodTypes : EnumSet.allOf(MethodTypes.class)) {
            int n = methodTypes.value();
            if ((n & this.methodTypesOr) != n) continue;
            this.methodTypes.add(methodTypes);
        }
        boolean bl2 = bl = this.methodTypes.size() > 1;
        if (bl) {
            this.methodTypes.add(MethodTypes.ALL);
        }
        return bl;
    }

    public void setSummaryColumnStyle(HtmlTree htmlTree) {
        htmlTree.addStyle(HtmlStyle.colLast);
    }

    public void addInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, boolean bl, boolean bl2, Content content) {
        this.writer.addInheritedMemberSummary(this, classDoc, programElementDoc, bl, content);
    }

    public Content getInheritedSummaryHeader(ClassDoc classDoc) {
        Content content = this.writer.getMemberTreeHeader();
        this.writer.addInheritedSummaryHeader(this, classDoc, content);
        return content;
    }

    public Content getInheritedSummaryLinksTree() {
        return new HtmlTree(HtmlTag.CODE);
    }

    public Content getSummaryTableTree(ClassDoc classDoc, List<Content> list) {
        return this.writer.getSummaryTableTree(this, classDoc, list, this.showTabs());
    }

    public Content getMemberTree(Content content) {
        return this.writer.getMemberTree(content);
    }

    public Content getMemberTree(Content content, boolean bl) {
        if (bl) {
            return HtmlTree.UL(HtmlStyle.blockListLast, content);
        }
        return HtmlTree.UL(HtmlStyle.blockList, content);
    }
}

