/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.formats.html.SectionName;
import com.sun.tools.doclets.formats.html.markup.Comment;
import com.sun.tools.doclets.formats.html.markup.DocType;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.HtmlWriter;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public static final String CONTENT_TYPE = "text/html";

    public HtmlDocWriter(Configuration configuration, DocPath docPath) throws IOException {
        super(configuration, docPath);
        configuration.message.notice("doclet.Generating_0", DocFile.createFileForOutput(configuration, docPath).getPath());
    }

    public abstract Configuration configuration();

    public Content getHyperLink(DocPath docPath, String string) {
        return this.getHyperLink(docPath, (Content)new StringContent(string), false, "", "", "");
    }

    public Content getHyperLink(String string, Content content) {
        return this.getHyperLink(this.getDocLink(string), content, "", "");
    }

    public Content getHyperLink(SectionName sectionName, Content content) {
        return this.getHyperLink(this.getDocLink(sectionName), content, "", "");
    }

    public Content getHyperLink(SectionName sectionName, String string, Content content) {
        return this.getHyperLink(this.getDocLink(sectionName, string), content, "", "");
    }

    public DocLink getDocLink(String string) {
        return DocLink.fragment(this.getName(string));
    }

    public DocLink getDocLink(SectionName sectionName) {
        return DocLink.fragment(sectionName.getName());
    }

    public DocLink getDocLink(SectionName sectionName, String string) {
        return DocLink.fragment(sectionName.getName() + this.getName(string));
    }

    public String getName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case ',': 
                case '<': 
                case '>': {
                    stringBuilder.append('-');
                    continue block7;
                }
                case ' ': 
                case '[': {
                    continue block7;
                }
                case ']': {
                    stringBuilder.append(":A");
                    continue block7;
                }
                case '$': {
                    if (i == 0) {
                        stringBuilder.append("Z:Z");
                    }
                    stringBuilder.append(":D");
                    continue block7;
                }
                case '_': {
                    if (i == 0) {
                        stringBuilder.append("Z:Z");
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public Content getHyperLink(DocPath docPath, Content content) {
        return this.getHyperLink(docPath, content, "", "");
    }

    public Content getHyperLink(DocLink docLink, Content content) {
        return this.getHyperLink(docLink, content, "", "");
    }

    public Content getHyperLink(DocPath docPath, Content content, boolean bl, String string, String string2, String string3) {
        return this.getHyperLink(new DocLink(docPath), content, bl, string, string2, string3);
    }

    public Content getHyperLink(DocLink docLink, Content content, boolean bl, String string, String string2, String string3) {
        HtmlTree htmlTree;
        Content content2 = content;
        if (bl) {
            content2 = HtmlTree.SPAN(HtmlStyle.typeNameLink, content2);
        }
        if (string != null && string.length() != 0) {
            htmlTree = new HtmlTree(HtmlTag.FONT, content2);
            htmlTree.addAttr(HtmlAttr.CLASS, string);
            content2 = htmlTree;
        }
        htmlTree = HtmlTree.A(docLink.toString(), content2);
        if (string2 != null && string2.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TITLE, string2);
        }
        if (string3 != null && string3.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TARGET, string3);
        }
        return htmlTree;
    }

    public Content getHyperLink(DocPath docPath, Content content, String string, String string2) {
        return this.getHyperLink(new DocLink(docPath), content, string, string2);
    }

    public Content getHyperLink(DocLink docLink, Content content, String string, String string2) {
        HtmlTree htmlTree = HtmlTree.A(docLink.toString(), content);
        if (string != null && string.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TITLE, string);
        }
        if (string2 != null && string2.length() != 0) {
            htmlTree.addAttr(HtmlAttr.TARGET, string2);
        }
        return htmlTree;
    }

    public String getPkgName(ClassDoc classDoc) {
        String string = classDoc.containingPackage().name();
        if (string.length() > 0) {
            string = string + ".";
            return string;
        }
        return "";
    }

    public boolean getMemberDetailsListPrinted() {
        return this.memberDetailsListPrinted;
    }

    public void printFramesetDocument(String string, boolean bl, Content content) throws IOException {
        HtmlTree htmlTree;
        DocType docType = DocType.FRAMESET;
        Comment comment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.HEAD);
        ((Content)htmlTree2).addContent(this.getGeneratedBy(!bl));
        if (this.configuration.charset.length() > 0) {
            htmlTree = HtmlTree.META("Content-Type", CONTENT_TYPE, this.configuration.charset);
            ((Content)htmlTree2).addContent(htmlTree);
        }
        htmlTree = HtmlTree.TITLE(new StringContent(string));
        ((Content)htmlTree2).addContent(htmlTree);
        ((Content)htmlTree2).addContent(this.getFramesetJavaScript());
        HtmlTree htmlTree3 = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), htmlTree2, content);
        HtmlDocument htmlDocument = new HtmlDocument(docType, comment, htmlTree3);
        this.write(htmlDocument);
    }

    protected Comment getGeneratedBy(boolean bl) {
        String string = "Generated by javadoc";
        if (bl) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
            Date date = gregorianCalendar.getTime();
            string = string + " (" + this.configuration.getDocletSpecificBuildDate() + ") on " + date;
        }
        return new Comment(string);
    }
}

