/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private final AnnotationTypeDoc annotationTypeDoc;
    private final AnnotationTypeWriter writer;
    private Content contentTree;

    private AnnotationTypeBuilder(AbstractBuilder.Context context, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter annotationTypeWriter) {
        super(context);
        this.annotationTypeDoc = annotationTypeDoc;
        this.writer = annotationTypeWriter;
    }

    public static AnnotationTypeBuilder getInstance(AbstractBuilder.Context context, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return new AnnotationTypeBuilder(context, annotationTypeDoc, annotationTypeWriter);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(XMLNode xMLNode, Content content) throws Exception {
        content = this.writer.getHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
        Content content2 = this.writer.getAnnotationContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
        this.writer.addFooter(content);
        this.writer.printDocument(content);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc packageDoc = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, packageDoc) >= 0 || this.containingPackagesSeen.contains(packageDoc.name()))) {
            Util.copyDocFiles(this.configuration, packageDoc);
            this.containingPackagesSeen.add(packageDoc.name());
        }
    }

    public void buildAnnotationTypeInfo(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getAnnotationInfoTreeHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(this.writer.getAnnotationInfo(content2));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeDeprecationInfo(content);
    }

    public void buildAnnotationTypeSignature(XMLNode xMLNode, Content content) {
        StringBuilder stringBuilder = new StringBuilder(this.annotationTypeDoc.modifiers() + " ");
        this.writer.addAnnotationTypeSignature(Util.replaceText(stringBuilder.toString(), "interface", "@interface"), content);
    }

    public void buildAnnotationTypeDescription(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeDescription(content);
    }

    public void buildAnnotationTypeTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addAnnotationTypeTagInfo(content);
    }

    public void buildMemberSummary(XMLNode xMLNode, Content content) throws Exception {
        Content content2 = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(xMLNode, content2);
        content.addContent(this.writer.getMemberSummaryTree(content2));
    }

    public void buildAnnotationTypeMemberDetails(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getMemberTreeHeader();
        this.buildChildren(xMLNode, content2);
        if (content2.isValid()) {
            content.addContent(this.writer.getMemberDetailsTree(content2));
        }
    }

    public void buildAnnotationTypeFieldDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeFieldsBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildAnnotationTypeOptionalMemberDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildAnnotationTypeRequiredMemberDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).buildChildren(xMLNode, content);
    }
}

