/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.ConstantsSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConstantsSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ConstantSummary";
    public static final int MAX_CONSTANT_VALUE_INDEX_LENGTH = 2;
    protected final ConstantsSummaryWriter writer;
    protected final Set<ClassDoc> classDocsWithConstFields;
    protected Set<String> printedPackageHeaders;
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    private Content contentTree;

    private ConstantsSummaryBuilder(AbstractBuilder.Context context, ConstantsSummaryWriter constantsSummaryWriter) {
        super(context);
        this.writer = constantsSummaryWriter;
        this.classDocsWithConstFields = new HashSet<ClassDoc>();
    }

    public static ConstantsSummaryBuilder getInstance(AbstractBuilder.Context context, ConstantsSummaryWriter constantsSummaryWriter) {
        return new ConstantsSummaryBuilder(context, constantsSummaryWriter);
    }

    @Override
    public void build() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildConstantSummary(XMLNode xMLNode, Content content) throws Exception {
        content = this.writer.getHeader();
        this.buildChildren(xMLNode, content);
        this.writer.addFooter(content);
        this.writer.printDocument(content);
        this.writer.close();
    }

    public void buildContents(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getContentsHeader();
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet<String>();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (!this.hasConstantField(packageDocArray[i]) || this.hasPrintedPackageIndex(packageDocArray[i].name())) continue;
            this.writer.addLinkToPackageContent(packageDocArray[i], this.parsePackageName(packageDocArray[i].name()), this.printedPackageHeaders, content2);
        }
        content.addContent(this.writer.getContentsList(content2));
    }

    public void buildConstantSummaries(XMLNode xMLNode, Content content) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet<String>();
        Content content2 = this.writer.getConstantSummaries();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (!this.hasConstantField(packageDocArray[i])) continue;
            this.currentPackage = packageDocArray[i];
            this.buildChildren(xMLNode, content2);
        }
        content.addContent(content2);
    }

    public void buildPackageHeader(XMLNode xMLNode, Content content) {
        String string = this.parsePackageName(this.currentPackage.name());
        if (!this.printedPackageHeaders.contains(string)) {
            this.writer.addPackageName(this.currentPackage, this.parsePackageName(this.currentPackage.name()), content);
            this.printedPackageHeaders.add(string);
        }
    }

    public void buildClassConstantSummary(XMLNode xMLNode, Content content) {
        Object[] objectArray = this.currentPackage.name().length() > 0 ? this.currentPackage.allClasses() : this.configuration.classDocCatalog.allClasses("<Unnamed>");
        Arrays.sort(objectArray);
        Content content2 = this.writer.getClassConstantHeader();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.classDocsWithConstFields.contains(objectArray[i]) || !objectArray[i].isIncluded()) continue;
            this.currentClass = objectArray[i];
            this.buildChildren(xMLNode, content2);
        }
        content.addContent(content2);
    }

    public void buildConstantMembers(XMLNode xMLNode, Content content) {
        new ConstantFieldBuilder(this.currentClass).buildMembersSummary(xMLNode, content);
    }

    private boolean hasConstantField(PackageDoc packageDoc) {
        ClassDoc[] classDocArray = packageDoc.name().length() > 0 ? packageDoc.allClasses() : this.configuration.classDocCatalog.allClasses("<Unnamed>");
        boolean bl = false;
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!classDocArray[i].isIncluded() || !this.hasConstantField(classDocArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        VisibleMemberMap visibleMemberMap = new VisibleMemberMap(classDoc, 2, this.configuration);
        List<ProgramElementDoc> list = visibleMemberMap.getLeafClassMembers(this.configuration);
        for (FieldDoc fieldDoc : list) {
            if (fieldDoc.constantValueExpression() == null) continue;
            this.classDocsWithConstFields.add(classDoc);
            return true;
        }
        return false;
    }

    private boolean hasPrintedPackageIndex(String string) {
        String[] stringArray = this.printedPackageHeaders.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private String parsePackageName(String string) {
        int n = -1;
        for (int i = 0; i < 2; ++i) {
            n = string.indexOf(".", n + 1);
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private class ConstantFieldBuilder {
        protected VisibleMemberMap visibleMemberMapFields = null;
        protected VisibleMemberMap visibleMemberMapEnumConst = null;
        protected ClassDoc classdoc;

        public ConstantFieldBuilder(ClassDoc classDoc) {
            this.classdoc = classDoc;
            this.visibleMemberMapFields = new VisibleMemberMap(classDoc, 2, ConstantsSummaryBuilder.this.configuration);
            this.visibleMemberMapEnumConst = new VisibleMemberMap(classDoc, 1, ConstantsSummaryBuilder.this.configuration);
        }

        protected void buildMembersSummary(XMLNode xMLNode, Content content) {
            ArrayList<FieldDoc> arrayList = new ArrayList<FieldDoc>(this.members());
            if (arrayList.size() > 0) {
                Collections.sort(arrayList);
                ConstantsSummaryBuilder.this.writer.addConstantMembers(this.classdoc, arrayList, content);
            }
        }

        protected List<FieldDoc> members() {
            List<ProgramElementDoc> list = this.visibleMemberMapFields.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration);
            list.addAll(this.visibleMemberMapEnumConst.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration));
            if (list == null) {
                return null;
            }
            Iterator<ProgramElementDoc> iterator = list.iterator();
            LinkedList<FieldDoc> linkedList = new LinkedList<FieldDoc>();
            while (iterator.hasNext()) {
                FieldDoc fieldDoc = (FieldDoc)iterator.next();
                if (fieldDoc.constantValue() == null) continue;
                linkedList.add(fieldDoc);
            }
            return linkedList;
        }
    }
}

