/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.ProfilePackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;

public class ProfilePackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private final PackageDoc packageDoc;
    private final String profileName;
    private final int profileValue;
    private final ProfilePackageSummaryWriter profilePackageWriter;
    private Content contentTree;

    private ProfilePackageSummaryBuilder(AbstractBuilder.Context context, PackageDoc packageDoc, ProfilePackageSummaryWriter profilePackageSummaryWriter, Profile profile) {
        super(context);
        this.packageDoc = packageDoc;
        this.profilePackageWriter = profilePackageSummaryWriter;
        this.profileName = profile.name;
        this.profileValue = profile.value;
    }

    public static ProfilePackageSummaryBuilder getInstance(AbstractBuilder.Context context, PackageDoc packageDoc, ProfilePackageSummaryWriter profilePackageSummaryWriter, Profile profile) {
        return new ProfilePackageSummaryBuilder(context, packageDoc, profilePackageSummaryWriter, profile);
    }

    @Override
    public void build() throws IOException {
        if (this.profilePackageWriter == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(XMLNode xMLNode, Content content) throws Exception {
        content = this.profilePackageWriter.getPackageHeader(Util.getPackageName(this.packageDoc));
        this.buildChildren(xMLNode, content);
        this.profilePackageWriter.addPackageFooter(content);
        this.profilePackageWriter.printDocument(content);
        this.profilePackageWriter.close();
        Util.copyDocFiles(this.configuration, this.packageDoc);
    }

    public void buildContent(XMLNode xMLNode, Content content) {
        Content content2 = this.profilePackageWriter.getContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
    }

    public void buildSummary(XMLNode xMLNode, Content content) {
        Content content2 = this.profilePackageWriter.getSummaryHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
    }

    public void buildInterfaceSummary(XMLNode xMLNode, Content content) {
        ClassDoc[] classDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.interfaces() : this.configuration.classDocCatalog.interfaces(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Interface_Summary"), string, stringArray, content);
        }
    }

    public void buildClassSummary(XMLNode xMLNode, Content content) {
        ClassDoc[] classDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.ordinaryClasses() : this.configuration.classDocCatalog.ordinaryClasses(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Class_Summary"), string, stringArray, content);
        }
    }

    public void buildEnumSummary(XMLNode xMLNode, Content content) {
        ClassDoc[] classDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.enums() : this.configuration.classDocCatalog.enums(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Enum_Summary"), string, stringArray, content);
        }
    }

    public void buildExceptionSummary(XMLNode xMLNode, Content content) {
        ClassDoc[] classDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.exceptions() : this.configuration.classDocCatalog.exceptions(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Exception_Summary"), string, stringArray, content);
        }
    }

    public void buildErrorSummary(XMLNode xMLNode, Content content) {
        ClassDoc[] classDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.errors() : this.configuration.classDocCatalog.errors(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Error_Summary"), string, stringArray, content);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode xMLNode, Content content) {
        AnnotationTypeDoc[] annotationTypeDocArray;
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description")};
        Object[] objectArray = annotationTypeDocArray = this.packageDoc.isIncluded() ? this.packageDoc.annotationTypes() : this.configuration.classDocCatalog.annotationTypes(Util.getPackageName(this.packageDoc));
        if (annotationTypeDocArray.length > 0) {
            this.profilePackageWriter.addClassesSummary((ClassDoc[])annotationTypeDocArray, this.configuration.getText("doclet.Annotation_Types_Summary"), string, stringArray, content);
        }
    }

    public void buildPackageDescription(XMLNode xMLNode, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        this.profilePackageWriter.addPackageDescription(content);
    }

    public void buildPackageTags(XMLNode xMLNode, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        this.profilePackageWriter.addPackageTags(content);
    }
}

