/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

class SimpleDocFileFactory
extends DocFileFactory {
    public SimpleDocFileFactory(Configuration configuration) {
        super(configuration);
    }

    @Override
    public DocFile createFileForDirectory(String string) {
        return new SimpleDocFile(new File(string));
    }

    @Override
    public DocFile createFileForInput(String string) {
        return new SimpleDocFile(new File(string));
    }

    @Override
    public DocFile createFileForOutput(DocPath docPath) {
        return new SimpleDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, docPath);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath docPath) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> linkedHashSet = new LinkedHashSet<DocFile>();
        for (String string : this.configuration.sourcepath.split(File.pathSeparator)) {
            File file;
            if (string.isEmpty() || !(file = new File(string)).isDirectory() || !(file = new File(file, docPath.getPath())).exists()) continue;
            linkedHashSet.add(new SimpleDocFile(file));
        }
        return linkedHashSet;
    }

    class SimpleDocFile
    extends DocFile {
        private File file;

        private SimpleDocFile(File file) {
            super(SimpleDocFileFactory.this.configuration);
            this.file = file;
        }

        private SimpleDocFile(JavaFileManager.Location location, DocPath docPath) {
            super(SimpleDocFileFactory.this.configuration, location, docPath);
            String string = SimpleDocFileFactory.this.configuration.destDirName;
            this.file = string.isEmpty() ? new File(docPath.getPath()) : new File(string, docPath.getPath());
        }

        @Override
        public InputStream openInputStream() throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            this.createDirectoryForFile(this.file);
            return new BufferedOutputStream(new FileOutputStream(this.file));
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            this.createDirectoryForFile(this.file);
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            if (SimpleDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, SimpleDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return this.file.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.file.canRead();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public boolean isSameFile(DocFile docFile) {
            if (!(docFile instanceof SimpleDocFile)) {
                return false;
            }
            try {
                return this.file.exists() && this.file.getCanonicalFile().equals(((SimpleDocFile)docFile).file.getCanonicalFile());
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() {
            ArrayList<DocFile> arrayList = new ArrayList<DocFile>();
            for (File file : this.file.listFiles()) {
                arrayList.add(new SimpleDocFile(file));
            }
            return arrayList;
        }

        @Override
        public boolean mkdirs() {
            return this.file.mkdirs();
        }

        @Override
        public DocFile resolve(DocPath docPath) {
            return this.resolve(docPath.getPath());
        }

        @Override
        public DocFile resolve(String string) {
            if (this.location == null && this.path == null) {
                return new SimpleDocFile(new File(this.file, string));
            }
            return new SimpleDocFile(this.location, this.path.resolve(string));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location location) {
            if (location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new SimpleDocFile(new File(SimpleDocFileFactory.this.configuration.destDirName, this.file.getPath()));
        }

        private void createDirectoryForFile(File file) {
            File file2 = file.getParentFile();
            if (file2 == null || file2.exists() || file2.mkdirs()) {
                return;
            }
            SimpleDocFileFactory.this.configuration.message.error("doclet.Unable_to_create_directory_0", file2.getPath());
            throw new DocletAbortException("can't create directory");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DocFile[");
            if (this.location != null) {
                stringBuilder.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                stringBuilder.append("path:").append(this.path.getPath()).append(",");
            }
            stringBuilder.append("file:").append(this.file);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

