/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaObject;
import com.sun.tools.hat.internal.model.JavaStatic;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.model.StackFrame;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.util.Misc;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

abstract class QueryHandler {
    protected String urlStart;
    protected String query;
    protected PrintWriter out;
    protected Snapshot snapshot;

    QueryHandler() {
    }

    abstract void run();

    void setUrlStart(String string) {
        this.urlStart = string;
    }

    void setQuery(String string) {
        this.query = string;
    }

    void setOutput(PrintWriter printWriter) {
        this.out = printWriter;
    }

    void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    protected String encodeForURL(String string) {
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    protected void startHtml(String string) {
        this.out.print("<html><title>");
        this.print(string);
        this.out.println("</title>");
        this.out.println("<body bgcolor=\"#ffffff\"><center><h1>");
        this.print(string);
        this.out.println("</h1></center>");
    }

    protected void endHtml() {
        this.out.println("</body></html>");
    }

    protected void error(String string) {
        this.println(string);
    }

    protected void printAnchorStart() {
        this.out.print("<a href=\"");
        this.out.print(this.urlStart);
    }

    protected void printThingAnchorTag(long l) {
        this.printAnchorStart();
        this.out.print("object/");
        this.printHex(l);
        this.out.print("\">");
    }

    protected void printObject(JavaObject javaObject) {
        this.printThing(javaObject);
    }

    protected void printThing(JavaThing javaThing) {
        if (javaThing == null) {
            this.out.print("null");
            return;
        }
        if (javaThing instanceof JavaHeapObject) {
            JavaHeapObject javaHeapObject = (JavaHeapObject)javaThing;
            long l = javaHeapObject.getId();
            if (l != -1L) {
                if (javaHeapObject.isNew()) {
                    this.out.println("<strong>");
                }
                this.printThingAnchorTag(l);
            }
            this.print(javaThing.toString());
            if (l != -1L) {
                if (javaHeapObject.isNew()) {
                    this.out.println("[new]</strong>");
                }
                this.out.print(" (" + javaHeapObject.getSize() + " bytes)");
                this.out.println("</a>");
            }
        } else {
            this.print(javaThing.toString());
        }
    }

    protected void printRoot(Root root) {
        boolean bl;
        StackTrace stackTrace = root.getStackTrace();
        boolean bl2 = bl = stackTrace != null && stackTrace.getFrames().length != 0;
        if (bl) {
            this.printAnchorStart();
            this.out.print("rootStack/");
            this.printHex(root.getIndex());
            this.out.print("\">");
        }
        this.print(root.getDescription());
        if (bl) {
            this.out.print("</a>");
        }
    }

    protected void printClass(JavaClass javaClass) {
        if (javaClass == null) {
            this.out.println("null");
            return;
        }
        this.printAnchorStart();
        this.out.print("class/");
        this.print(this.encodeForURL(javaClass));
        this.out.print("\">");
        this.print(javaClass.toString());
        this.out.println("</a>");
    }

    protected String encodeForURL(JavaClass javaClass) {
        if (javaClass.getId() == -1L) {
            return this.encodeForURL(javaClass.getName());
        }
        return javaClass.getIdString();
    }

    protected void printField(JavaField javaField) {
        this.print(javaField.getName() + " (" + javaField.getSignature() + ")");
    }

    protected void printStatic(JavaStatic javaStatic) {
        JavaField javaField = javaStatic.getField();
        this.printField(javaField);
        this.out.print(" : ");
        if (javaField.hasId()) {
            JavaThing javaThing = javaStatic.getValue();
            this.printThing(javaThing);
        } else {
            this.print(javaStatic.getValue().toString());
        }
    }

    protected void printStackTrace(StackTrace stackTrace) {
        StackFrame[] stackFrameArray = stackTrace.getFrames();
        for (int i = 0; i < stackFrameArray.length; ++i) {
            StackFrame stackFrame = stackFrameArray[i];
            String string = stackFrame.getClassName();
            this.out.print("<font color=purple>");
            this.print(string);
            this.out.print("</font>");
            this.print("." + stackFrame.getMethodName() + "(" + stackFrame.getMethodSignature() + ")");
            this.out.print(" <bold>:</bold> ");
            this.print(stackFrame.getSourceFileName() + " line " + stackFrame.getLineNumber());
            this.out.println("<br>");
        }
    }

    protected void printException(Throwable throwable) {
        this.println(throwable.getMessage());
        this.out.println("<pre>");
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        this.print(stringWriter.toString());
        this.out.println("</pre>");
    }

    protected void printHex(long l) {
        if (this.snapshot.getIdentifierSize() == 4) {
            this.out.print(Misc.toHex((int)l));
        } else {
            this.out.print(Misc.toHex(l));
        }
    }

    protected long parseHex(String string) {
        return Misc.parseHex(string);
    }

    protected void print(String string) {
        this.out.print(Misc.encodeHtml(string));
    }

    protected void println(String string) {
        this.out.println(Misc.encodeHtml(string));
    }
}

