/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DeferredAttr
extends JCTree.Visitor {
    protected static final Context.Key<DeferredAttr> deferredAttrKey = new Context.Key();
    final Attr attr;
    final Check chk;
    final JCDiagnostic.Factory diags;
    final Enter enter;
    final Infer infer;
    final Resolve rs;
    final Log log;
    final Symtab syms;
    final TreeMaker make;
    final Types types;
    final Flow flow;
    final Names names;
    final TypeEnvs typeEnvs;
    final JCTree stuckTree;
    DeferredTypeCompleter basicCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    Assert.check(deferredType.mode == null || deferredType.mode == AttrMode.SPECULATIVE);
                    JCTree jCTree = DeferredAttr.this.attribSpeculative(deferredType.tree, deferredType.env, resultInfo);
                    deferredType.speculativeCache.put(jCTree, resultInfo);
                    return jCTree.type;
                }
                case CHECK: {
                    Assert.check(deferredType.mode != null);
                    return DeferredAttr.this.attr.attribTree(deferredType.tree, deferredType.env, resultInfo);
                }
            }
            Assert.error();
            return null;
        }
    };
    DeferredTypeCompleter dummyCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            Assert.check(deferredAttrContext.mode == AttrMode.CHECK);
            deferredType.tree.type = Type.stuckType;
            return deferredType.tree.type;
        }
    };
    DeferredStuckPolicy dummyStuckPolicy = new DeferredStuckPolicy(){

        @Override
        public boolean isStuck() {
            return false;
        }

        @Override
        public Set<Type> stuckVars() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> depVars() {
            return Collections.emptySet();
        }
    };
    protected UnenterScanner unenterScanner = new UnenterScanner();
    final DeferredAttrContext emptyDeferredAttrContext;
    private EnumSet<JCTree.Tag> deferredCheckerTags = EnumSet.of(JCTree.Tag.LAMBDA, new JCTree.Tag[]{JCTree.Tag.REFERENCE, JCTree.Tag.PARENS, JCTree.Tag.TYPECAST, JCTree.Tag.CONDEXPR, JCTree.Tag.NEWCLASS, JCTree.Tag.APPLY, JCTree.Tag.LITERAL});

    public static DeferredAttr instance(Context context) {
        DeferredAttr deferredAttr = context.get(deferredAttrKey);
        if (deferredAttr == null) {
            deferredAttr = new DeferredAttr(context);
        }
        return deferredAttr;
    }

    protected DeferredAttr(Context context) {
        context.put(deferredAttrKey, this);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.flow = Flow.instance(context);
        this.names = Names.instance(context);
        this.stuckTree = this.make.Ident(this.names.empty).setType(Type.stuckType);
        this.typeEnvs = TypeEnvs.instance(context);
        this.emptyDeferredAttrContext = new DeferredAttrContext(AttrMode.CHECK, null, Resolve.MethodResolutionPhase.BOX, this.infer.emptyContext, null, null){

            @Override
            void addDeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
                Assert.error("Empty deferred context!");
            }

            @Override
            void complete() {
                Assert.error("Empty deferred context!");
            }

            public String toString() {
                return "Empty deferred context!";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree attribSpeculative(JCTree jCTree, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        final JCTree jCTree2 = new TreeCopier(this.make).copy(jCTree);
        Env<AttrContext> env2 = env.dup(jCTree2, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared()));
        ((AttrContext)env2.info).scope.owner = ((AttrContext)env.info).scope.owner;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log, new Filter<JCDiagnostic>(){

            @Override
            public boolean accepts(final JCDiagnostic jCDiagnostic) {
                class PosScanner
                extends TreeScanner {
                    boolean found = false;

                    PosScanner() {
                    }

                    @Override
                    public void scan(JCTree jCTree) {
                        if (jCTree != null && jCTree.pos() == jCDiagnostic.getDiagnosticPosition()) {
                            this.found = true;
                        }
                        super.scan(jCTree);
                    }
                }
                PosScanner posScanner = new PosScanner();
                posScanner.scan(jCTree2);
                return posScanner.found;
            }
        });
        try {
            this.attr.attribTree(jCTree2, env2, resultInfo);
            this.unenterScanner.scan(jCTree2);
            JCTree jCTree3 = jCTree2;
            return jCTree3;
        }
        finally {
            this.unenterScanner.scan(jCTree2);
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
    }

    boolean isDeferred(Env<AttrContext> env, JCTree.JCExpression jCExpression) {
        DeferredChecker deferredChecker = new DeferredChecker(env);
        deferredChecker.scan(jCExpression);
        return deferredChecker.result.isPoly();
    }

    static interface MethodAnalyzer<E> {
        public E process(Symbol.MethodSymbol var1);

        public E reduce(E var1, E var2);

        public boolean shouldStop(E var1);
    }

    final class DeferredChecker
    extends FilterScanner {
        Env<AttrContext> env;
        ArgumentExpressionKind result;
        MethodAnalyzer<ArgumentExpressionKind> argumentKindAnalyzer;
        MethodAnalyzer<Symbol> returnSymbolAnalyzer;

        public DeferredChecker(Env<AttrContext> env) {
            super(DeferredAttr.this.deferredCheckerTags);
            this.argumentKindAnalyzer = new MethodAnalyzer<ArgumentExpressionKind>(){

                @Override
                public ArgumentExpressionKind process(Symbol.MethodSymbol methodSymbol) {
                    return ArgumentExpressionKind.methodKind(methodSymbol, DeferredAttr.this.types);
                }

                @Override
                public ArgumentExpressionKind reduce(ArgumentExpressionKind argumentExpressionKind, ArgumentExpressionKind argumentExpressionKind2) {
                    switch (argumentExpressionKind) {
                        case PRIMITIVE: {
                            return argumentExpressionKind2;
                        }
                        case NO_POLY: {
                            return argumentExpressionKind2.isPoly() ? argumentExpressionKind2 : argumentExpressionKind;
                        }
                        case POLY: {
                            return argumentExpressionKind;
                        }
                    }
                    Assert.error();
                    return null;
                }

                @Override
                public boolean shouldStop(ArgumentExpressionKind argumentExpressionKind) {
                    return argumentExpressionKind.isPoly();
                }
            };
            this.returnSymbolAnalyzer = new MethodAnalyzer<Symbol>(){

                @Override
                public Symbol process(Symbol.MethodSymbol methodSymbol) {
                    ArgumentExpressionKind argumentExpressionKind = ArgumentExpressionKind.methodKind(methodSymbol, DeferredAttr.this.types);
                    if (argumentExpressionKind == ArgumentExpressionKind.POLY || methodSymbol.getReturnType().hasTag(TypeTag.TYPEVAR)) {
                        return null;
                    }
                    return methodSymbol.getReturnType().tsym;
                }

                @Override
                public Symbol reduce(Symbol symbol, Symbol symbol2) {
                    return symbol == DeferredAttr.this.syms.errSymbol ? symbol2 : (symbol == symbol2 ? symbol : null);
                }

                @Override
                public boolean shouldStop(Symbol symbol) {
                    return symbol == null;
                }
            };
            this.env = env;
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            this.result = ArgumentExpressionKind.POLY;
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            Symbol symbol;
            Env<AttrContext> env = this.env.dup(jCMemberReference);
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(jCMemberReference.getQualifierExpression(), env, DeferredAttr.this.attr.memberReferenceQualifierResult(jCMemberReference));
            JCTree.JCMemberReference jCMemberReference2 = new TreeCopier(DeferredAttr.this.make).copy(jCMemberReference);
            jCMemberReference2.expr = jCExpression;
            jCMemberReference.sym = symbol = DeferredAttr.this.rs.getMemberReference(jCMemberReference, env, jCMemberReference2, jCExpression.type, jCMemberReference.name);
            jCMemberReference.overloadKind = symbol.kind >= 128 || symbol.type.hasTag(TypeTag.FORALL) || (symbol.flags() & 0x400000000L) != 0L || TreeInfo.isStaticSelector(jCExpression, jCMemberReference.name.table.names) && jCExpression.type.isRaw() ? JCTree.JCMemberReference.OverloadKind.OVERLOADED : JCTree.JCMemberReference.OverloadKind.UNOVERLOADED;
            this.result = ArgumentExpressionKind.POLY;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            this.result = ArgumentExpressionKind.NO_POLY;
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            this.scan(jCConditional.truepart);
            if (!this.result.isPrimitive()) {
                this.result = ArgumentExpressionKind.POLY;
                return;
            }
            this.scan(jCConditional.falsepart);
            this.result = this.reduce(ArgumentExpressionKind.PRIMITIVE);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.result = TreeInfo.isDiamond(jCNewClass) || DeferredAttr.this.attr.findDiamonds ? ArgumentExpressionKind.POLY : ArgumentExpressionKind.NO_POLY;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            Name name = TreeInfo.name(jCMethodInvocation.meth);
            if (jCMethodInvocation.typeargs.nonEmpty() || name == name.table.names._this || name == name.table.names._super) {
                this.result = ArgumentExpressionKind.NO_POLY;
                return;
            }
            Symbol symbol = this.quicklyResolveMethod(this.env, jCMethodInvocation);
            if (symbol == null) {
                this.result = ArgumentExpressionKind.POLY;
                return;
            }
            this.result = this.analyzeCandidateMethods(symbol, ArgumentExpressionKind.PRIMITIVE, this.argumentKindAnalyzer);
        }

        private boolean isSimpleReceiver(JCTree jCTree) {
            switch (jCTree.getTag()) {
                case IDENT: {
                    return true;
                }
                case SELECT: {
                    return this.isSimpleReceiver(((JCTree.JCFieldAccess)jCTree).selected);
                }
                case TYPEAPPLY: 
                case TYPEARRAY: {
                    return true;
                }
                case ANNOTATED_TYPE: {
                    return this.isSimpleReceiver(((JCTree.JCAnnotatedType)jCTree).underlyingType);
                }
                case APPLY: {
                    return true;
                }
            }
            return false;
        }

        private ArgumentExpressionKind reduce(ArgumentExpressionKind argumentExpressionKind) {
            return this.argumentKindAnalyzer.reduce(this.result, argumentExpressionKind);
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral jCLiteral) {
            Type type = DeferredAttr.this.attr.litType(jCLiteral.typetag);
            this.result = ArgumentExpressionKind.standaloneKind(type, DeferredAttr.this.types);
        }

        @Override
        void skip(JCTree jCTree) {
            this.result = ArgumentExpressionKind.NO_POLY;
        }

        private Symbol quicklyResolveMethod(Env<AttrContext> env, JCTree.JCMethodInvocation jCMethodInvocation) {
            Type type;
            Object object;
            Object object2;
            JCTree.JCExpression jCExpression;
            JCTree.JCExpression jCExpression2 = jCExpression = jCMethodInvocation.meth.hasTag(JCTree.Tag.SELECT) ? ((JCTree.JCFieldAccess)jCMethodInvocation.meth).selected : null;
            if (jCExpression != null && !this.isSimpleReceiver(jCExpression)) {
                return null;
            }
            if (jCExpression != null) {
                if (jCExpression.hasTag(JCTree.Tag.APPLY)) {
                    object2 = this.quicklyResolveMethod(env, (JCTree.JCMethodInvocation)jCExpression);
                    if (object2 == null) {
                        return null;
                    }
                    object = this.analyzeCandidateMethods((Symbol)object2, DeferredAttr.this.syms.errSymbol, this.returnSymbolAnalyzer);
                    if (object == null) {
                        return null;
                    }
                    type = ((Symbol)object).type;
                } else {
                    type = DeferredAttr.this.attribSpeculative((JCTree)jCExpression, env, (Attr.ResultInfo)DeferredAttr.this.attr.unknownTypeExprInfo).type;
                }
            } else {
                type = env.enclClass.sym.type;
            }
            while (type.hasTag(TypeTag.TYPEVAR)) {
                type = type.getUpperBound();
            }
            type = DeferredAttr.this.types.capture(type);
            object2 = DeferredAttr.this.rs.dummyArgs(jCMethodInvocation.args.length());
            object = TreeInfo.name(jCMethodInvocation.meth);
            Resolve resolve = DeferredAttr.this.rs;
            resolve.getClass();
            Resolve.LookupHelper lookupHelper = new Resolve.LookupHelper(resolve, (Name)object, type, (List)object2, List.nil(), Resolve.MethodResolutionPhase.VARARITY){
                {
                    Resolve resolve2 = resolve;
                    resolve2.getClass();
                    super(resolve2, name, type, list, list2, methodResolutionPhase);
                }

                @Override
                Symbol lookup(Env<AttrContext> env, Resolve.MethodResolutionPhase methodResolutionPhase) {
                    return jCExpression == null ? DeferredAttr.this.rs.findFun(env, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired()) : DeferredAttr.this.rs.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), false);
                }

                @Override
                Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
                    return symbol2;
                }
            };
            return DeferredAttr.this.rs.lookupMethod(env, (JCDiagnostic.DiagnosticPosition)jCMethodInvocation, (Symbol)type.tsym, DeferredAttr.this.rs.arityMethodCheck, lookupHelper);
        }

        <E> E analyzeCandidateMethods(Symbol symbol, E e, MethodAnalyzer<E> methodAnalyzer) {
            switch (symbol.kind) {
                case 16: {
                    return methodAnalyzer.process((Symbol.MethodSymbol)symbol);
                }
                case 129: {
                    Resolve.AmbiguityError ambiguityError = (Resolve.AmbiguityError)symbol.baseSymbol();
                    E e2 = e;
                    for (Symbol symbol2 : ambiguityError.ambiguousSyms) {
                        if (symbol2.kind != 16 || !methodAnalyzer.shouldStop(e2 = methodAnalyzer.reduce(e2, methodAnalyzer.process((Symbol.MethodSymbol)symbol2)))) continue;
                        return e2;
                    }
                    return e2;
                }
            }
            return e;
        }
    }

    static enum ArgumentExpressionKind {
        POLY,
        NO_POLY,
        PRIMITIVE;


        public final boolean isPoly() {
            return this == POLY;
        }

        public final boolean isPrimitive() {
            return this == PRIMITIVE;
        }

        static ArgumentExpressionKind standaloneKind(Type type, Types types) {
            return types.unboxedTypeOrType(type).isPrimitive() ? PRIMITIVE : NO_POLY;
        }

        static ArgumentExpressionKind methodKind(Symbol symbol, Types types) {
            Type type = symbol.type.getReturnType();
            if (symbol.type.hasTag(TypeTag.FORALL) && type.containsAny(((Type.ForAll)symbol.type).tvars)) {
                return POLY;
            }
            return ArgumentExpressionKind.standaloneKind(type, types);
        }
    }

    class OverloadStuckPolicy
    extends CheckStuckPolicy
    implements DeferredStuckPolicy {
        boolean stuck;

        @Override
        public boolean isStuck() {
            return super.isStuck() || this.stuck;
        }

        public OverloadStuckPolicy(Attr.ResultInfo resultInfo, DeferredType deferredType) {
            super(resultInfo, deferredType);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            super.visitLambda(jCLambda);
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.stuck = true;
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            super.visitReference(jCMemberReference);
            if (jCMemberReference.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuck = true;
            }
        }
    }

    class CheckStuckPolicy
    extends PolyScanner
    implements DeferredStuckPolicy,
    Infer.FreeTypeListener {
        Type pt;
        Infer.InferenceContext inferenceContext;
        Set<Type> stuckVars = new LinkedHashSet<Type>();
        Set<Type> depVars = new LinkedHashSet<Type>();

        @Override
        public boolean isStuck() {
            return !this.stuckVars.isEmpty();
        }

        @Override
        public Set<Type> stuckVars() {
            return this.stuckVars;
        }

        @Override
        public Set<Type> depVars() {
            return this.depVars;
        }

        public CheckStuckPolicy(Attr.ResultInfo resultInfo, DeferredType deferredType) {
            this.pt = resultInfo.pt;
            this.inferenceContext = resultInfo.checkContext.inferenceContext();
            this.scan(deferredType.tree);
            if (!this.stuckVars.isEmpty()) {
                resultInfo.checkContext.inferenceContext().addFreeTypeListener(List.from(this.stuckVars), this);
            }
        }

        @Override
        public void typesInferred(Infer.InferenceContext inferenceContext) {
            this.stuckVars.clear();
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type type = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> list = this.inferenceContext.freeVarsIn(type.getParameterTypes());
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && list.nonEmpty()) {
                this.stuckVars.addAll(list);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(type.getReturnType()));
            }
            this.scanLambdaBody(jCLambda, type.getReturnType());
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            this.scan(jCMemberReference.expr);
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
                return;
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type type = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> list = this.inferenceContext.freeVarsIn(type.getParameterTypes());
            if (list.nonEmpty() && jCMemberReference.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuckVars.addAll(list);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(type.getReturnType()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scanLambdaBody(JCTree.JCLambda jCLambda, final Type type) {
            if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Type type2 = this.pt;
                try {
                    this.pt = type;
                    this.scan(jCLambda.body);
                }
                finally {
                    this.pt = type2;
                }
            } else {
                LambdaReturnScanner lambdaReturnScanner = new LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn jCReturn) {
                        if (jCReturn.expr != null) {
                            Type type2 = CheckStuckPolicy.this.pt;
                            try {
                                CheckStuckPolicy.this.pt = type;
                                CheckStuckPolicy.this.scan(jCReturn.expr);
                            }
                            finally {
                                CheckStuckPolicy.this.pt = type2;
                            }
                        }
                    }
                };
                lambdaReturnScanner.scan(jCLambda.body);
            }
        }
    }

    static class LambdaReturnScanner
    extends FilterScanner {
        LambdaReturnScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.IF, JCTree.Tag.RETURN, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP}));
        }
    }

    static class PolyScanner
    extends FilterScanner {
        PolyScanner() {
            super(EnumSet.of(JCTree.Tag.CONDEXPR, JCTree.Tag.PARENS, JCTree.Tag.LAMBDA, JCTree.Tag.REFERENCE));
        }
    }

    static abstract class FilterScanner
    extends TreeScanner {
        final Filter<JCTree> treeFilter;

        FilterScanner(final Set<JCTree.Tag> set) {
            this.treeFilter = new Filter<JCTree>(){

                @Override
                public boolean accepts(JCTree jCTree) {
                    return set.contains((Object)jCTree.getTag());
                }
            };
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null) {
                if (this.treeFilter.accepts(jCTree)) {
                    super.scan(jCTree);
                } else {
                    this.skip(jCTree);
                }
            }
        }

        void skip(JCTree jCTree) {
        }
    }

    public class RecoveryDeferredTypeMap
    extends DeferredTypeMap {
        public RecoveryDeferredTypeMap(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            super(attrMode, symbol, methodResolutionPhase != null ? methodResolutionPhase : Resolve.MethodResolutionPhase.BOX);
        }

        @Override
        protected Type typeOf(DeferredType deferredType) {
            Type type = super.typeOf(deferredType);
            return type == Type.noType ? this.recover(deferredType) : type;
        }

        private Type recover(DeferredType deferredType) {
            Attr attr = DeferredAttr.this.attr;
            attr.getClass();
            deferredType.check(new Attr.RecoveryInfo(attr, this.deferredAttrContext){
                {
                    Attr attr2 = attr;
                    attr2.getClass();
                    super(deferredAttrContext);
                }

                @Override
                protected Type check(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
                    return DeferredAttr.this.chk.checkNonVoid(diagnosticPosition, super.check(diagnosticPosition, type));
                }
            });
            return super.apply(deferredType);
        }
    }

    class DeferredTypeMap
    extends Type.Mapping {
        DeferredAttrContext deferredAttrContext;

        protected DeferredTypeMap(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            super(String.format("deferredTypeMap[%s]", new Object[]{attrMode}));
            this.deferredAttrContext = new DeferredAttrContext(attrMode, symbol, methodResolutionPhase, DeferredAttr.this.infer.emptyContext, DeferredAttr.this.emptyDeferredAttrContext, DeferredAttr.this.types.noWarnings);
        }

        @Override
        public Type apply(Type type) {
            if (!type.hasTag(TypeTag.DEFERRED)) {
                return type.map(this);
            }
            DeferredType deferredType = (DeferredType)type;
            return this.typeOf(deferredType);
        }

        protected Type typeOf(DeferredType deferredType) {
            switch (this.deferredAttrContext.mode) {
                case CHECK: {
                    return deferredType.tree.type == null ? Type.noType : deferredType.tree.type;
                }
                case SPECULATIVE: {
                    return deferredType.speculativeType(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                }
            }
            Assert.error();
            return null;
        }
    }

    class DeferredAttrNode {
        DeferredType dt;
        Attr.ResultInfo resultInfo;
        DeferredStuckPolicy deferredStuckPolicy;

        DeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.dt = deferredType;
            this.resultInfo = resultInfo;
            this.deferredStuckPolicy = deferredStuckPolicy;
        }

        boolean process(final DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        this.dt.check(this.resultInfo, DeferredAttr.this.dummyStuckPolicy, new StructuralStuckChecker());
                        return true;
                    }
                    Assert.error("Cannot get here");
                }
                case CHECK: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        if (deferredAttrContext.parent != DeferredAttr.this.emptyDeferredAttrContext && Type.containsAny(deferredAttrContext.parent.inferenceContext.inferencevars, List.from(this.deferredStuckPolicy.stuckVars()))) {
                            deferredAttrContext.parent.addDeferredAttrNode(this.dt, this.resultInfo.dup(new Check.NestedCheckContext(this.resultInfo.checkContext){

                                @Override
                                public Infer.InferenceContext inferenceContext() {
                                    return deferredAttrContext.parent.inferenceContext;
                                }

                                @Override
                                public DeferredAttrContext deferredAttrContext() {
                                    return deferredAttrContext.parent;
                                }
                            }), this.deferredStuckPolicy);
                            this.dt.tree.type = Type.stuckType;
                            return true;
                        }
                        return false;
                    }
                    Assert.check(!deferredAttrContext.insideOverloadPhase(), "attribution shouldn't be happening here");
                    Attr.ResultInfo resultInfo = this.resultInfo.dup(deferredAttrContext.inferenceContext.asInstType(this.resultInfo.pt));
                    this.dt.check(resultInfo, DeferredAttr.this.dummyStuckPolicy, DeferredAttr.this.basicCompleter);
                    return true;
                }
            }
            throw new AssertionError((Object)"Bad mode");
        }

        class LambdaBodyStructChecker
        extends TreeScanner {
            boolean isVoidCompatible = true;
            boolean isPotentiallyValueCompatible = true;

            LambdaBodyStructChecker() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                if (jCReturn.expr != null) {
                    this.isVoidCompatible = false;
                } else {
                    this.isPotentiallyValueCompatible = false;
                }
            }
        }

        class StructuralStuckChecker
        extends TreeScanner
        implements DeferredTypeCompleter {
            Attr.ResultInfo resultInfo;
            Infer.InferenceContext inferenceContext;
            Env<AttrContext> env;

            StructuralStuckChecker() {
            }

            @Override
            public Type complete(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
                this.resultInfo = resultInfo;
                this.inferenceContext = deferredAttrContext.inferenceContext;
                this.env = deferredType.env;
                deferredType.tree.accept(this);
                deferredType.speculativeCache.put(DeferredAttr.this.stuckTree, resultInfo);
                return Type.noType;
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type type = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(type)) {
                    Type type2 = null;
                    try {
                        type2 = DeferredAttr.this.types.findDescriptorType(type);
                    }
                    catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                        checkContext.report(null, functionDescriptorLookupError.getDiagnostic());
                    }
                    if (type2.getParameterTypes().length() != jCLambda.params.length()) {
                        checkContext.report(jCLambda, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
                    }
                    Type type3 = type2.getReturnType();
                    boolean bl = type3.hasTag(TypeTag.VOID);
                    if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        boolean bl2;
                        boolean bl3 = bl2 = !bl || TreeInfo.isExpressionStatement((JCTree.JCExpression)jCLambda.getBody());
                        if (!bl2) {
                            this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", type3)));
                        }
                    } else {
                        LambdaBodyStructChecker lambdaBodyStructChecker = new LambdaBodyStructChecker();
                        jCLambda.body.accept(lambdaBodyStructChecker);
                        boolean bl4 = lambdaBodyStructChecker.isVoidCompatible;
                        if (bl) {
                            if (!bl4) {
                                this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("unexpected.ret.val", new Object[0]));
                            }
                        } else {
                            boolean bl5;
                            boolean bl6 = bl5 = lambdaBodyStructChecker.isPotentiallyValueCompatible && !this.canLambdaBodyCompleteNormally(jCLambda);
                            if (!bl5 && !bl4) {
                                DeferredAttr.this.log.error(jCLambda.body.pos(), "lambda.body.neither.value.nor.void.compatible", new Object[0]);
                            }
                            if (!bl5) {
                                this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", type3)));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean canLambdaBodyCompleteNormally(JCTree.JCLambda jCLambda) {
                boolean bl;
                JCTree.JCLambda jCLambda2 = new TreeCopier(DeferredAttr.this.make).copy(jCLambda);
                Env<AttrContext> env = DeferredAttr.this.attr.lambdaEnv(jCLambda2, this.env);
                try {
                    Attr.ResultInfo resultInfo;
                    List<JCTree.JCVariableDecl> list = jCLambda2.params;
                    while (list.nonEmpty()) {
                        ((JCTree.JCVariableDecl)list.head).vartype = DeferredAttr.this.make.at((JCDiagnostic.DiagnosticPosition)list.head).Type(DeferredAttr.this.syms.errType);
                        list = list.tail;
                    }
                    DeferredAttr.this.attr.attribStats(jCLambda2.params, env);
                    Attr attr = DeferredAttr.this.attr;
                    attr.getClass();
                    ((AttrContext)env.info).returnResult = resultInfo = attr.new Attr.ResultInfo(12, Type.noType);
                    Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(DeferredAttr.this.log);
                    try {
                        JCTree.JCBlock jCBlock = (JCTree.JCBlock)jCLambda2.body;
                        DeferredAttr.this.attr.attribStats(jCBlock.stats, env);
                        DeferredAttr.this.attr.preFlow(jCLambda2);
                        DeferredAttr.this.flow.analyzeLambda(env, jCLambda2, DeferredAttr.this.make, true);
                    }
                    finally {
                        DeferredAttr.this.log.popDiagnosticHandler(discardDiagnosticHandler);
                    }
                    bl = jCLambda2.canCompleteNormally;
                }
                catch (Throwable throwable) {
                    JCTree.JCBlock jCBlock = (JCTree.JCBlock)jCLambda2.body;
                    DeferredAttr.this.unenterScanner.scan(jCBlock.stats);
                    ((AttrContext)env.info).scope.leave();
                    throw throwable;
                }
                JCTree.JCBlock jCBlock = (JCTree.JCBlock)jCLambda2.body;
                DeferredAttr.this.unenterScanner.scan(jCBlock.stats);
                ((AttrContext)env.info).scope.leave();
                return bl;
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            }

            @Override
            public void visitReference(JCTree.JCMemberReference jCMemberReference) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type type = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(type)) {
                    AnnoConstruct annoConstruct2;
                    try {
                        DeferredAttr.this.types.findDescriptorType(type);
                    }
                    catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                        checkContext.report(null, functionDescriptorLookupError.getDiagnostic());
                    }
                    Env<AttrContext> env = this.env.dup(jCMemberReference);
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(jCMemberReference.getQualifierExpression(), env, DeferredAttr.this.attr.memberReferenceQualifierResult(jCMemberReference));
                    ListBuffer<Type.JCNoType> listBuffer = new ListBuffer<Type.JCNoType>();
                    for (AnnoConstruct annoConstruct2 : DeferredAttr.this.types.findDescriptorType(type).getParameterTypes()) {
                        listBuffer.append(Type.noType);
                    }
                    JCTree.JCMemberReference jCMemberReference2 = new TreeCopier(DeferredAttr.this.make).copy(jCMemberReference);
                    jCMemberReference2.expr = jCExpression;
                    annoConstruct2 = DeferredAttr.this.rs.resolveMemberReferenceByArity(env, jCMemberReference2, jCExpression.type, jCMemberReference.name, listBuffer.toList(), this.inferenceContext);
                    switch (((Symbol)annoConstruct2).kind) {
                        case 134: 
                        case 135: 
                        case 136: 
                        case 138: {
                            checkContext.report(jCMemberReference, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.mref", new Object[0]));
                        }
                    }
                }
            }
        }
    }

    class DeferredAttrContext {
        final AttrMode mode;
        final Symbol msym;
        final Resolve.MethodResolutionPhase phase;
        final Infer.InferenceContext inferenceContext;
        final DeferredAttrContext parent;
        final Warner warn;
        ArrayList<DeferredAttrNode> deferredAttrNodes = new ArrayList();

        DeferredAttrContext(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase, Infer.InferenceContext inferenceContext, DeferredAttrContext deferredAttrContext, Warner warner) {
            this.mode = attrMode;
            this.msym = symbol;
            this.phase = methodResolutionPhase;
            this.parent = deferredAttrContext;
            this.warn = warner;
            this.inferenceContext = inferenceContext;
        }

        void addDeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.deferredAttrNodes.add(new DeferredAttrNode(deferredType, resultInfo, deferredStuckPolicy));
        }

        void complete() {
            while (!this.deferredAttrNodes.isEmpty()) {
                LinkedHashMap<Type, Set<Type>> linkedHashMap = new LinkedHashMap<Type, Set<Type>>();
                List<Type> list = List.nil();
                boolean bl = false;
                for (DeferredAttrNode deferredAttrNode : List.from(this.deferredAttrNodes)) {
                    if (!deferredAttrNode.process(this)) {
                        List<Type> list2 = List.from(deferredAttrNode.deferredStuckPolicy.stuckVars()).intersect(this.inferenceContext.restvars());
                        list = list.prependList(list2);
                        for (Type type : List.from(deferredAttrNode.deferredStuckPolicy.depVars()).intersect(this.inferenceContext.restvars())) {
                            LinkedHashSet<Type> linkedHashSet = (LinkedHashSet<Type>)linkedHashMap.get(type);
                            if (linkedHashSet == null) {
                                linkedHashSet = new LinkedHashSet<Type>();
                                linkedHashMap.put(type, linkedHashSet);
                            }
                            linkedHashSet.addAll(list2);
                        }
                        continue;
                    }
                    this.deferredAttrNodes.remove(deferredAttrNode);
                    bl = true;
                }
                if (bl) continue;
                if (this.insideOverloadPhase()) {
                    for (DeferredAttrNode deferredAttrNode : this.deferredAttrNodes) {
                        deferredAttrNode.dt.tree.type = Type.noType;
                    }
                    return;
                }
                try {
                    this.inferenceContext.solveAny(list, linkedHashMap, this.warn);
                    this.inferenceContext.notifyChange();
                }
                catch (Infer.GraphStrategy.NodeNotFoundException nodeNotFoundException) {
                    break;
                }
            }
        }

        private boolean insideOverloadPhase() {
            DeferredAttrContext deferredAttrContext = this;
            if (deferredAttrContext == DeferredAttr.this.emptyDeferredAttrContext) {
                return false;
            }
            if (deferredAttrContext.mode == AttrMode.SPECULATIVE) {
                return true;
            }
            return deferredAttrContext.parent.insideOverloadPhase();
        }
    }

    class UnenterScanner
    extends TreeScanner {
        UnenterScanner() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            if (classSymbol == null) {
                return;
            }
            DeferredAttr.this.typeEnvs.remove(classSymbol);
            DeferredAttr.this.chk.compiled.remove(classSymbol.flatname);
            DeferredAttr.this.syms.classes.remove(classSymbol.flatname);
            super.visitClassDef(jCClassDecl);
        }
    }

    public static enum AttrMode {
        SPECULATIVE,
        CHECK;

    }

    static interface DeferredStuckPolicy {
        public boolean isStuck();

        public Set<Type> stuckVars();

        public Set<Type> depVars();
    }

    static interface DeferredTypeCompleter {
        public Type complete(DeferredType var1, Attr.ResultInfo var2, DeferredAttrContext var3);
    }

    public class DeferredType
    extends Type {
        public JCTree.JCExpression tree;
        Env<AttrContext> env;
        AttrMode mode;
        SpeculativeCache speculativeCache;

        DeferredType(JCTree.JCExpression jCExpression, Env<AttrContext> env) {
            super(null);
            this.tree = jCExpression;
            this.env = DeferredAttr.this.attr.copyEnv(env);
            this.speculativeCache = new SpeculativeCache();
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.DEFERRED;
        }

        @Override
        public String toString() {
            return "DeferredType";
        }

        Type speculativeType(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            SpeculativeCache.Entry entry = this.speculativeCache.get(symbol, methodResolutionPhase);
            return entry != null ? entry.speculativeTree.type : Type.noType;
        }

        Type check(Attr.ResultInfo resultInfo) {
            DeferredStuckPolicy deferredStuckPolicy = resultInfo.pt.hasTag(TypeTag.NONE) || resultInfo.pt.isErroneous() ? DeferredAttr.this.dummyStuckPolicy : (resultInfo.checkContext.deferredAttrContext().mode == AttrMode.SPECULATIVE ? new OverloadStuckPolicy(resultInfo, this) : new CheckStuckPolicy(resultInfo, this));
            return this.check(resultInfo, deferredStuckPolicy, DeferredAttr.this.basicCompleter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Type check(Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy, DeferredTypeCompleter deferredTypeCompleter) {
            DeferredAttrContext deferredAttrContext = resultInfo.checkContext.deferredAttrContext();
            Assert.check(deferredAttrContext != DeferredAttr.this.emptyDeferredAttrContext);
            if (deferredStuckPolicy.isStuck()) {
                deferredAttrContext.addDeferredAttrNode(this, resultInfo, deferredStuckPolicy);
                return Type.noType;
            }
            try {
                Type type = deferredTypeCompleter.complete(this, resultInfo, deferredAttrContext);
                return type;
            }
            finally {
                this.mode = deferredAttrContext.mode;
            }
        }

        class SpeculativeCache {
            private Map<Symbol, List<Entry>> cache = new WeakHashMap<Symbol, List<Entry>>();

            SpeculativeCache() {
            }

            Entry get(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
                List<Entry> list = this.cache.get(symbol);
                if (list == null) {
                    return null;
                }
                for (Entry entry : list) {
                    if (!entry.matches(methodResolutionPhase)) continue;
                    return entry;
                }
                return null;
            }

            void put(JCTree jCTree, Attr.ResultInfo resultInfo) {
                Symbol symbol = resultInfo.checkContext.deferredAttrContext().msym;
                List<Entry> list = this.cache.get(symbol);
                if (list == null) {
                    list = List.nil();
                }
                this.cache.put(symbol, list.prepend(new Entry(jCTree, resultInfo)));
            }

            class Entry {
                JCTree speculativeTree;
                Attr.ResultInfo resultInfo;

                public Entry(JCTree jCTree, Attr.ResultInfo resultInfo) {
                    this.speculativeTree = jCTree;
                    this.resultInfo = resultInfo;
                }

                boolean matches(Resolve.MethodResolutionPhase methodResolutionPhase) {
                    return this.resultInfo.checkContext.deferredAttrContext().phase == methodResolutionPhase;
                }
            }
        }
    }
}

