/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jmap;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import sun.tools.attach.HotSpotVirtualMachine;

public class JMap {
    private static String HISTO_OPTION = "-histo";
    private static String LIVE_HISTO_OPTION = "-histo:live";
    private static String DUMP_OPTION_PREFIX = "-dump:";
    private static String SA_TOOL_OPTIONS = "-heap|-heap:format=b|-clstats|-finalizerinfo";
    private static String FORCE_SA_OPTION = "-F";
    private static String DEFAULT_OPTION = "-pmap";
    private static final String LIVE_OBJECTS_OPTION = "-live";
    private static final String ALL_OBJECTS_OPTION = "-all";

    public static void main(String[] stringArray) throws Exception {
        int n;
        String string;
        int n2;
        if (stringArray.length == 0) {
            JMap.usage(1);
        }
        boolean bl = false;
        String string2 = null;
        for (n2 = 0; n2 < stringArray.length && (string = stringArray[n2]).startsWith("-"); ++n2) {
            if (string.equals("-help") || string.equals("-h")) {
                JMap.usage(0);
                continue;
            }
            if (string.equals(FORCE_SA_OPTION)) {
                bl = true;
                continue;
            }
            if (string2 != null) {
                JMap.usage(1);
            }
            string2 = string;
        }
        if (string2 == null) {
            string2 = DEFAULT_OPTION;
        }
        if (string2.matches(SA_TOOL_OPTIONS)) {
            bl = true;
        }
        if ((n = stringArray.length - n2) == 0 || n > 2) {
            JMap.usage(1);
        }
        if (n2 == 0 || n != 1) {
            bl = true;
        } else if (!stringArray[n2].matches("[0-9]+")) {
            bl = true;
        }
        if (bl) {
            String[] stringArray2 = new String[n];
            for (int i = n2; i < stringArray.length; ++i) {
                stringArray2[i - n2] = stringArray[i];
            }
            JMap.runTool(string2, stringArray2);
        } else {
            String string3 = stringArray[1];
            if (string2.equals(HISTO_OPTION)) {
                JMap.histo(string3, false);
            } else if (string2.equals(LIVE_HISTO_OPTION)) {
                JMap.histo(string3, true);
            } else if (string2.startsWith(DUMP_OPTION_PREFIX)) {
                JMap.dump(string3, string2);
            } else {
                JMap.usage(1);
            }
        }
    }

    private static void runTool(String string, String[] stringArray) throws Exception {
        Object object;
        String[][] stringArrayArray = new String[][]{{"-pmap", "sun.jvm.hotspot.tools.PMap"}, {"-heap", "sun.jvm.hotspot.tools.HeapSummary"}, {"-heap:format=b", "sun.jvm.hotspot.tools.HeapDumper"}, {"-histo", "sun.jvm.hotspot.tools.ObjectHistogram"}, {"-clstats", "sun.jvm.hotspot.tools.ClassLoaderStats"}, {"-finalizerinfo", "sun.jvm.hotspot.tools.FinalizerInfo"}};
        String string2 = null;
        if (string.startsWith(DUMP_OPTION_PREFIX)) {
            object = JMap.parseDumpOptions(string);
            if (object == null) {
                JMap.usage(1);
            }
            string2 = "sun.jvm.hotspot.tools.HeapDumper";
            stringArray = JMap.prepend((String)object, stringArray);
            stringArray = JMap.prepend("-f", stringArray);
        } else {
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (!string.equals(stringArrayArray[i][0])) continue;
                string2 = stringArrayArray[i][1];
                break;
            }
        }
        if (string2 == null) {
            JMap.usage(1);
        }
        if ((object = JMap.loadClass(string2)) == null) {
            JMap.usage(1);
        }
        Class[] classArray = new Class[]{String[].class};
        Method method = ((Class)object).getDeclaredMethod("main", classArray);
        Object[] objectArray = new Object[]{stringArray};
        method.invoke(null, objectArray);
    }

    private static Class<?> loadClass(String string) {
        try {
            return Class.forName(string, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void histo(String string, boolean bl) throws IOException {
        VirtualMachine virtualMachine = JMap.attach(string);
        InputStream inputStream = ((HotSpotVirtualMachine)virtualMachine).heapHisto(bl ? LIVE_OBJECTS_OPTION : ALL_OBJECTS_OPTION);
        JMap.drain(virtualMachine, inputStream);
    }

    private static void dump(String string, String string2) throws IOException {
        String string3 = JMap.parseDumpOptions(string2);
        if (string3 == null) {
            JMap.usage(1);
        }
        string3 = new File(string3).getCanonicalPath();
        boolean bl = JMap.isDumpLiveObjects(string2);
        VirtualMachine virtualMachine = JMap.attach(string);
        System.out.println("Dumping heap to " + string3 + " ...");
        InputStream inputStream = ((HotSpotVirtualMachine)virtualMachine).dumpHeap(string3, bl ? LIVE_OBJECTS_OPTION : ALL_OBJECTS_OPTION);
        JMap.drain(virtualMachine, inputStream);
    }

    private static String parseDumpOptions(String string) {
        assert (string.startsWith(DUMP_OPTION_PREFIX));
        String string2 = null;
        String[] stringArray = string.substring(DUMP_OPTION_PREFIX.length()).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equals("format=b") || string3.equals("live")) continue;
            if (string3.startsWith("file=")) {
                string2 = string3.substring(5);
                if (string2.length() != 0) continue;
                return null;
            }
            return null;
        }
        return string2;
    }

    private static boolean isDumpLiveObjects(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.substring(DUMP_OPTION_PREFIX.length()).split(",")) {
            if (!string2.equals("live")) continue;
            return true;
        }
        return false;
    }

    private static VirtualMachine attach(String string) {
        try {
            return VirtualMachine.attach(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                System.err.println(string + ": " + string2);
            } else {
                exception.printStackTrace();
            }
            if (exception instanceof AttachNotSupportedException && JMap.haveSA()) {
                System.err.println("The -F option can be used when the target process is not responding");
            }
            System.exit(1);
            return null;
        }
    }

    private static void drain(VirtualMachine virtualMachine, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            String string = new String(byArray, 0, n, "UTF-8");
            System.out.print(string);
        } while (n > 0);
        inputStream.close();
        virtualMachine.detach();
    }

    private static String[] prepend(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    private static boolean haveSA() {
        Class<?> clazz = JMap.loadClass("sun.jvm.hotspot.tools.HeapSummary");
        return clazz != null;
    }

    private static void usage(int n) {
        System.err.println("Usage:");
        if (JMap.haveSA()) {
            System.err.println("    jmap [option] <pid>");
            System.err.println("        (to connect to running process)");
            System.err.println("    jmap [option] <executable <core>");
            System.err.println("        (to connect to a core file)");
            System.err.println("    jmap [option] [server_id@]<remote server IP or hostname>");
            System.err.println("        (to connect to remote debug server)");
            System.err.println("");
            System.err.println("where <option> is one of:");
            System.err.println("    <none>               to print same info as Solaris pmap");
            System.err.println("    -heap                to print java heap summary");
            System.err.println("    -histo[:live]        to print histogram of java object heap; if the \"live\"");
            System.err.println("                         suboption is specified, only count live objects");
            System.err.println("    -clstats             to print class loader statistics");
            System.err.println("    -finalizerinfo       to print information on objects awaiting finalization");
            System.err.println("    -dump:<dump-options> to dump java heap in hprof binary format");
            System.err.println("                         dump-options:");
            System.err.println("                           live         dump only live objects; if not specified,");
            System.err.println("                                        all objects in the heap are dumped.");
            System.err.println("                           format=b     binary format");
            System.err.println("                           file=<file>  dump heap to <file>");
            System.err.println("                         Example: jmap -dump:live,format=b,file=heap.bin <pid>");
            System.err.println("    -F                   force. Use with -dump:<dump-options> <pid> or -histo");
            System.err.println("                         to force a heap dump or histogram when <pid> does not");
            System.err.println("                         respond. The \"live\" suboption is not supported");
            System.err.println("                         in this mode.");
            System.err.println("    -h | -help           to print this help message");
            System.err.println("    -J<flag>             to pass <flag> directly to the runtime system");
        } else {
            System.err.println("    jmap -histo <pid>");
            System.err.println("      (to connect to running process and print histogram of java object heap");
            System.err.println("    jmap -dump:<dump-options> <pid>");
            System.err.println("      (to connect to running process and dump java heap)");
            System.err.println("");
            System.err.println("    dump-options:");
            System.err.println("      format=b     binary default");
            System.err.println("      file=<file>  dump heap to <file>");
            System.err.println("");
            System.err.println("    Example:       jmap -dump:format=b,file=heap.bin <pid>");
        }
        System.exit(n);
    }
}

