/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstack;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.InputStream;
import java.lang.reflect.Method;
import sun.tools.attach.HotSpotVirtualMachine;

public class JStack {
    public static void main(String[] stringArray) throws Exception {
        int n;
        String string;
        int n2;
        if (stringArray.length == 0) {
            JStack.usage(1);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < stringArray.length && (string = stringArray[n2]).startsWith("-"); ++n2) {
            if (string.equals("-help") || string.equals("-h")) {
                JStack.usage(0);
                continue;
            }
            if (string.equals("-F")) {
                bl = true;
                continue;
            }
            if (string.equals("-m")) {
                bl2 = true;
                continue;
            }
            if (string.equals("-l")) {
                bl3 = true;
                continue;
            }
            JStack.usage(1);
        }
        if (bl2) {
            bl = true;
        }
        if ((n = stringArray.length - n2) == 0 || n > 2) {
            JStack.usage(1);
        }
        if (n == 2) {
            bl = true;
        } else if (!stringArray[n2].matches("[0-9]+")) {
            bl = true;
        }
        if (bl) {
            String[] stringArray2 = new String[n];
            for (int i = n2; i < stringArray.length; ++i) {
                stringArray2[i - n2] = stringArray[i];
            }
            JStack.runJStackTool(bl2, bl3, stringArray2);
        } else {
            String string2 = stringArray[n2];
            String[] stringArray3 = bl3 ? new String[]{"-l"} : new String[]{};
            JStack.runThreadDump(string2, stringArray3);
        }
    }

    private static void runJStackTool(boolean bl, boolean bl2, String[] stringArray) throws Exception {
        Class<?> clazz = JStack.loadSAClass();
        if (clazz == null) {
            JStack.usage(1);
        }
        if (bl) {
            stringArray = JStack.prepend("-m", stringArray);
        }
        if (bl2) {
            stringArray = JStack.prepend("-l", stringArray);
        }
        Class[] classArray = new Class[]{String[].class};
        Method method = clazz.getDeclaredMethod("main", classArray);
        Object[] objectArray = new Object[]{stringArray};
        method.invoke(null, objectArray);
    }

    private static Class<?> loadSAClass() {
        try {
            return Class.forName("sun.jvm.hotspot.tools.JStack", true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void runThreadDump(String string, String[] stringArray) throws Exception {
        int n;
        Object object;
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = VirtualMachine.attach(string);
        }
        catch (Exception exception) {
            object = exception.getMessage();
            if (object != null) {
                System.err.println(string + ": " + (String)object);
            } else {
                exception.printStackTrace();
            }
            if (exception instanceof AttachNotSupportedException && JStack.loadSAClass() != null) {
                System.err.println("The -F option can be used when the target process is not responding");
            }
            System.exit(1);
        }
        InputStream inputStream = ((HotSpotVirtualMachine)virtualMachine).remoteDataDump(stringArray);
        object = new byte[256];
        do {
            if ((n = inputStream.read((byte[])object)) <= 0) continue;
            String string2 = new String((byte[])object, 0, n, "UTF-8");
            System.out.print(string2);
        } while (n > 0);
        inputStream.close();
        virtualMachine.detach();
    }

    private static String[] prepend(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    private static void usage(int n) {
        System.err.println("Usage:");
        System.err.println("    jstack [-l] <pid>");
        System.err.println("        (to connect to running process)");
        if (JStack.loadSAClass() != null) {
            System.err.println("    jstack -F [-m] [-l] <pid>");
            System.err.println("        (to connect to a hung process)");
            System.err.println("    jstack [-m] [-l] <executable> <core>");
            System.err.println("        (to connect to a core file)");
            System.err.println("    jstack [-m] [-l] [server_id@]<remote server IP or hostname>");
            System.err.println("        (to connect to a remote debug server)");
        }
        System.err.println("");
        System.err.println("Options:");
        if (JStack.loadSAClass() != null) {
            System.err.println("    -F  to force a thread dump. Use when jstack <pid> does not respond (process is hung)");
            System.err.println("    -m  to print both java and native frames (mixed mode)");
        }
        System.err.println("    -l  long listing. Prints additional information about locks");
        System.err.println("    -h or -help to print this help message");
        System.exit(n);
    }
}

