/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.Variability;
import sun.tools.jstat.Expression;
import sun.tools.jstat.ExpressionEvaluator;
import sun.tools.jstat.Identifier;
import sun.tools.jstat.Literal;

public class ExpressionResolver
implements ExpressionEvaluator {
    private static boolean debug = Boolean.getBoolean("ExpressionResolver.debug");
    private MonitoredVm vm;

    ExpressionResolver(MonitoredVm monitoredVm) {
        this.vm = monitoredVm;
    }

    @Override
    public Object evaluate(Expression expression) throws MonitorException {
        if (expression == null) {
            return null;
        }
        if (debug) {
            System.out.println("Resolving Expression:" + expression);
        }
        if (expression instanceof Identifier) {
            Identifier identifier = (Identifier)expression;
            if (identifier.isResolved()) {
                return identifier;
            }
            Monitor monitor = this.vm.findByName(identifier.getName());
            if (monitor == null) {
                System.err.println("Warning: Unresolved Symbol: " + identifier.getName() + " substituted NaN");
                return new Literal(new Double(Double.NaN));
            }
            if (monitor.getVariability() == Variability.CONSTANT) {
                if (debug) {
                    System.out.println("Converting constant " + identifier.getName() + " to literal with value " + monitor.getValue());
                }
                return new Literal(monitor.getValue());
            }
            identifier.setValue(monitor);
            return identifier;
        }
        if (expression instanceof Literal) {
            return expression;
        }
        Expression expression2 = null;
        Expression expression3 = null;
        if (expression.getLeft() != null) {
            expression2 = (Expression)this.evaluate(expression.getLeft());
        }
        if (expression.getRight() != null) {
            expression3 = (Expression)this.evaluate(expression.getRight());
        }
        if (expression2 != null && expression3 != null && expression2 instanceof Literal && expression3 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Literal literal2 = (Literal)expression3;
            boolean bl = false;
            Double d = new Double(Double.NaN);
            if (literal.getValue() instanceof String) {
                bl = true;
                literal.setValue(d);
            }
            if (literal2.getValue() instanceof String) {
                bl = true;
                literal2.setValue(d);
            }
            if (debug && bl) {
                System.out.println("Warning: String literal in numerical expression: substitutied NaN");
            }
            Number number = (Number)literal.getValue();
            Number number2 = (Number)literal2.getValue();
            double d2 = expression.getOperator().eval(number.doubleValue(), number2.doubleValue());
            if (debug) {
                System.out.println("Converting expression " + expression + " (left = " + number.doubleValue() + ")" + " (right = " + number2.doubleValue() + ")" + " to literal value " + d2);
            }
            return new Literal(new Double(d2));
        }
        if (expression2 != null && expression3 == null) {
            return expression2;
        }
        expression.setLeft(expression2);
        expression.setRight(expression3);
        return expression;
    }
}

