/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.ConstantExpression;
import sun.tools.tree.Context;

public class DoubleExpression
extends ConstantExpression {
    double value;

    public DoubleExpression(long l, double d) {
        super(68, l, Type.tDouble);
        this.value = d;
    }

    @Override
    public Object getValue() {
        return new Double(this.value);
    }

    @Override
    public boolean equals(int n) {
        return this.value == (double)n;
    }

    @Override
    public boolean equalsDefault() {
        return Double.doubleToLongBits(this.value) == 0L;
    }

    @Override
    public void codeValue(Environment environment, Context context, Assembler assembler) {
        assembler.add(this.where, 20, new Double(this.value));
    }

    @Override
    public void print(PrintStream printStream) {
        printStream.print(this.value + "D");
    }
}

