/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.event.EventHelper;
import jdk.jfr.events.SecurityPropertyModificationEvent;
import sun.misc.VM;
import sun.security.jca.GetInstance;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public final class Security {
    private static final Debug sdebug = Debug.getInstance("properties");
    private static Properties props;
    private static final Map<String, Class<?>> spiMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        InputStream inputStream;
        Object object;
        props = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        File file = Security.securityPropFile("java.security");
        if (file.exists()) {
            object = null;
            try {
                inputStream = new FileInputStream(file);
                object = new BufferedInputStream(inputStream);
                props.load((InputStream)object);
                bl = true;
                if (sdebug != null) {
                    sdebug.println("reading security properties file: " + file);
                }
            }
            catch (IOException iOException) {
                if (sdebug != null) {
                    sdebug.println("unable to load security properties from " + file);
                    iOException.printStackTrace();
                }
            }
            finally {
                block46: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {
                            if (sdebug == null) break block46;
                            sdebug.println("unable to close input stream");
                        }
                    }
                }
            }
        }
        if ("true".equalsIgnoreCase(props.getProperty("security.overridePropertiesFile"))) {
            boolean bl3;
            boolean bl4;
            boolean bl5;
            object = System.getProperty("java.security.properties");
            if (object != null && ((String)object).startsWith("=")) {
                bl2 = true;
                object = ((String)object).substring(1);
            }
            if (bl2) {
                props = new Properties();
                if (sdebug != null) {
                    sdebug.println("overriding other security properties files!");
                }
            }
            if (object != null) {
                inputStream = null;
                try {
                    object = PropertyExpander.expand((String)object);
                    file = new File((String)object);
                    URL uRL = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL((String)object);
                    inputStream = new BufferedInputStream(uRL.openStream());
                    props.load(inputStream);
                    bl = true;
                    if (sdebug != null) {
                        sdebug.println("reading security properties file: " + uRL);
                        if (bl2) {
                            sdebug.println("overriding other security properties files!");
                        }
                    }
                }
                catch (Exception exception) {
                    if (sdebug != null) {
                        sdebug.println("unable to load security properties from " + (String)object);
                        exception.printStackTrace();
                    }
                }
                finally {
                    block48: {
                        if (inputStream != null) {
                            try {
                                ((BufferedInputStream)inputStream).close();
                            }
                            catch (IOException iOException) {
                                if (sdebug == null) break block48;
                                sdebug.println("unable to close input stream");
                            }
                        }
                    }
                }
            }
            if (((bl5 = "true".equals(VM.getSavedProperty("org.openjsse.provider"))) ? 1 : 0) + ((bl4 = "true".equals(VM.getSavedProperty("org.legacy8ujsse.provider"))) ? 1 : 0) + ((bl3 = "true".equals(VM.getSavedProperty("org.customjsse.provider"))) ? 1 : 0) > 1) {
                throw new ProviderException("Unable to use OpenJSSE, Legacy8uJSSE and CustomJSSE providers simultaneously");
            }
            if (bl5) {
                if (Security.setJSSEProvider("OpenJSSE", "openjsse", "org.openjsse.net.www.protocol", props)) {
                    bl = true;
                }
            } else if (bl4) {
                if (Security.setJSSEProvider("Legacy8uJSSE", "legacy8ujsse", null, props)) {
                    bl = true;
                }
            } else if (bl3 && Security.setJSSEProvider("CustomJSSE", "customjsse", null, props)) {
                bl = true;
            }
        }
        if (!bl) {
            Security.initializeStatic();
            if (sdebug != null) {
                sdebug.println("unable to load security properties -- using defaults");
            }
        }
    }

    private static boolean setJSSEProvider(String string, String string2, String string3, Properties properties) {
        boolean bl;
        block32: {
            File file = Security.securityPropFile(string2 + ".security");
            String string4 = File.separator;
            File file2 = new File(file.getParentFile().getParent(), string4 + "ext" + string4 + string2 + ".jar");
            bl = false;
            if (file.exists() && file2.exists()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                    properties.load(bufferedInputStream);
                    bl = true;
                    if (string3 != null) {
                        String string5 = System.getProperty("java.protocol.handler.pkgs");
                        if (string5 == null || string5.isEmpty()) {
                            System.setProperty("java.protocol.handler.pkgs", string3);
                        } else if (!string5.contains(string3)) {
                            System.setProperty("java.protocol.handler.pkgs", string3 + "|" + string5);
                        }
                    }
                    if (sdebug != null) {
                        sdebug.println("reading " + string2 + " properties file: " + file.getName());
                    }
                    break block32;
                }
                catch (IOException iOException) {
                    throw new ProviderException("Unable to load " + string + " provider properties");
                }
            }
            throw new ProviderException(string + " provider requested but not found");
        }
        return bl;
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
        props.put("security.provider.2", "sun.security.rsa.SunRsaSign");
        props.put("security.provider.3", "com.sun.net.ssl.internal.ssl.Provider");
        props.put("security.provider.4", "com.sun.crypto.provider.SunJCE");
        props.put("security.provider.5", "sun.security.jgss.SunProvider");
        props.put("security.provider.6", "com.sun.security.sasl.Provider");
    }

    private Security() {
    }

    private static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(System.getProperty("java.home") + string2 + "lib" + string2 + "security" + string2 + string);
    }

    private static ProviderProperty getProviderProperty(String string) {
        ProviderProperty providerProperty = null;
        List<Provider> list = Providers.getProviderList().providers();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string2 = null;
            Provider provider = list.get(i);
            String string3 = provider.getProperty(string);
            if (string3 == null) {
                object = provider.keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = provider.getProperty(string2);
                    break;
                }
            }
            if (string3 == null) continue;
            object = new ProviderProperty();
            ((ProviderProperty)object).className = string3;
            ((ProviderProperty)object).provider = provider;
            return object;
        }
        return providerProperty;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration<Object> enumeration = provider.keys();
            while (enumeration.hasMoreElements() && string2 == null) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        return string2;
    }

    @Deprecated
    public static String getAlgorithmProperty(String string, String string2) {
        ProviderProperty providerProperty = Security.getProviderProperty("Alg." + string2 + "." + string);
        if (providerProperty != null) {
            return providerProperty.className;
        }
        return null;
    }

    public static synchronized int insertProviderAt(Provider provider, int n) {
        String string = provider.getName();
        Security.checkInsertProvider(string);
        ProviderList providerList = Providers.getFullProviderList();
        ProviderList providerList2 = ProviderList.insertAt(providerList, provider, n - 1);
        if (providerList == providerList2) {
            return -1;
        }
        Providers.setProviderList(providerList2);
        return providerList2.getIndex(string) + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String string) {
        Security.check("removeProvider." + string);
        ProviderList providerList = Providers.getFullProviderList();
        ProviderList providerList2 = ProviderList.remove(providerList, string);
        Providers.setProviderList(providerList2);
    }

    public static Provider[] getProviders() {
        return Providers.getFullProviderList().toArray();
    }

    public static Provider getProvider(String string) {
        return Providers.getProviderList().getProvider(string);
    }

    public static Provider[] getProviders(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            string2 = string;
            string3 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put(string2, string3);
        return Security.getProviders(hashtable);
    }

    public static Provider[] getProviders(Map<String, String> map) {
        Provider[] providerArray2 = Security.getProviders();
        Set<String> set = map.keySet();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet(5);
        if (set == null || providerArray2 == null) {
            return providerArray2;
        }
        boolean bl = true;
        for (String providerArray3 : set) {
            String i = map.get(providerArray3);
            LinkedHashSet<Provider> linkedHashSet2 = Security.getAllQualifyingCandidates(providerArray3, i, providerArray2);
            if (bl) {
                linkedHashSet = linkedHashSet2;
                bl = false;
            }
            if (linkedHashSet2 != null && !linkedHashSet2.isEmpty()) {
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    Provider provider = (Provider)iterator.next();
                    if (linkedHashSet2.contains(provider)) continue;
                    iterator.remove();
                }
                continue;
            }
            linkedHashSet = null;
            break;
        }
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            return null;
        }
        Object[] objectArray = linkedHashSet.toArray();
        Provider[] providerArray = new Provider[objectArray.length];
        for (int i = 0; i < providerArray.length; ++i) {
            providerArray[i] = (Provider)objectArray[i];
        }
        return providerArray;
    }

    private static Class<?> getSpiClass(String string) {
        Class<?> clazz = spiMap.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName("java.security." + string + "Spi");
            spiMap.put(string, clazz);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Spi class not found", classNotFoundException);
        }
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null) {
            return GetInstance.getInstance(string2, Security.getSpiClass(string2), string).toArray();
        }
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, string3).toArray();
    }

    static Object[] getImpl(String string, String string2, String string3, Object object) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (string3 == null) {
            return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object).toArray();
        }
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object, string3).toArray();
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, provider).toArray();
    }

    static Object[] getImpl(String string, String string2, Provider provider, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return GetInstance.getInstance(string2, Security.getSpiClass(string2), string, object, provider).toArray();
    }

    public static String getProperty(String string) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getProperty." + string));
        }
        if ((string2 = props.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        Security.check("setProperty." + string);
        props.put(string, string2);
        Security.invalidateSMCache(string);
        SecurityPropertyModificationEvent securityPropertyModificationEvent = new SecurityPropertyModificationEvent();
        securityPropertyModificationEvent.key = string;
        securityPropertyModificationEvent.value = string2;
        securityPropertyModificationEvent.commit();
        if (EventHelper.isLoggingSecurity()) {
            EventHelper.logSecurityPropertyEvent(string, string2);
        }
    }

    private static void invalidateSMCache(String string) {
        final boolean bl = string.equals("package.access");
        boolean bl2 = string.equals("package.definition");
        if (bl || bl2) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        Class<?> clazz = Class.forName("java.lang.SecurityManager", false, null);
                        Field field = null;
                        boolean bl2 = false;
                        if (bl) {
                            field = clazz.getDeclaredField("packageAccessValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        } else {
                            field = clazz.getDeclaredField("packageDefinitionValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        }
                        field.setBoolean(field, false);
                        field.setAccessible(bl2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    private static void checkInsertProvider(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSecurityAccess("insertProvider");
            }
            catch (SecurityException securityException) {
                try {
                    securityManager.checkSecurityAccess("insertProvider." + string);
                }
                catch (SecurityException securityException2) {
                    securityException.addSuppressed(securityException2);
                    throw securityException;
                }
            }
        }
    }

    private static LinkedHashSet<Provider> getAllQualifyingCandidates(String string, String string2, Provider[] providerArray) {
        String[] stringArray = Security.getFilterComponents(string, string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        return Security.getProvidersNotUsingCache(string3, string4, string5, string2, providerArray);
    }

    private static LinkedHashSet<Provider> getProvidersNotUsingCache(String string, String string2, String string3, String string4, Provider[] providerArray) {
        LinkedHashSet<Provider> linkedHashSet = new LinkedHashSet<Provider>(5);
        for (int i = 0; i < providerArray.length; ++i) {
            if (!Security.isCriterionSatisfied(providerArray[i], string, string2, string3, string4)) continue;
            linkedHashSet.add(providerArray[i]);
        }
        return linkedHashSet;
    }

    private static boolean isCriterionSatisfied(Provider provider, String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string + '.' + string2;
        if (string3 != null) {
            string6 = string6 + ' ' + string3;
        }
        if ((string5 = Security.getProviderProperty(string6, provider)) == null) {
            String string7 = Security.getProviderProperty("Alg.Alias." + string + "." + string2, provider);
            if (string7 != null) {
                string6 = string + "." + string7;
                if (string3 != null) {
                    string6 = string6 + ' ' + string3;
                }
                string5 = Security.getProviderProperty(string6, provider);
            }
            if (string5 == null) {
                return false;
            }
        }
        if (string3 == null) {
            return true;
        }
        if (Security.isStandardAttr(string3)) {
            return Security.isConstraintSatisfied(string3, string4, string5);
        }
        return string4.equalsIgnoreCase(string5);
    }

    private static boolean isStandardAttr(String string) {
        if (string.equalsIgnoreCase("KeySize")) {
            return true;
        }
        return string.equalsIgnoreCase("ImplementedIn");
    }

    private static boolean isConstraintSatisfied(String string, String string2, String string3) {
        if (string.equalsIgnoreCase("KeySize")) {
            int n;
            int n2 = Integer.parseInt(string2);
            return n2 <= (n = Integer.parseInt(string3));
        }
        if (string.equalsIgnoreCase("ImplementedIn")) {
            return string2.equalsIgnoreCase(string3);
        }
        return false;
    }

    static String[] getFilterComponents(String string, String string2) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new InvalidParameterException("Invalid filter");
        }
        String string3 = string.substring(0, n);
        String string4 = null;
        String string5 = null;
        if (string2.length() == 0) {
            string4 = string.substring(n + 1).trim();
            if (string4.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
        } else {
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string5 = string.substring(n2 + 1).trim();
            if (string5.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
            if (n2 < n || n == n2 - 1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string4 = string.substring(n + 1, n2);
        }
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    public static Set<String> getAlgorithms(String string) {
        if (string == null || string.length() == 0 || string.endsWith(".")) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration<Object> enumeration = providerArray[i].keys();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).toUpperCase(Locale.ENGLISH);
                if (!string2.startsWith(string.toUpperCase(Locale.ENGLISH)) || string2.indexOf(" ") >= 0) continue;
                hashSet.add(string2.substring(string.length() + 1));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Security.initialize();
                return null;
            }
        });
        spiMap = new ConcurrentHashMap();
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

