/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="This code is unlikely to be used in a security-sensitive environment.")
public class MatFileHeader {
    private static String DEFAULT_DESCRIPTIVE_TEXT = "MATLAB 5.0 MAT-file, Platform: " + System.getProperty("os.name") + ", CREATED on: ";
    public static final int DEFAULT_VERSION = 256;
    public static final ByteOrder DEFAULT_ENDIAN = ByteOrder.BIG_ENDIAN;
    private static final byte[] ENDIAN_INDICATOR_BIG = new byte[]{77, 73};
    private static final byte[] ENDIAN_INDICATOR_LITTLE = new byte[]{73, 77};
    private int version;
    private String description;
    private final ByteOrder byteOrder;

    public static MatFileHeader parseFrom(String description, byte[] bversion, byte[] endianIndicator) {
        int version;
        ByteOrder byteOrder = MatFileHeader.parseByteOrder(endianIndicator);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            version = bversion[0] & 0xFF | bversion[1] << 8;
        } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            version = bversion[1] & 0xFF | bversion[0] << 8;
        } else {
            throw new IllegalArgumentException("Unknown byteOrder " + byteOrder);
        }
        return new MatFileHeader(description, version, byteOrder);
    }

    public static ByteOrder parseByteOrder(byte[] endianIndicator) {
        if (Arrays.equals(ENDIAN_INDICATOR_BIG, endianIndicator)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (Arrays.equals(ENDIAN_INDICATOR_LITTLE, endianIndicator)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        StringBuilder arrayBuilder = new StringBuilder();
        for (int i = 0; i < endianIndicator.length; ++i) {
            arrayBuilder.append(endianIndicator[i]);
        }
        throw new IllegalArgumentException("Unknown endian indicator " + arrayBuilder.toString());
    }

    public MatFileHeader(String description, int version, ByteOrder byteOrder) {
        this.description = description;
        this.version = version;
        this.byteOrder = byteOrder;
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getEndianIndicator() {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return Arrays.copyOf(ENDIAN_INDICATOR_BIG, 2);
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return Arrays.copyOf(ENDIAN_INDICATOR_LITTLE, 2);
        }
        throw new IllegalArgumentException("Unknown byteOrder '" + this.byteOrder + "'");
    }

    public int getVersion() {
        return this.version;
    }

    public static MatFileHeader createHeader() {
        return new MatFileHeader(DEFAULT_DESCRIPTIVE_TEXT + new Date().toString(), 256, DEFAULT_ENDIAN);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("desriptive text: " + this.description);
        sb.append(", version: " + this.version);
        sb.append(", byteOrder: " + this.byteOrder);
        sb.append("]");
        return sb.toString();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

