/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MLObjectPlaceholder;
import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileType;
import com.jmatio.io.MatFileWriter;
import com.jmatio.io.MatMCOSObjectInformation;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.io.Unsafe9R;
import com.jmatio.io.stream.ByteBufferInputStream;
import com.jmatio.io.stream.HeapBufferDataOutputStream;
import com.jmatio.io.stream.MatFileInputStream;
import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLEmptyArray;
import com.jmatio.types.MLHandle;
import com.jmatio.types.MLInt16;
import com.jmatio.types.MLInt32;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLJavaObject;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLObject;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt16;
import com.jmatio.types.MLUInt32;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class MatFileReader {
    public static final int MEMORY_MAPPED_FILE = 1;
    public static final int DIRECT_BYTE_BUFFER = 2;
    public static final int HEAP_BYTE_BUFFER = 4;
    private final MatFileType matType;
    MatFileHeader matFileHeader;
    Map<String, MLArray> data;
    private MatFileFilter filter;
    private Set<MLObjectPlaceholder> mcosToFind = new HashSet<MLObjectPlaceholder>();
    private MLUInt8 mcosData;
    private static final int DIRECT_BUFFER_LIMIT = 0x2000000;

    public MatFileReader(String fileName) throws FileNotFoundException, IOException {
        this(new File(fileName), new MatFileFilter(), MatFileType.Regular);
    }

    public MatFileReader(String fileName, MatFileFilter filter) throws IOException {
        this(new File(fileName), filter, MatFileType.Regular);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter(), MatFileType.Regular);
    }

    public MatFileReader(File file, MatFileFilter filter, MatFileType matType) throws IOException {
        this(matType);
        this.read(file, filter, 1);
    }

    public MatFileReader(File file, MatFileFilter filter) throws IOException {
        this(file, filter, MatFileType.Regular);
    }

    public MatFileReader(MatFileType matType) {
        this.matType = matType;
        this.filter = new MatFileFilter();
        this.data = new LinkedHashMap<String, MLArray>();
    }

    public MatFileReader() {
        this(MatFileType.Regular);
    }

    public MatFileReader(InputStream stream, MatFileType type) throws IOException {
        this(stream, new MatFileFilter(), type);
    }

    public MatFileReader(InputStream stream, MatFileFilter filter, MatFileType type) throws IOException {
        this(type);
        this.read(stream, filter);
    }

    public synchronized Map<String, MLArray> read(File file) throws IOException {
        return this.read(file, new MatFileFilter(), 1);
    }

    public synchronized Map<String, MLArray> read(InputStream stream) throws IOException {
        return this.read(stream, new MatFileFilter());
    }

    public synchronized Map<String, MLArray> read(File file, int policy) throws IOException {
        return this.read(file, new MatFileFilter(), policy);
    }

    public synchronized Map<String, MLArray> read(File file, MatFileFilter filter, int policy) throws IOException {
        return this.read(new RandomAccessFile(file, "r"), filter, policy);
    }

    public synchronized Map<String, MLArray> read(RandomAccessFile raFile, MatFileFilter filter, int policy) throws IOException {
        this.filter = filter;
        this.data.clear();
        FileChannel roChannel = null;
        ByteBuffer buf = null;
        try {
            roChannel = raFile.getChannel();
            switch (policy) {
                case 2: {
                    buf = ByteBuffer.allocateDirect((int)roChannel.size());
                    roChannel.read(buf, 0L);
                    buf.rewind();
                    break;
                }
                case 4: {
                    int filesize = (int)roChannel.size();
                    buf = ByteBuffer.allocate(filesize);
                    int numberOfBlocks = filesize / 0x2000000 + (filesize % 0x2000000 > 0 ? 1 : 0);
                    if (numberOfBlocks > 1) {
                        ByteBuffer tempByteBuffer = ByteBuffer.allocateDirect(0x2000000);
                        for (long block = 0L; block < (long)numberOfBlocks; ++block) {
                            tempByteBuffer.clear();
                            roChannel.read(tempByteBuffer, block * 0x2000000L);
                            tempByteBuffer.flip();
                            buf.put(tempByteBuffer);
                        }
                        tempByteBuffer = null;
                    } else {
                        roChannel.read(buf, 0L);
                    }
                    buf.rewind();
                    break;
                }
                case 1: {
                    buf = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown file allocation policy");
                }
            }
            this.parseData(buf);
            Map<String, MLArray> filesize = this.getContent();
            return filesize;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (buf != null && buf.isDirect()) {
                Unsafe9R.invokeCleaner(buf);
            }
            if (roChannel != null) {
                roChannel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
        }
    }

    private void parseData(ByteBuffer buf) throws IOException {
        this.readHeader(buf);
        while (buf.remaining() > 0) {
            this.readData(buf);
        }
        if (!this.mcosToFind.isEmpty()) {
            MatFileReader.parseMCOS(this.mcosData, this.mcosToFind);
            if (this.data.get("@") == this.mcosData) {
                this.data.remove("@");
            }
            for (Map.Entry<String, MLArray> it : this.data.entrySet()) {
                if (it.getValue() != this.mcosData) continue;
                this.data.remove(it.getKey());
                break;
            }
        }
        this.mcosData = null;
        this.mcosToFind.clear();
    }

    private static void parseMCOS(MLUInt8 mcosData, Set<MLObjectPlaceholder> mcosPlaceholders) throws IOException {
        ByteBuffer buffer = mcosData.getRealByteBuffer();
        ByteBufferInputStream dataStream = new ByteBufferInputStream(buffer, buffer.limit());
        MatFileReader matFile = new MatFileReader(dataStream, MatFileType.ReducedHeader);
        Map<String, MLArray> mcosContent = matFile.getContent();
        MLCell mcosInfo = (MLCell)((MLStructure)mcosContent.get("@0")).getField("MCOS");
        ByteBuffer mcosDataBuf = ((MLUInt8)mcosInfo.get(0)).getRealByteBuffer();
        mcosDataBuf.order(matFile.getMatFileHeader().getByteOrder());
        int version = mcosDataBuf.getInt();
        if (version != 2) {
            throw new IllegalStateException("MAT file's MCOS data has a different version(?).  Got: " + version + ", wanted 2.");
        }
        int strCount = mcosDataBuf.getInt();
        String[] strs = new String[strCount];
        int[] segmentIndexes = new int[6];
        for (int i = 0; i < segmentIndexes.length; ++i) {
            segmentIndexes[i] = mcosDataBuf.getInt();
        }
        if (mcosDataBuf.getLong() != 0L) {
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strCount; ++i) {
            sb.setLength(0);
            char next = (char)mcosDataBuf.get();
            while (next != '\u0000') {
                sb.append(next);
                next = (char)mcosDataBuf.get();
            }
            strs[i] = sb.toString();
        }
        if ((mcosDataBuf.position() + 7 & 0xFFFFFFF8) != segmentIndexes[0]) {
            throw new IllegalStateException("Data from the strings section was not all read!");
        }
        ArrayList<String> classNamesList = new ArrayList<String>();
        mcosDataBuf.position(segmentIndexes[0]);
        if (mcosDataBuf.getLong() != 0L || mcosDataBuf.getLong() != 0L) {
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
        while (mcosDataBuf.position() < segmentIndexes[1]) {
            mcosDataBuf.getInt();
            int classNameIndex = mcosDataBuf.getInt();
            String className = strs[classNameIndex - 1];
            classNamesList.add(className);
            if (mcosDataBuf.getLong() == 0L) continue;
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
        if (mcosDataBuf.position() != segmentIndexes[1]) {
            throw new IllegalStateException("Data from the class section was not all read!");
        }
        mcosDataBuf.position(segmentIndexes[2]);
        HashMap<Integer, MatMCOSObjectInformation> objectInfoList = new HashMap<Integer, MatMCOSObjectInformation>();
        if (mcosDataBuf.getLong() != 0L || mcosDataBuf.getLong() != 0L || mcosDataBuf.getLong() != 0L) {
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
        int objectCount = 1;
        while (mcosDataBuf.position() < segmentIndexes[3]) {
            int classIndex = mcosDataBuf.getInt();
            if (mcosDataBuf.getLong() != 0L) {
                throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
            }
            int segment2Index = mcosDataBuf.getInt();
            int segment4Index = mcosDataBuf.getInt();
            mcosDataBuf.getInt();
            int objectId = objectCount++;
            objectInfoList.put(objectId - 1, new MatMCOSObjectInformation((String)classNamesList.get(classIndex - 1), classIndex, objectId, segment2Index, segment4Index));
        }
        if (mcosDataBuf.position() != segmentIndexes[3]) {
            throw new IllegalStateException("Data from the object section was not all read!  At: " + mcosDataBuf.position() + ", wanted: " + segmentIndexes[3]);
        }
        if (mcosDataBuf.getLong() != 0L) {
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
        ArrayList segment4Properties = new ArrayList();
        while (mcosDataBuf.position() < segmentIndexes[4]) {
            HashMap<String, MLArray> properties = new HashMap<String, MLArray>();
            int propertiesCount = mcosDataBuf.getInt();
            for (int i = 0; i < propertiesCount; ++i) {
                int[][] data;
                MLArray property;
                int nameIndex = mcosDataBuf.getInt();
                int flag = mcosDataBuf.getInt();
                int heapIndex = mcosDataBuf.getInt();
                String propertyName = strs[nameIndex - 1];
                switch (flag) {
                    case 0: {
                        property = new MLChar(propertyName, strs[heapIndex - 1]);
                        break;
                    }
                    case 1: {
                        property = mcosInfo.get(heapIndex + 2);
                        break;
                    }
                    case 2: {
                        throw new UnsupportedOperationException("Mat file parsing does not yet support booleans!");
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't yet support parameter type: " + flag + "!");
                    }
                }
                if (property instanceof MLUInt32 && (data = ((MLUInt32)property).getArray())[0][0] == -587202560 && data[1][0] == 2) {
                    MLObjectPlaceholder objHolder = new MLObjectPlaceholder(propertyName, "", data);
                    mcosPlaceholders.add(objHolder);
                    property = objHolder;
                }
                properties.put(propertyName, property);
            }
            segment4Properties.add(properties);
            mcosDataBuf.position(mcosDataBuf.position() + 7 & 0xFFFFFFF8);
        }
        if (mcosDataBuf.position() != segmentIndexes[4]) {
            throw new IllegalStateException("Data from the properties section (2) was not all read!  At: " + mcosDataBuf.position() + ", wanted: " + segmentIndexes[4]);
        }
        for (MatMCOSObjectInformation it : objectInfoList.values()) {
            Map<String, MLArray> objAttributes = it.structure;
            if (it.segment4PropertiesIndex > 0) {
                for (Map.Entry attribute : ((Map)segment4Properties.get(it.segment4PropertiesIndex - 1)).entrySet()) {
                    objAttributes.put((String)attribute.getKey(), (MLArray)attribute.getValue());
                }
                continue;
            }
            throw new IllegalStateException("Properties are not found!  Not sure where to look ...");
        }
        MLCell attribBag = (MLCell)mcosInfo.get(mcosInfo.getSize() - 1);
        for (MatMCOSObjectInformation it : objectInfoList.values()) {
            MLStructure attributes = (MLStructure)attribBag.get(it.classId);
            Collection<String> attributeNames = attributes.getFieldNames();
            Map<String, MLArray> objAttributes = it.structure;
            for (String attributeName : attributeNames) {
                if (objAttributes.get(attributeName) != null) continue;
                objAttributes.put(attributeName, attributes.getField(attributeName));
            }
        }
        for (MLObjectPlaceholder placeholder : mcosPlaceholders) {
            MatFileReader.processMCOS(placeholder, classNamesList, objectInfoList);
        }
    }

    private static void processMCOS(MLObjectPlaceholder objHolder, List<String> classNamesList, Map<Integer, MatMCOSObjectInformation> objectInfoList) {
        int classId = objHolder.classId;
        MLObject obj = new MLObject(objHolder.name, classNamesList.get(classId - 1), objHolder.getDimensions(), 0);
        for (int i = 0; i < obj.getSize(); ++i) {
            MatMCOSObjectInformation objectInformation = objectInfoList.get(objHolder.objectIds[i] - 1);
            if (classId != objectInformation.classId) {
                throw new IllegalStateException("Found an object in array with a different class id! Actual: " + objectInformation.classId + ", expected: " + classId + "!");
            }
            obj.setFields(i, objectInformation.structure);
        }
        objHolder.setTarget(obj);
    }

    public synchronized Map<String, MLArray> read(InputStream stream, MatFileFilter filter) throws IOException {
        this.filter = filter;
        this.data.clear();
        ByteBuffer buf = null;
        MatFileWriter.ByteArrayOutputStream2 baos = new MatFileWriter.ByteArrayOutputStream2();
        this.copy(stream, baos);
        buf = ByteBuffer.wrap(baos.getBuf(), 0, baos.getCount());
        this.parseData(buf);
        return this.getContent();
    }

    private void copy(InputStream stream, MatFileWriter.ByteArrayOutputStream2 output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = stream.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String name) {
        return this.data.get(name);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    void readData(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        switch (tag.type) {
            case 15: {
                int numOfBytes = tag.size;
                if (buf.remaining() < numOfBytes) {
                    throw new MatlabIOException("Compressed buffer length miscalculated!");
                }
                InflaterInputStream iis = new InflaterInputStream(new ByteBufferInputStream(buf, numOfBytes));
                byte[] result = new byte[1024];
                HeapBufferDataOutputStream dos = new HeapBufferDataOutputStream();
                try {
                    int i;
                    do {
                        i = iis.read(result, 0, result.length);
                        int len = Math.max(0, i);
                        dos.write(result, 0, len);
                    } while (i > 0);
                }
                catch (EOFException eofe) {
                    System.out.println("EOFException detected!");
                }
                catch (IOException e) {
                    throw new MatlabIOException("Could not decompress data: " + e);
                }
                finally {
                    iis.close();
                    dos.flush();
                }
                ByteBuffer out = dos.getByteBuffer();
                out.order(this.matFileHeader.getByteOrder());
                try {
                    this.readData(out);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    dos.close();
                }
            }
            case 14: {
                int toRead;
                int read;
                int pos = buf.position();
                MLArray element = this.readMatrix(buf, true);
                if (element != null) {
                    if (!this.data.containsKey(element.getName())) {
                        this.data.put(element.getName(), element);
                    }
                    if (element.getName() == "@") {
                        int nextIndex = 0;
                        while (this.data.containsKey("@" + nextIndex)) {
                            ++nextIndex;
                        }
                        this.data.put("@" + nextIndex, element);
                    }
                } else {
                    read = buf.position() - pos;
                    toRead = tag.size - read;
                    buf.position(buf.position() + toRead);
                }
                if ((toRead = tag.size - (read = buf.position() - pos)) == 0) break;
                throw new MatlabIOException("Matrix was not read fully! " + toRead + " remaining in the buffer.");
            }
            default: {
                throw new MatlabIOException("Incorrect data tag: " + tag);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MLArray readMatrix(ByteBuffer buf, boolean isRoot) throws IOException {
        int[] flags = MatFileReader.readFlags(buf);
        int attributes = flags.length != 0 ? flags[0] : 0;
        int nzmax = flags.length != 0 ? flags[1] : 0;
        int type = attributes & 0xFF;
        int[] dims = MatFileReader.readDimension(buf);
        String name = MatFileReader.readName(buf, this.matFileHeader);
        if (isRoot && !this.filter.matches(name)) {
            return null;
        }
        switch (type) {
            case 2: {
                MLStructure struct = new MLStructure(name, dims, attributes);
                new ISMatTag(buf);
                int maxlen = buf.getInt();
                ISMatTag tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = MatFileReader.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                int index = 0;
                while (index < struct.getM() * struct.getN()) {
                    for (int i = 0; i < numOfFields; ++i) {
                        void var17_38;
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray mLArray = this.readMatrix(buf, false);
                        } else {
                            MLEmptyArray mLEmptyArray = new MLEmptyArray();
                        }
                        var17_38.name = fieldNames[i];
                        struct.setField(fieldNames[i], (MLArray)var17_38, index);
                    }
                    ++index;
                }
                return struct;
            }
            case 1: {
                MLCell cell = new MLCell(name, dims, type, attributes);
                int i = 0;
                while (i < cell.getM() * cell.getN()) {
                    ISMatTag tag = new ISMatTag(buf);
                    if (tag.size > 0) {
                        MLArray mLArray = this.readMatrix(buf, false);
                        cell.set(mLArray, i);
                    } else {
                        cell.set(new MLEmptyArray(), i);
                    }
                    ++i;
                }
                return cell;
            }
            case 6: {
                MLArray mlArray = new MLDouble(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 7: {
                MLArray mlArray = new MLSingle(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 9: {
                MLArray mlArray = new MLUInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (mlArray.isComplex()) {
                    tag = new ISMatTag(buf);
                    tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                }
                if (!name.equals("")) return mlArray;
                this.mcosData = (MLUInt8)mlArray;
                return mlArray;
            }
            case 8: {
                MLArray mlArray = new MLInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 10: {
                MLArray mlArray = new MLInt16(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 11: {
                MLArray mlArray = new MLUInt16(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 12: {
                MLArray mlArray = new MLInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 13: {
                MLArray mlArray = new MLUInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 14: {
                MLArray mlArray = new MLInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 15: {
                MLArray mlArray = new MLUInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) return mlArray;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                return mlArray;
            }
            case 4: {
                MLChar mlchar = new MLChar(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                String string = tag.readToString(this.matFileHeader.getByteOrder());
                int i = 0;
                while (i < string.length()) {
                    mlchar.setChar(string.charAt(i), i);
                    ++i;
                }
                return mlchar;
            }
            case 5: {
                MLSparse sparse = new MLSparse(name, dims, attributes, nzmax);
                ISMatTag tag = new ISMatTag(buf);
                int[] ir = tag.readToIntArray();
                tag = new ISMatTag(buf);
                int[] jc = tag.readToIntArray();
                if (sparse.isComplex()) {
                    tag = new ISMatTag(buf);
                    double[] ad1 = tag.readToDoubleArray();
                    int count = 0;
                    for (int column = 0; column < sparse.getN(); ++column) {
                        while (count < jc[column + 1]) {
                            sparse.setReal(ad1[count], ir[count], column);
                            ++count;
                        }
                    }
                    tag = new ISMatTag(buf);
                    double[] ad2 = tag.readToDoubleArray();
                    count = 0;
                    int column = 0;
                    while (column < sparse.getN()) {
                        while (count < jc[column + 1]) {
                            sparse.setImaginary(ad2[count], ir[count], column);
                            ++count;
                        }
                        ++column;
                    }
                    return sparse;
                }
                tag = new ISMatTag(buf);
                double[] ad1 = tag.readToDoubleArray();
                int count = 0;
                int column = 0;
                while (column < sparse.getN()) {
                    while (count < jc[column + 1]) {
                        sparse.set(ad1[count], ir[count], column);
                        ++count;
                    }
                    ++column;
                }
                return sparse;
            }
            case 17: {
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString(this.matFileHeader.getByteOrder());
                byte[] nn = new byte[dims.length];
                for (int i = 0; i < dims.length; ++i) {
                    nn[i] = (byte)dims[i];
                }
                String arrName = new String(nn, "UTF-8");
                ISMatTag contentTag = new ISMatTag(buf);
                if (contentTag.type != 14) throw new IOException("Unexpected object content");
                if (name.equals("java")) {
                    MLArray wrappedContent = this.readMatrix(buf, false);
                    MLNumericArray binaryContent = null;
                    if (wrappedContent instanceof MLCell) {
                        MLArray candidate;
                        MLCell mLCell = (MLCell)wrappedContent;
                        Iterator<MLArray> iterator = mLCell.cells().iterator();
                        do {
                            if (!iterator.hasNext()) return new MLJavaObject(arrName, className, binaryContent);
                        } while (!((candidate = iterator.next()) instanceof MLNumericArray));
                        binaryContent = (MLNumericArray)candidate;
                        return new MLJavaObject(arrName, className, binaryContent);
                    } else if (wrappedContent instanceof MLNumericArray) {
                        binaryContent = (MLNumericArray)wrappedContent;
                        return new MLJavaObject(arrName, className, binaryContent);
                    } else {
                        if (!(wrappedContent instanceof MLStructure)) throw new IOException("Unexpected array type: " + wrappedContent.name);
                        MLStructure mLStructure = (MLStructure)wrappedContent;
                        MLCell cellContent = (MLCell)mLStructure.getField("Values", 0);
                        binaryContent = (MLNumericArray)cellContent.get(0);
                    }
                    return new MLJavaObject(arrName, className, binaryContent);
                }
                if (name.equals("MCOS")) {
                    if (className.equals("FileWrapper__")) return this.readMatrix(buf, false);
                    MLUInt32 content = (MLUInt32)this.readMatrix(buf, false);
                    int[][] t = content.getArray();
                    if (t[0][0] != -587202560) throw new IOException("MCOS per-object header was different then expected!  Got: " + content.contentToString());
                    if (t[1][0] != 2) {
                        throw new IOException("MCOS per-object header was different then expected!  Got: " + content.contentToString());
                    }
                    MLObjectPlaceholder mLObjectPlaceholder = new MLObjectPlaceholder(arrName, className, t);
                    this.mcosToFind.add(mLObjectPlaceholder);
                    return mLObjectPlaceholder;
                }
                if (!name.equals("handle")) throw new IOException("Unknown object type (" + name + ") found.");
                MLCell wrappedContent = (MLCell)this.readMatrix(buf, true);
                return new MLHandle(arrName, className, wrappedContent);
            }
            case 3: {
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString(this.matFileHeader.getByteOrder());
                MLArray mlArray = new MLObject(name, className, dims, attributes);
                tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = MatFileReader.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                int index = 0;
                while (index < mlArray.getM() * mlArray.getN()) {
                    for (int i = 0; i < numOfFields; ++i) {
                        void var27_73;
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray mLArray = this.readMatrix(buf, false);
                        } else {
                            MLEmptyArray mLEmptyArray = new MLEmptyArray();
                        }
                        var27_73.name = fieldNames[i];
                        ((MLObject)mlArray).setField(fieldNames[i], (MLArray)var27_73, index);
                    }
                    ++index;
                }
                return mlArray;
            }
            default: {
                throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(type));
            }
        }
    }

    private static String zeroEndByteArrayToString(byte[] bytes) throws IOException {
        int i;
        for (i = 0; i < bytes.length && bytes[i] != 0; ++i) {
        }
        return new String(bytes, 0, i, "UTF-8");
    }

    private static int[] readFlags(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] flags = tag.readToIntArray();
        return flags;
    }

    private static int[] readDimension(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] dims = tag.readToIntArray();
        return dims;
    }

    private static String readName(ByteBuffer buf, MatFileHeader header) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        return tag.readToString(header.getByteOrder());
    }

    void readHeader(ByteBuffer buf) throws IOException {
        String description;
        byte[] endianIndicator = new byte[2];
        if (this.matType == MatFileType.Regular) {
            byte[] descriptionBuffer = new byte[116];
            buf.get(descriptionBuffer);
            description = MatFileReader.zeroEndByteArrayToString(descriptionBuffer);
            if (!description.matches("MATLAB 5.0 MAT-file.*")) {
                throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
            }
            buf.position(buf.position() + 8);
        } else {
            description = "Simulink generated MATLAB 5.0 MAT-file";
        }
        byte[] bversion = new byte[2];
        buf.get(bversion);
        buf.get(endianIndicator);
        this.matFileHeader = MatFileHeader.parseFrom(description, bversion, endianIndicator);
        buf.order(this.matFileHeader.getByteOrder());
        buf.position(buf.position() + 7 & 0xFFFFFFF8);
    }

    private static class ISMatTag
    extends MatTag {
        private final MatFileInputStream mfis;
        private final int padding;
        private final boolean compressed;

        public ISMatTag(ByteBuffer buf) throws IOException {
            super(0, 0);
            int tmp = buf.getInt();
            if (tmp >> 16 == 0) {
                this.type = tmp;
                this.size = buf.getInt();
                this.compressed = false;
            } else {
                this.size = tmp >> 16;
                this.type = tmp & 0xFFFF;
                this.compressed = true;
            }
            this.padding = this.getPadding(this.size, this.compressed);
            this.mfis = new MatFileInputStream(buf, this.type);
        }

        public void readToByteBuffer(ByteBuffer buff, ByteStorageSupport<?> storage) throws IOException {
            int elements = this.size / this.sizeOf();
            this.mfis.readToByteBuffer(buff, elements, storage);
            this.mfis.skip(this.padding);
        }

        public byte[] readToByteArray() throws IOException {
            int elements = this.size / this.sizeOf();
            byte[] ab = new byte[elements];
            for (int i = 0; i < elements; ++i) {
                ab[i] = this.mfis.readByte();
            }
            this.mfis.skip(this.padding);
            return ab;
        }

        public double[] readToDoubleArray() throws IOException {
            int elements = this.size / this.sizeOf();
            double[] ad = new double[elements];
            for (int i = 0; i < elements; ++i) {
                ad[i] = this.mfis.readDouble();
            }
            this.mfis.skip(this.padding);
            return ad;
        }

        public int[] readToIntArray() throws IOException {
            int elements = this.size / this.sizeOf();
            int[] ai = new int[elements];
            for (int i = 0; i < elements; ++i) {
                ai[i] = this.mfis.readInt();
            }
            this.mfis.skip(this.padding);
            return ai;
        }

        private String charset(ByteOrder byteOrder) {
            switch (this.type) {
                case 16: {
                    return "UTF-8";
                }
                case 17: {
                    return byteOrder == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
                }
                case 18: {
                    return byteOrder == ByteOrder.BIG_ENDIAN ? "UTF-32BE" : "UTF-32LE";
                }
            }
            return "US-ASCII";
        }

        public String readToString(ByteOrder byteOrder) throws IOException {
            byte[] bytes = this.readToByteArray();
            return new String(bytes, this.charset(byteOrder));
        }
    }
}

