/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import com.jmatio.types.Zeros;
import java.nio.ByteBuffer;

public class MLInt16
extends MLNumericArray<Short> {
    public MLInt16(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLInt16(String name, int[] dims) {
        super(name, dims, 10, 0);
    }

    public MLInt16(String name, Short[] vals, int m) {
        super(name, 10, (Number[])vals, m);
    }

    public MLInt16(String name, short[][] vals) {
        this(name, MLInt16.short2DToShort(vals), vals.length);
    }

    public MLInt16(String name, short[] vals, int m) {
        this(name, MLInt16.castToShort(vals), m);
    }

    public Short[] createArray(int m, int n) {
        return new Short[m * n];
    }

    public short[][] getArray() {
        short[][] result = new short[this.getM()][];
        for (int m = 0; m < this.getM(); ++m) {
            result[m] = new short[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m][n] = (Short)this.getReal(m, n);
            }
        }
        return result;
    }

    private static Short[] castToShort(short[] d) {
        Short[] dest = new Short[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Short[] short2DToShort(short[][] dd) {
        Short[] d = new Short[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m = 0; m < dd.length; ++m) {
                d[m + n * dd.length] = dd[m][n];
            }
        }
        return d;
    }

    @Override
    public int getBytesAllocated() {
        return 2;
    }

    @Override
    public Short buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getShort();
    }

    @Override
    public byte[] getByteArray(Short value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putShort(value);
        return buff.array();
    }

    @Override
    public Class<Short> getStorageClazz() {
        return Short.class;
    }

    @Override
    protected Short zero() {
        return Zeros.SHORT;
    }
}

