/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import com.jmatio.types.Zeros;
import java.nio.ByteBuffer;

public class MLInt32
extends MLNumericArray<Integer> {
    public MLInt32(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLInt32(String name, int[] dims) {
        super(name, dims, 12, 0);
    }

    public MLInt32(String name, Integer[] vals, int m) {
        super(name, 12, (Number[])vals, m);
    }

    public MLInt32(String name, int[][] vals) {
        this(name, MLInt32.int2DToInteger(vals), vals.length);
    }

    public MLInt32(String name, int[] vals, int m) {
        this(name, MLInt32.castToInteger(vals), m);
    }

    public Integer[] createArray(int m, int n) {
        return new Integer[m * n];
    }

    public int[][] getArray() {
        int[][] result = new int[this.getM()][];
        for (int m = 0; m < this.getM(); ++m) {
            result[m] = new int[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m][n] = (Integer)this.get(m, n);
            }
        }
        return result;
    }

    private static Integer[] castToInteger(int[] d) {
        Integer[] dest = new Integer[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Integer[] int2DToInteger(int[][] dd) {
        Integer[] d = new Integer[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m = 0; m < dd.length; ++m) {
                d[m + n * dd.length] = dd[m][n];
            }
        }
        return d;
    }

    @Override
    public Integer buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getInt();
    }

    @Override
    public int getBytesAllocated() {
        return 4;
    }

    @Override
    public Class<Integer> getStorageClazz() {
        return Integer.class;
    }

    @Override
    public byte[] getByteArray(Integer value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putInt(value);
        return buff.array();
    }

    @Override
    protected Integer zero() {
        return Zeros.INTEGER;
    }
}

