/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import com.jmatio.types.Zeros;
import java.nio.ByteBuffer;

public class MLSingle
extends MLNumericArray<Float> {
    public MLSingle(String name, Float[] vals, int m) {
        super(name, 7, (Number[])vals, m);
    }

    public MLSingle(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public Float[] createArray(int m, int n) {
        return new Float[m * n];
    }

    @Override
    public Float buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
    }

    @Override
    public byte[] getByteArray(Float value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putFloat(value.floatValue());
        return buff.array();
    }

    @Override
    public int getBytesAllocated() {
        return 4;
    }

    @Override
    public Class<?> getStorageClazz() {
        return Float.class;
    }

    @Override
    protected Float zero() {
        return Zeros.FLOAT;
    }
}

