/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.common.DeterministicKeyMap;
import com.jmatio.types.MLArray;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class MLStructureObjectBase
extends MLArray {
    protected Set<String> keys = new LinkedHashSet<String>();
    protected SortedMap<Integer, DeterministicKeyMap<String, MLArray>> mlStructArray = new TreeMap<Integer, DeterministicKeyMap<String, MLArray>>();
    protected int currentIndex = 0;

    protected MLStructureObjectBase(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public void setField(String name, MLArray value) {
        this.setField(name, value, this.currentIndex);
    }

    public void setField(String name, MLArray value, int m, int n) {
        this.setField(name, value, this.getIndex(m, n));
    }

    public void setField(String name, MLArray value, int index) {
        this.keys.add(name);
        this.currentIndex = index;
        DeterministicKeyMap map = (DeterministicKeyMap)this.mlStructArray.get(index);
        if (map == null) {
            map = new DeterministicKeyMap(this.keys, new HashMap(this.keys.size()));
            this.mlStructArray.put(index, map);
        }
        map.put(name, value);
    }

    public int getMaxFieldLenth() {
        int maxLen = 0;
        for (String s : this.keys) {
            maxLen = Math.max(maxLen, s.length());
        }
        return maxLen + 1;
    }

    public byte[] getKeySetToByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        char[] buffer = new char[this.getMaxFieldLenth()];
        try {
            for (String s : this.keys) {
                Arrays.fill(buffer, '\u0000');
                System.arraycopy(s.toCharArray(), 0, buffer, 0, s.length());
                dos.writeBytes(new String(buffer));
            }
        }
        catch (IOException e) {
            System.err.println("Could not write Structure key set to byte array: " + e);
            return new byte[0];
        }
        return baos.toByteArray();
    }

    public Collection<MLArray> getAllFields() {
        ArrayList<MLArray> fields = new ArrayList<MLArray>();
        for (Map map : this.mlStructArray.values()) {
            fields.addAll(map.values());
        }
        return fields;
    }

    public Collection<String> getFieldNames() {
        return new LinkedHashSet<String>(this.keys);
    }

    public MLArray getField(String name) {
        return this.getField(name, this.currentIndex);
    }

    public Map<String, MLArray> getFields(int i) {
        return (Map)this.mlStructArray.get(i);
    }

    public MLArray getField(String name, int m, int n) {
        return this.getField(name, this.getIndex(m, n));
    }

    public MLArray getField(String name, int index) {
        if (this.mlStructArray.isEmpty()) {
            return null;
        }
        return (MLArray)((DeterministicKeyMap)this.mlStructArray.get(index)).get(name);
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + " = \n");
        if (this.getM() * this.getN() == 1) {
            for (String key : this.keys) {
                sb.append("\t" + key + " : " + this.getField(key) + "\n");
            }
        } else {
            sb.append("\n");
            sb.append(this.getM() + "x" + this.getN());
            sb.append(" struct array with fields: \n");
            for (String key : this.keys) {
                sb.append("\t" + key + "\n");
            }
        }
        return sb.toString();
    }
}

