/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.VMSupport;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.CRSLogMonitor;
import com.azul.crs.client.service.ClassLoadMonitor;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FirstCallMonitor;
import com.azul.crs.client.service.GCLogMonitor;
import com.azul.crs.client.service.HeartbeatService;
import com.azul.crs.client.service.JFRMonitor;
import com.azul.crs.client.service.JarLoadMonitor;
import com.azul.crs.client.service.VMLogMonitor;
import com.azul.crs.client.service.VMToolingClient;
import com.azul.crs.client.util.DnsDetect;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.launcher.LauncherHelper;

final class Agent001 {
    private static final long DEFAULT_SHUTDOWN_DELAY = 0L;
    private static final int FLUSH_THREAD_DEFAULT_PERIOD_MS = 1000;
    private static final int FLUSH_THREAD_FORCE_DEFAULT_PERIOD_MS = 1800000;
    private static JFRMonitor jfrMonitor;
    private static GCLogMonitor gclogMonitor;
    private static VMLogMonitor vmlogMonitor;
    private static JarLoadMonitor jarLoadMonitor;
    private static ClassLoadMonitor classLoadMonitor;
    private static FirstCallMonitor firstCallMonitor;
    private static HeartbeatService heartbeatService;
    private static Client client;
    private static VMSupport vmSupport;
    private static VMToolingClient vmToolingClient;
    private static volatile Thread agentStartupThread;
    private static final Object agentStartupThreadLock;
    private static volatile boolean waitingForMainMethod;
    private static int forceFlushTimeout;
    private static long delayTermination;
    private static final Logger logger;
    private static final CRSLogMonitor crslogMonitor;

    Agent001() {
    }

    public static void premain(String string, Instrumentation instrumentation) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Agent001.teardownAgent(Utils.currentTimeCount())));
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        Options.read(string);
        try {
            vmSupport = VMSupport.init(Options.getConnectionPort(), Options.getConnectionSecret());
            vmSupport.registerAgent(Agent001.class);
            Method method = Agent001.class.getMethod("notifyToJavaCall", String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, method);
            Method method2 = Agent001.class.getMethod("notifyClassLoad", String.class, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_CLASS_LOAD, method2);
            Method method3 = Agent001.class.getMethod("notifyFirstCall", Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_FIRST_CALL, method3);
            if (Options.sendJVMLogs.isYes()) {
                Method method4 = Agent001.class.getMethod("notifyVMLogEntry", String.class, String.class);
                vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_VM_LOG_ENTRY, method4);
            }
        }
        catch (IOException | NoSuchMethodException | SecurityException exception) {
            logger.error("Failed to initialize", exception);
            return;
        }
        PerformanceMetrics.init();
        if (Options.forceSyncTimeout.isSet()) {
            forceFlushTimeout = Options.forceSyncTimeout.getInt() * 1000;
        }
        if (Options.delayTermination.isSet()) {
            delayTermination = Options.delayTermination.getLong();
        }
        System.setProperty("com.azul.crs.instance.options.delayTermination", Long.toString(delayTermination));
        if ("on".equals(Options.mode.get())) {
            Agent001.activateAgent(null);
        } else if (!"auto".equals(Options.mode.get())) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activateAgent(String string) {
        if (Client.isVMShutdownInitiated() && Client.getVMShutdownDeadline().remainder(TimeUnit.MILLISECONDS) <= 0L) {
            return;
        }
        Object object = agentStartupThreadLock;
        synchronized (object) {
            if (agentStartupThread == null) {
                if (logger.isEnabled(Logger.Level.DEBUG)) {
                    logger.debug("CRS agent started. VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                }
                agentStartupThread = new Thread(() -> Agent001.startupAgent(string), "CRSStartThread");
                agentStartupThread.setDaemon(true);
                agentStartupThread.start();
                agentStartupThreadLock.notify();
            } else if (string != null) {
                try {
                    agentStartupThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Agent001.postMainMethodName(string);
            }
        }
    }

    private static void startupAgent(String string) {
        long l = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
        try {
            client = new Client(Agent001.getClientProps(), new Client.ClientListener(){
                private boolean connectionEstablished = false;

                @Override
                public void authenticated() {
                    if (client.getVmId() != null) {
                        logger.info("Agent authenticated: vmId=%s", client.getVmId());
                        if (logger.isEnabled(Logger.Level.DEBUG)) {
                            logger.debug(" VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                        }
                        if (!this.connectionEstablished) {
                            client.connectionEstablished();
                        }
                        this.connectionEstablished = true;
                    } else {
                        Agent001.disableCRS("Backend malfunction, invalid vmId received", null);
                    }
                }

                @Override
                public void syncFailed(Result<String[]> result) {
                    IOException iOException;
                    logger.error("Data synchronization to the CRS cloud has failed: %s", result.errorString());
                    if (result.hasException() && (iOException = result.getException()) instanceof CRSException && ((CRSException)iOException).isProtocolFailure()) {
                        Agent001.disableCRS("Protocol failure", iOException);
                    }
                }
            });
            Agent001.postVMStart(l, string);
            if (Options.sendJVMLogs.isYes()) {
                jfrMonitor = JFRMonitor.getInstance(client, Options.lifetimejfr.get());
                jfrMonitor.start();
            }
            heartbeatService = HeartbeatService.getInstance(client);
            crslogMonitor.setClient(client);
            VMCRSCapabilities vMCRSCapabilities = VMCRSCapabilities.init();
            if (Options.sendJVMLogs.isYes()) {
                if (vMCRSCapabilities.has(VMCRSCapability.POST_VM_LOG_EVENTS)) {
                    vmlogMonitor = VMLogMonitor.getInstance(client);
                } else {
                    gclogMonitor = GCLogMonitor.getInstance(client, l);
                }
            }
            if (vMCRSCapabilities.has(VMCRSCapability.POST_CLASS_LOAD_EVENTS)) {
                classLoadMonitor = ClassLoadMonitor.getInstance(client);
            }
            if (vMCRSCapabilities.has(VMCRSCapability.POST_FIRST_CALL_EVENTS)) {
                firstCallMonitor = FirstCallMonitor.getInstance(client);
            }
            if (vMCRSCapabilities.has(VMCRSCapability.POST_JAR_LOAD_EVENTS)) {
                jarLoadMonitor = JarLoadMonitor.getInstance(client);
            }
            if (vMCRSCapabilities.has(VMCRSCapability.POST_VM_TOOLING_EVENT)) {
                vmToolingClient = VMToolingClient.getInstance(client);
                vmToolingClient.setJarLoadMonitor(jarLoadMonitor);
            }
            client.startup();
            Agent001.startServices(crslogMonitor, heartbeatService, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor, jarLoadMonitor, vmToolingClient);
            EventsFlusher.start();
            Agent001.postNetworkInformation();
            Agent001.postSystemInformation();
        }
        catch (Throwable throwable) {
            Agent001.disableCRS("CRS failed to start: %s", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void teardownAgent(long l) {
        try {
            Utils.Deadline deadline = Utils.Deadline.in(delayTermination, TimeUnit.MILLISECONDS);
            Client.setVMShutdownInitiated(deadline);
            long l2 = Utils.currentTimeCount();
            if (delayTermination > 0L) {
                Object object;
                logger.trace("checking if startup is complete and waiting for it to finish (%d ms)", delayTermination);
                if (waitingForMainMethod) {
                    long l3;
                    while (agentStartupThread == null && (l3 = deadline.remainder(TimeUnit.MILLISECONDS)) > 0L) {
                        object = agentStartupThreadLock;
                        synchronized (object) {
                            agentStartupThreadLock.wait(l3);
                        }
                    }
                }
                if (agentStartupThread == null) {
                    return;
                }
                agentStartupThread.join(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                logger.debug("drain native queue", new Object[0]);
                EventsFlusher.stop();
                Agent001.stopServices(deadline, vmToolingClient, heartbeatService, jfrMonitor, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor, jarLoadMonitor);
                object = PerformanceMetrics.logPreShutdown(Utils.elapsedTimeMillis(l2));
                Agent001.postVMShutdown((Map)object);
                client.shutdown(deadline);
            }
            if (client != null && client.getVmId() != null) {
                PerformanceMetrics.logShutdown(Utils.elapsedTimeMillis(l2));
                PerformanceMetrics.report();
                logger.info("Agent terminated: vmId=%s, runningTime=%d", client.getVmId(), Utils.elapsedTimeMillis(l));
            } else {
                logger.info("Agent shut down during startup. Data is discarded. runningTime=%d", Utils.elapsedTimeMillis(l));
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("Agent failed to process shutdown during startup. Data is discarded", new Object[0]);
        }
        catch (Throwable throwable) {
            logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
            throwable.printStackTrace(System.err);
        }
    }

    private static void postVMStart(long l, String string) throws Exception {
        Map<String, Object> map = new Inventory().populate(client.getEnvFilter(), client.getSysPropsFilter()).mainMethod(string).toMap();
        logger.trace("Post VM start to CRS service", new Object[0]);
        client.postVMStart(map, l);
    }

    private static void postMainMethodName(String string) {
        Map<String, Object> map = new Inventory().mainMethod(string).toMap();
        client.patchInventory(map);
    }

    private static void postNetworkInformation() {
        Map<String, Object> map = new Inventory().networkInformation().toMap();
        client.patchInventory(map);
    }

    private static void postSystemInformation() {
        Map<String, Object> map = new Inventory().systemInformation().toMap();
        client.patchInventory(map);
    }

    private static void postVMShutdown(Map map) {
        logger.trace("Post VM shutdown to CRS service", new Object[0]);
        ArrayList<VMEvent> arrayList = new ArrayList<VMEvent>();
        arrayList.add(new VMEvent().eventType(VMEvent.Type.VM_PERFORMANCE_METRICS).randomEventId().eventTime(System.currentTimeMillis()).eventPayload(map));
        client.postVMShutdown(arrayList);
    }

    private static void startServices(ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.start();
            }
            catch (Exception exception) {
                logger.error("Agent failed to start " + clientService.serviceName() + ". Data is discarded", new Object[0]);
                exception.printStackTrace(System.err);
            }
        }
    }

    private static void stopServices(Utils.Deadline deadline, ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.stop(deadline);
            }
            catch (Exception exception) {
                logger.error("Agent failed to stop " + clientService.serviceName() + ". Data is discarded", new Object[0]);
                exception.printStackTrace(System.err);
            }
        }
    }

    private static synchronized void shutdownAgent() {
        for (VMSupport.CrsNotificationType crsNotificationType : VMSupport.CrsNotificationType.values()) {
            vmSupport.enableEventNotifications(crsNotificationType, false);
        }
        vmSupport.disableCRS();
        if (client != null) {
            client.cancel();
        }
    }

    private static void disableCRS(String string, Throwable throwable) {
        Agent001.shutdownAgent();
        if (throwable == null) {
            logger.error(string, new Object[0]);
        } else {
            logger.error(string, throwable);
            if (throwable.getCause() != null) {
                logger.trace("caused by: %s", throwable.getCause());
            }
        }
    }

    private static Map<Client.ClientProp, Object> getClientProps() throws CRSException {
        boolean bl;
        Map<Client.ClientProp, Object> map = Options.getClientProps();
        boolean bl2 = map.get((Object)Client.ClientProp.API_URL) != null;
        boolean bl3 = bl = map.get((Object)Client.ClientProp.API_MAILBOX) != null;
        if (!bl2 || !bl) {
            try {
                DnsDetect dnsDetect = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", dnsDetect.getRecordNamePostfix().length() > 0 ? " (postfix " + dnsDetect.getRecordNamePostfix() + ")" : "");
                if (!bl2) {
                    map.put(Client.ClientProp.API_URL, "https://" + dnsDetect.queryEndpoint());
                }
                if (!bl) {
                    map.put(Client.ClientProp.API_MAILBOX, dnsDetect.queryMailbox());
                }
            }
            catch (IOException iOException) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", iOException);
            }
        }
        map.put(Client.ClientProp.VM_SHUTDOWN_DELAY, delayTermination);
        return map;
    }

    public static void notifyToJavaCall(String string) {
        Runnable runnable = null;
        if (string.startsWith("sun/launcher/LauncherHelper.checkAndLoadMain")) {
            waitingForMainMethod = true;
            runnable = () -> {
                try {
                    Class<?> clazz;
                    while ((clazz = LauncherHelper.getApplicationClass()) == null) {
                        Thread.sleep(10L);
                    }
                    Agent001.mainMethodDetected(clazz.getName().replace('.', '/') + ".main");
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                }
            };
        } else if (!(string.startsWith("apple/security/AppleProvider") || string.startsWith("java/") || string.startsWith("javax/") || string.startsWith("sun/") || string.startsWith("com/sun/") || string.startsWith("com/fasterxml") || string.startsWith("org/jcp") || string.startsWith("com/azul/crs") || string.startsWith("jdk/jfr"))) {
            runnable = () -> Agent001.mainMethodDetected(string);
        }
        if (runnable != null) {
            vmSupport.enableEventNotifications(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, false);
            Thread thread = new Thread(runnable, "CRSMainMethodUpdate");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static void mainMethodDetected(String string) {
        if (!string.startsWith("com/sun/tools")) {
            Agent001.activateAgent(string);
        } else {
            Agent001.shutdownAgent();
        }
    }

    public static void notifyFirstCall(int n, String string) {
        firstCallMonitor.notifyMethodFirstCalled(n, string);
    }

    public static void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        if (jarLoadMonitor != null) {
            jarLoadMonitor.notifyClassSourceSeen(string2);
        }
        classLoadMonitor.notifyClassLoad(string, byArray, byArray2, n, n2, string2);
    }

    public static void notifyVMLogEntry(String string, String string2) {
        vmlogMonitor.notifyVMLogEntry(string, string2);
    }

    static {
        agentStartupThreadLock = new Object();
        waitingForMainMethod = false;
        forceFlushTimeout = 1800000;
        delayTermination = 0L;
        logger = Logger.getLogger(Agent001.class);
        crslogMonitor = new CRSLogMonitor();
        Logger.addOutputStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                crslogMonitor.notifyCRSLogEntry(byArray, n, n2);
            }
        });
    }

    private static final class EventsFlusher
    implements Runnable {
        private static volatile boolean stopped = false;
        private static Thread thread = null;
        private static final Object flushLock = new Object();
        private static final Object threadLock = new Object();

        private EventsFlusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void start() {
            Object object = threadLock;
            synchronized (object) {
                if (thread != null || stopped) {
                    return;
                }
                thread = new Thread((Runnable)new EventsFlusher(), "CRSEventsFlushingThread");
                thread.setDaemon(true);
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void stop() {
            Object object = flushLock;
            synchronized (object) {
                stopped = true;
                flushLock.notify();
            }
            object = threadLock;
            synchronized (object) {
                try {
                    if (thread != null) {
                        thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long l = Utils.currentTimeCount();
                while (true) {
                    boolean bl;
                    Object object = flushLock;
                    synchronized (object) {
                        try {
                            flushLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    if (stopped) break;
                    boolean bl2 = bl = Utils.elapsedTimeMillis(l) >= (long)forceFlushTimeout;
                    if (bl) {
                        l = Utils.currentTimeCount();
                    }
                    vmSupport.drainQueues(bl, false);
                }
                vmSupport.drainQueues(true, true);
            }
            catch (Throwable throwable) {
                logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
            }
        }
    }

    private static final class VMCRSCapabilities {
        private final Set<VMCRSCapability> capabilities;

        private VMCRSCapabilities(Set<VMCRSCapability> set) {
            this.capabilities = Collections.unmodifiableSet(set);
            logger.trace("Active VMCRSCapabilities: " + this.capabilities, new Object[0]);
        }

        private boolean has(VMCRSCapability vMCRSCapability) {
            return this.capabilities.contains((Object)vMCRSCapability);
        }

        private static VMCRSCapabilities init() {
            HashSet<VMCRSCapability> hashSet = new HashSet<VMCRSCapability>();
            try {
                if (VMToolingClient.isToolingImplemented()) {
                    hashSet.addAll(Arrays.asList(VMCRSCapability.POST_VM_TOOLING_EVENT, VMCRSCapability.POST_JAR_LOAD_EVENTS));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = vmSupport.getVMCRSCapabilities();
            if (stringArray != null) {
                for (String string : stringArray) {
                    try {
                        hashSet.add(VMCRSCapability.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.trace("VM reported unknown capability: " + string, new Object[0]);
                    }
                }
            } else {
                hashSet.addAll(Arrays.asList(VMCRSCapability.POST_CLASS_LOAD_EVENTS, VMCRSCapability.POST_FIRST_CALL_EVENTS, VMCRSCapability.POST_NOTIFY_TO_JAVA_CALLS));
            }
            return new VMCRSCapabilities(hashSet);
        }
    }

    private static enum VMCRSCapability {
        POST_CLASS_LOAD_EVENTS,
        POST_FIRST_CALL_EVENTS,
        POST_NOTIFY_TO_JAVA_CALLS,
        POST_VM_LOG_EVENTS,
        POST_JAR_LOAD_EVENTS,
        POST_VM_TOOLING_EVENT;

    }
}

