/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.client.Result;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;

public class CRSException
extends IOException {
    public static final int REASON_NO_ENDPOINT = -1;
    public static final int AUTHENTICATION_FAILURE = -2;
    public static final int REASON_GENERIC = -3;
    public static final int REASON_INTERNAL_ERROR = -4;
    public static final int REASON_UNSUPPORTED_VERSION = -5;
    private static final String MESSAGE_NO_ENDPOINT = "No CRS endpoint found.\nPlease specify via command line arguments or verify if your DNS has CRS record provisioned";
    private static final String MESSAGE_ENDPOINT_AUTHENTICATION_FAILED = "CRS endpoint authentication error.\nPlease ensure you have a proper endpoint address specified in the command line or your DNS settings.";
    private static final String MESSAGE_ENDPOINT_ADDRESS = "\n API endpoint address as configured now: ";
    private static final String MESSAGE_UNSUPPORTED_VERSION = "\n Unsupported version";
    private final int reason;
    private final Result result;
    private final Client client;

    public CRSException(int n) {
        this(null, n, null, null);
    }

    public CRSException(int n, String string, Throwable throwable) {
        super(string, throwable);
        this.client = null;
        this.reason = n;
        this.result = null;
    }

    public CRSException(Client client, int n, String string, Result result) {
        super(string);
        this.client = client;
        this.reason = n;
        this.result = result;
        if (result.hasException()) {
            this.initCause(result.getException());
        }
    }

    public boolean isProtocolFailure() {
        return this.reason == -5;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.reason) {
            case -1: {
                stringBuilder.append(MESSAGE_NO_ENDPOINT);
                break;
            }
            case -5: {
                stringBuilder.append(MESSAGE_UNSUPPORTED_VERSION);
                break;
            }
            case -2: {
                if (this.getCause() != null) {
                    if (this.getCause() instanceof SSLHandshakeException) {
                        stringBuilder.append(MESSAGE_ENDPOINT_AUTHENTICATION_FAILED);
                    } else if (this.getCause() instanceof UnknownHostException) {
                        stringBuilder.append(MESSAGE_NO_ENDPOINT);
                    } else {
                        stringBuilder.append(this.getMessage()).append(this.result.errorString());
                    }
                } else {
                    stringBuilder.append(this.getMessage());
                    if (this.result != null) {
                        stringBuilder.append(this.result.errorString());
                    }
                }
                if (this.client == null || this.client.getRestAPI() == null) break;
                stringBuilder.append(MESSAGE_ENDPOINT_ADDRESS).append(this.client.getRestAPI());
                break;
            }
            default: {
                stringBuilder = new StringBuilder(this.getMessage());
                if (this.getCause() == null) break;
                stringBuilder.append("\nCaused by: ").append(this.getCause().toString());
            }
        }
        return stringBuilder.toString();
    }
}

