/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConnectionManager {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String AUTH_TOKEN_RESOURCE = "/crs/auth/rt/token";
    private static final String EVENT_RESOURCE = "/crs/instance/{vmId}";
    private static final String ARTIFACT_CHUNK_RESOURCE = "/crs/artifact/chunk";
    private static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    private static final String MEDIA_TYPE_JSON = "application/json";
    private static final String MEDIA_TYPE_BINARY = "application/octet-stream";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_PATCH = "PATCH";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String AGENT_VERSION = "x-agent-version";
    private static final int MAX_REQUEST_BYTES = 0x200000;
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_SLEEP = 100L;
    @Deprecated
    private static final String DEFAULT_ACCESS_KEY = "r1fhe2lVGN1EgDHH0Eg8d94tjv12e0F7a78RNysB";
    private final Logger logger = Logger.getLogger(ConnectionManager.class);
    private final String restAPI;
    private final String mailbox;
    private final ConnectionListener listener;
    private final HttpConnectionPinger connectionPinger;
    private static final long PING_CONNECTION_EVERY_MS = 4000L;
    private static final long TOKEN_REFRESH_TIMEOUT_MS = 300000L;
    public static final int HTTP_STATUS_UNAUTHORIZED = 401;
    public static final int HTTP_STATUS_UPGRADE_REQUIRED = 426;
    private final Client client;
    private final String keystore;
    private final String apiKey;
    private String runtimeToken;
    private long nextRuntimeTokenRefreshTimeCount;
    private String vmId;
    private boolean unrecoverableError;
    private SSLSocketFactory sslSocketFactoryOne;
    private SSLSocketFactory sslSocketFactoryTwo;
    private static final ConnectionConsumer NONE = new ConnectionConsumer(){

        @Override
        public void consume(HttpsURLConnection httpsURLConnection) throws IOException {
        }
    };

    ConnectionManager(Map<Client.ClientProp, Object> map, Client client, ConnectionListener connectionListener) {
        this.client = client;
        this.listener = connectionListener;
        this.connectionPinger = new HttpConnectionPinger(4000L, TimeUnit.MILLISECONDS);
        this.restAPI = (String)map.get((Object)Client.ClientProp.API_URL);
        this.mailbox = (String)map.get((Object)Client.ClientProp.API_MAILBOX);
        this.keystore = (String)map.get((Object)Client.ClientProp.KS);
        this.apiKey = this.findApiKey(map);
        this.logger.info("Using CRS endpoint configuration\n   API url = %s\n   mailbox = %s", this.restAPI, this.mailbox);
        if (this.keystore != null) {
            this.logger.info("   auth override keystore = %s", this.keystore);
        }
    }

    void start() throws IOException {
        this.createCustomTrustManagers();
        this.saveRuntimeToken(this.getRuntimeToken(this.client.getClientVersion(), this.mailbox));
        this.connectionPinger.start();
    }

    void stop(Utils.Deadline deadline) {
        this.connectionPinger.stop(deadline);
    }

    private void saveRuntimeToken(String[] stringArray) {
        if (stringArray.length == 2) {
            this.runtimeToken = stringArray[0];
            this.vmId = stringArray[1];
            this.listener.authenticated();
        } else {
            this.listener.syncFailed(new Result<String[]>(new IOException("Protocol failure, wrong auth response")));
        }
    }

    private X509TrustManager getX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new NoSuchAlgorithmException();
    }

    private void createCustomTrustManagers() throws CRSException {
        try {
            char[] cArray = "crscrs".toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            Object object = this.keystore == null ? this.getClass().getResourceAsStream("crs.jks") : new FileInputStream(this.keystore);
            Object object2 = null;
            try {
                keyStore.load((InputStream)object, cArray);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            object = KeyManagerFactory.getInstance("NewSunX509");
            ((KeyManagerFactory)object).init(keyStore, cArray);
            object2 = this.getX509TrustManager(keyStore);
            X509TrustManager x509TrustManager = this.getX509TrustManager(null);
            int n = object2.getAcceptedIssuers().length;
            int n2 = x509TrustManager.getAcceptedIssuers().length;
            X509Certificate[] x509CertificateArray = new X509Certificate[n + n2];
            System.arraycopy(object2.getAcceptedIssuers(), 0, x509CertificateArray, 0, n);
            System.arraycopy(x509TrustManager.getAcceptedIssuers(), 0, x509CertificateArray, n, n2);
            X509TrustManager x509TrustManager2 = new X509TrustManager((X509TrustManager)object2, x509TrustManager, x509CertificateArray){
                final /* synthetic */ X509TrustManager val$tmOne;
                final /* synthetic */ X509TrustManager val$tmDefault;
                final /* synthetic */ X509Certificate[] val$allIssuers;
                {
                    this.val$tmOne = x509TrustManager;
                    this.val$tmDefault = x509TrustManager2;
                    this.val$allIssuers = x509CertificateArray;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    throw new CertificateException("unsupported operation");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    try {
                        this.val$tmOne.checkServerTrusted(x509CertificateArray, string);
                    }
                    catch (CertificateException certificateException) {
                        this.val$tmDefault.checkServerTrusted(x509CertificateArray, string);
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return this.val$allIssuers;
                }
            };
            KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            this.sslSocketFactoryOne = this.createSocketFactory((X509TrustManager)object2, keyManagerArray);
            this.sslSocketFactoryTwo = this.createSocketFactory(x509TrustManager2, keyManagerArray);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
            this.unrecoverableError = true;
            throw new CRSException(-4, "Unrecoverable internal error: ", exception);
        }
    }

    private SSLSocketFactory createSocketFactory(X509TrustManager x509TrustManager, KeyManager[] keyManagerArray) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerArray, new TrustManager[]{x509TrustManager}, null);
        return sSLContext.getSocketFactory();
    }

    private HttpsURLConnection createConnection(String string) throws IOException {
        if (this.unrecoverableError) {
            throw new IOException("Unrecoverable error");
        }
        URL uRL = new URL(string);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setUseCaches(false);
        httpsURLConnection.setConnectTimeout(30000);
        httpsURLConnection.setReadTimeout(20000);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_JSON);
        httpsURLConnection.setRequestProperty(HEADER_ACCEPT, MEDIA_TYPE_TEXT_PLAIN);
        httpsURLConnection.setRequestProperty(HEADER_CONNECTION, KEEP_ALIVE);
        return httpsURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<String[]> requestAny(String string, String string2, ConnectionConsumer connectionConsumer, ConnectionConsumer connectionConsumer2) throws IOException {
        long l = Utils.currentTimeCount();
        Response<String[]> response = new Response<String[]>();
        HttpsURLConnection httpsURLConnection = this.createConnection(string);
        httpsURLConnection.setSSLSocketFactory(this.sslSocketFactoryOne);
        if (string2.equals(METHOD_PATCH)) {
            httpsURLConnection.setRequestProperty("X-HTTP-Method-Override", string2);
            string2 = METHOD_POST;
        }
        httpsURLConnection.setRequestProperty(HEADER_AUTHORIZATION, "Bearer " + this.runtimeToken);
        httpsURLConnection.setRequestProperty(AGENT_VERSION, this.client.getClientVersion() + '+' + this.client.getClientRevision());
        httpsURLConnection.setRequestMethod(string2);
        connectionConsumer.consume(httpsURLConnection);
        httpsURLConnection.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(l), httpsURLConnection);
        try {
            connectionConsumer2.consume(httpsURLConnection);
            int n = httpsURLConnection.getResponseCode();
            String string3 = httpsURLConnection.getResponseMessage();
            response.code(n);
            response.message(string3);
            this.logger.debug("requestAny response code %d", n);
            if (n >= 400 && httpsURLConnection.getErrorStream() != null) {
                response.error(this.readStream(httpsURLConnection.getErrorStream()));
            } else if (httpsURLConnection.getInputStream() != null) {
                response.payload(this.readStreamToArray(httpsURLConnection.getInputStream()));
            }
            if (n == 401 && Utils.currentTimeCount() > this.nextRuntimeTokenRefreshTimeCount) {
                this.saveRuntimeToken(this.refreshRuntimeToken(this.runtimeToken));
                Response<String[]> response2 = this.requestAny(string, string2, connectionConsumer, connectionConsumer2);
                return response2;
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(l));
            httpsURLConnection.disconnect();
        }
        return response;
    }

    public Response<String[]> sendVMEventBatch(Collection<VMEvent> collection) throws IOException {
        Iterator<String> iterator = Payload.toJsonArrays(collection, 0x200000);
        Response<String[]> response = new Response<String[]>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = this.restAPI + EVENT_RESOURCE.replace("{vmId}", this.vmId);
            response = this.requestAnyJson(string2, METHOD_POST, string);
            if (response.successful()) continue;
            break;
        }
        return response;
    }

    public void requestWithRetries(ResponseSupplier responseSupplier, String string, int n, long l) {
        Result<Object> result = this.requestWithRetriesImpl(responseSupplier, string, n, l);
        if (!result.successful()) {
            if (this.isUpgradeNeeded(result)) {
                result = new Result(this.createUpgradeNeededException(result));
            }
            this.listener.syncFailed(result);
        }
    }

    private Result<String[]> requestWithRetriesImpl(ResponseSupplier responseSupplier, String string, int n, long l) {
        Result<Object> result;
        int n2 = 1;
        long l2 = Utils.currentTimeCount();
        while (true) {
            try {
                result = new Result<String[]>(responseSupplier.get());
                if (result.successful()) {
                    this.logger.debug("Request %s succeeded on attempt %d, elapsed%s", string, n2, Utils.elapsedTimeString(l2));
                    return result;
                }
            }
            catch (IOException iOException) {
                this.logger.debug("Request %s failed on attempt %s of %s, elapsed%s: %s", string, n2, n, Utils.elapsedTimeString(l2), iOException.toString());
                result = new Result(iOException);
            }
            if (!result.canRetry() || ++n2 > n) break;
            Utils.sleep(l);
        }
        this.logger.debug("Request %s aborted after %d attempt, elapsed%s", string, n2, Utils.elapsedTimeString(l2));
        return result;
    }

    Response<String[]> requestAnyJson(final String string, final String string2, final String string3) throws IOException {
        return this.requestAny(string, string2, NONE, new ConnectionConsumer(){

            @Override
            public void consume(HttpsURLConnection httpsURLConnection) throws IOException {
                ConnectionManager.this.logger.debug("%s %s\n", string2, string);
                ConnectionManager.this.logger.trace("%s\n\n", string3);
                ConnectionManager.this.writeData(httpsURLConnection, string3.getBytes(UTF_8));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = 0L;
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                l += (long)n;
            }
        }
        finally {
            PerformanceMetrics.logBytes(l, 0L);
            inputStream.close();
        }
        return byteArrayOutputStream.toString(UTF_8);
    }

    private String[] readStreamToArray(InputStream inputStream) throws IOException {
        String string;
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        bufferedReader.close();
        return linkedList.toArray(new String[0]);
    }

    private void writeData(URLConnection uRLConnection, byte[] byArray, int n) throws IOException {
        try (OutputStream outputStream = uRLConnection.getOutputStream();){
            outputStream.write(byArray, 0, n);
            PerformanceMetrics.logBytes(0L, n);
        }
    }

    private void writeData(URLConnection uRLConnection, byte[] byArray) throws IOException {
        this.writeData(uRLConnection, byArray, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putBinaryData(String string, ConnectionConsumer connectionConsumer) throws IOException {
        long l = Utils.currentTimeCount();
        Response response = new Response();
        HttpsURLConnection httpsURLConnection = this.createConnection(string);
        httpsURLConnection.setSSLSocketFactory(this.sslSocketFactoryTwo);
        httpsURLConnection.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_BINARY);
        httpsURLConnection.setRequestMethod(METHOD_PUT);
        httpsURLConnection.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(l), httpsURLConnection);
        try {
            connectionConsumer.consume(httpsURLConnection);
            response.code(httpsURLConnection.getResponseCode());
            response.message(httpsURLConnection.getResponseMessage());
            if (!response.successful()) {
                response.error(this.readStream(httpsURLConnection.getErrorStream()));
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(l));
            httpsURLConnection.disconnect();
        }
        return response;
    }

    public Response<String[]> sendVMArtifactChunk(VMArtifactChunk vMArtifactChunk, Client.DataWriter dataWriter) throws IOException {
        String[] stringArray;
        String string;
        Response response;
        Response<String[]> response2 = this.requestAnyJson(this.restAPI + ARTIFACT_CHUNK_RESOURCE, METHOD_POST, vMArtifactChunk.toJson());
        if (response2.successful() && dataWriter != null && !(response = this.putBinaryData(string = (stringArray = response2.getPayload())[0], httpsURLConnection -> dataWriter.writeData(new Utils.CountingOutputStream(httpsURLConnection.getOutputStream(), l -> PerformanceMetrics.logBytes(0L, l))))).successful()) {
            throw new IOException("Created VM artifact chunk failed to upload data: chunkId=" + stringArray[1] + ", error=" + response.getError());
        }
        return response2;
    }

    private Response<String[]> retrieveRuntimeToken(HttpsURLConnection httpsURLConnection) throws IOException {
        Response<String[]> response = new Response().code(httpsURLConnection.getResponseCode()).message(httpsURLConnection.getResponseMessage());
        if (!response.successful()) {
            if (httpsURLConnection.getErrorStream() != null) {
                response.error(this.readStream(httpsURLConnection.getErrorStream()));
            }
            return response;
        }
        return response.payload(this.readStreamToArray(httpsURLConnection.getInputStream()));
    }

    private String[] getRuntimeToken(final String string, final String string2) throws CRSException {
        this.logger.info("Get runtime token: clientVersion=%s, mailbox=%s", string, string2);
        final long l = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        Result<String[]> result = this.requestWithRetriesImpl(new ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long l2 = Utils.currentTimeCount();
                HttpsURLConnection httpsURLConnection = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE + "?clientVersion=" + string + "&mailbox=" + string2);
                httpsURLConnection.setSSLSocketFactory(ConnectionManager.this.sslSocketFactoryOne);
                httpsURLConnection.setRequestProperty("x-api-key", ConnectionManager.this.apiKey);
                httpsURLConnection.setRequestMethod(ConnectionManager.METHOD_GET);
                httpsURLConnection.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(l2), httpsURLConnection);
                try {
                    Response response = ConnectionManager.this.retrieveRuntimeToken(httpsURLConnection);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(l));
                    httpsURLConnection.disconnect();
                }
            }
        }, "getRuntimeToken", 3, 100L);
        if (!result.successful()) {
            this.throwIfUpgradeIsNeeded(result);
            throw new CRSException(this.client, -2, "Cannot get runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    private void throwIfUpgradeIsNeeded(Result<?> result) throws CRSException {
        if (this.isUpgradeNeeded(result)) {
            throw this.createUpgradeNeededException(result);
        }
    }

    private boolean isUpgradeNeeded(Result<?> result) {
        return result.hasResponse() && result.getResponse().getCode() == 426;
    }

    private CRSException createUpgradeNeededException(Result<?> result) {
        String string;
        String string2 = string = result.hasResponse() ? result.getResponse().getError() : null;
        if (string == null || string.isEmpty()) {
            string = "Unsupported version";
        }
        return new CRSException(this.client, -5, string, result);
    }

    private String[] refreshRuntimeToken(final String string) throws IOException {
        final long l = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        this.logger.info("Refresh runtime token", new Object[0]);
        Result<String[]> result = this.requestWithRetriesImpl(new ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long l2 = Utils.currentTimeCount();
                HttpsURLConnection httpsURLConnection = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE);
                httpsURLConnection.setSSLSocketFactory(ConnectionManager.this.sslSocketFactoryOne);
                httpsURLConnection.setRequestProperty("x-api-key", ConnectionManager.this.apiKey);
                httpsURLConnection.setRequestProperty(ConnectionManager.HEADER_CONTENT_TYPE, ConnectionManager.MEDIA_TYPE_TEXT_PLAIN);
                httpsURLConnection.setRequestMethod(ConnectionManager.METHOD_POST);
                httpsURLConnection.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(l2), httpsURLConnection);
                try {
                    httpsURLConnection.getOutputStream().write(string.getBytes());
                    Response response = ConnectionManager.this.retrieveRuntimeToken(httpsURLConnection);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(l));
                    httpsURLConnection.disconnect();
                }
            }
        }, "refreshRuntimeToken", 3, 100L);
        if (!result.successful()) {
            this.throwIfUpgradeIsNeeded(result);
            throw new CRSException(this.client, -2, "Cannot refresh runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    private String findApiKey(Map<Client.ClientProp, Object> map) {
        String string = (String)map.get((Object)Client.ClientProp.ACCESS_KEY);
        if (string != null) {
            return string;
        }
        return DEFAULT_ACCESS_KEY;
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public String getRestAPI() {
        return this.restAPI;
    }

    @FunctionalInterface
    public static interface ResponseSupplier {
        public Response<String[]> get() throws IOException;
    }

    private static interface ConnectionConsumer {
        public void consume(HttpsURLConnection var1) throws IOException;
    }

    private class HttpConnectionPinger
    implements ClientService {
        private final long pingPeriod;
        private final TimeUnit timeUnit;
        private volatile ScheduledExecutorService pinger;

        private HttpConnectionPinger(long l, TimeUnit timeUnit) {
            this.pingPeriod = l;
            this.timeUnit = timeUnit;
        }

        @Override
        public void start() {
            this.pinger = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("CRSHttpConnectionPinger");
                thread.setDaemon(true);
                return thread;
            });
            this.pinger.scheduleAtFixedRate(this::ping, 0L, this.pingPeriod, this.timeUnit);
        }

        @Override
        public void stop(Utils.Deadline deadline) {
            if (this.pinger != null) {
                this.pinger.shutdown();
                try {
                    long l = Math.max(deadline.remainder(TimeUnit.MILLISECONDS), 1L);
                    if (!this.pinger.awaitTermination(l, TimeUnit.MILLISECONDS)) {
                        this.pinger.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logger().error("HTTP connection pinger was interrupted on timeout", new Object[0]);
                    this.pinger.shutdownNow();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ping() {
            long l = Utils.currentTimeCount();
            HttpURLConnection httpURLConnection = null;
            try {
                httpURLConnection = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI);
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(ConnectionManager.this.sslSocketFactoryOne);
                httpURLConnection.setRequestMethod(ConnectionManager.METHOD_OPTIONS);
                httpURLConnection.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(l), (HttpsURLConnection)httpURLConnection);
                int n = httpURLConnection.getResponseCode();
                if (n >= 400 && httpURLConnection.getErrorStream() != null) {
                    this.logger().error("Received bad status code during HTTP connection pinging: code=%s, message=%s", n, httpURLConnection.getResponseMessage());
                    ConnectionManager.this.readStream(httpURLConnection.getErrorStream());
                } else if (httpURLConnection.getInputStream() != null) {
                    ConnectionManager.this.readStreamToArray(httpURLConnection.getInputStream());
                }
            }
            catch (Exception exception) {
                this.logger().error("Error occurred during HTTP connection pinging", exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(l));
            }
        }
    }

    static interface ConnectionListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

