/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import java.util.function.Predicate;

public final class SimpleRegEx
implements Predicate<String> {
    private final String pattern;
    private final String text;
    private final Predicate<String> matcher;

    public SimpleRegEx(String string) throws IllegalArgumentException {
        this.pattern = string;
        if (string.equals("*")) {
            this.text = "";
            this.matcher = this::matchAny;
        } else if (string.startsWith("*")) {
            if (string.endsWith("*")) {
                this.matcher = this::matchContains;
                this.text = string.substring(1, string.length() - 1);
            } else {
                this.matcher = this::matchEndsWith;
                this.text = string.substring(1);
            }
        } else if (string.endsWith("*")) {
            this.matcher = this::matchStartsWith;
            this.text = string.substring(0, string.length() - 1);
        } else {
            this.matcher = this::matchExact;
            this.text = string;
        }
        if (this.text.contains("*")) {
            throw new IllegalArgumentException(SimpleRegEx.errorMessage(string));
        }
    }

    private static String errorMessage(String string) {
        return "Invalid regular expression: " + string;
    }

    @Override
    public boolean test(String string) {
        return string != null && this.matcher.test(string);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean matchesAll() {
        return "*".equals(this.pattern);
    }

    private boolean matchExact(String string) {
        return this.text.equals(string);
    }

    private boolean matchAny(String string) {
        return true;
    }

    private boolean matchStartsWith(String string) {
        return string.startsWith(this.text);
    }

    private boolean matchEndsWith(String string) {
        return string.endsWith(this.text);
    }

    private boolean matchContains(String string) {
        return string.contains(this.text);
    }
}

