/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.json.JSONSerializer;
import com.azul.crs.json.JSONStaticSerializer;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Utils {
    private static final char[] digit = "0123456789abcdef".toCharArray();
    public static final JSONSerializer serializer = new JSONStaticSerializer();
    public static final JSONSerializer prettySerializer = new JSONStaticSerializer(true);
    public static final int BUFFER_SIZE = 8192;
    private static final ThreadLocal<WeakReference<byte[]>> buffers = new ThreadLocal();

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(String string) {
        return UUID.nameUUIDFromBytes(string.getBytes()).toString();
    }

    public static String uuid(Object ... objectArray) {
        return Utils.uuid(Arrays.toString(objectArray));
    }

    public static String lower(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    public static long currentTimeCount() {
        return System.nanoTime();
    }

    public static long nextTimeCount(long l) {
        return System.nanoTime() + l * 1000000L;
    }

    public static String elapsedTimeString(long l) {
        return String.format(" (%,d ms)", Utils.elapsedTimeMillis(l));
    }

    public static long elapsedTimeMillis(long l) {
        return (System.nanoTime() - l + 500000L) / 1000000L;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String encodeToStringOrNull(byte[] byArray, int n, int n2) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[n2 * 2];
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            cArray[(i - n) * 2] = digit[by >>> 4 & 0xF];
            cArray[(i - n) * 2 + 1] = digit[by & 0xF];
        }
        return new String(cArray);
    }

    public static String encodeToStringOrNull(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        return Utils.encodeToStringOrNull(byArray, 0, byArray.length);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray;
        WeakReference<byte[]> weakReference = buffers.get();
        if (weakReference == null || (byArray = (byte[])weakReference.get()) == null) {
            byArray = new byte[8192];
            buffers.set(new WeakReference<byte[]>(byArray));
        }
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static final class Deadline {
        private final long deadline;
        private volatile boolean expired = false;

        private Deadline(long l) {
            this.deadline = l;
        }

        public static Deadline in(long l, TimeUnit timeUnit) {
            if (l < 0L) {
                throw new IllegalArgumentException("Can setup deadline in the future only");
            }
            return new Deadline(System.nanoTime() + timeUnit.toNanos(l));
        }

        public static boolean hasExpired(Deadline deadline) {
            return deadline == null || deadline.remainder(TimeUnit.NANOSECONDS) == 0L;
        }

        public long remainder(TimeUnit timeUnit) {
            if (this.expired) {
                return 0L;
            }
            long l = Math.max(0L, this.deadline - System.nanoTime());
            if (l == 0L) {
                this.expired = true;
                return 0L;
            }
            return timeUnit.convert(l, TimeUnit.NANOSECONDS);
        }
    }

    public static final class CountingOutputStream
    extends FilterOutputStream {
        private final Consumer<Long> onClose;
        private long counter = 0L;

        public CountingOutputStream(OutputStream outputStream, Consumer<Long> consumer) {
            super(outputStream);
            this.onClose = consumer;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.counter += (long)n2;
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.counter;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.onClose.accept(this.counter);
        }
    }
}

