/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.util.logging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.CharBuffer;

public final class VMSupport {
    private static final int CRS_CMD_BUF_SIZE = 1024;
    private static final int CRS_CMD_LEN_SIZE = 4;
    private static final String LEN_FORMAT = "%04d";
    private static final Logger logger = Logger.getLogger(VMSupport.class);
    private final BufferedReader in;
    private final BufferedWriter out;
    private final char[] buffer = new char[1024];
    private final CharBuffer cb = CharBuffer.wrap(this.buffer);

    private VMSupport(InputStream inputStream, OutputStream outputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    static VMSupport init(int n, int n2) throws IOException {
        IOException iOException = null;
        for (int i = 1; i <= 10; ++i) {
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), n);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                VMSupport vMSupport = new VMSupport(inputStream, outputStream);
                vMSupport.send(Integer.toString(n2));
                return vMSupport;
            }
            catch (IOException iOException2) {
                logger.trace("Attempt %d to connect to VM failed (will retry %d more times).", i, 10 - i);
                iOException = iOException2;
                try {
                    Thread.sleep(50 * i);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    iOException = new IOException(interruptedException);
                    logger.trace("VMSupport initialization interrupted", new Object[0]);
                    break;
                }
            }
        }
        throw iOException;
    }

    void disableCRS() {
        this.sendCommand("disableCRS", new String[0]);
    }

    void registerAgent(Class clazz) {
        this.sendCommand("registerAgent", clazz.getCanonicalName());
    }

    void enableEventNotifications(CrsNotificationType crsNotificationType, boolean bl) {
        this.sendCommand("enableEventNotifications", Integer.toString(crsNotificationType.id), bl ? "1" : "0");
    }

    void drainQueues(boolean bl, boolean bl2) {
        this.sendCommand("drainQueues", bl ? "1" : "0", bl2 ? "1" : "0");
    }

    void registerCallback(CrsNotificationType crsNotificationType, Method method) {
        this.sendCommand("registerCallback", Integer.toString(crsNotificationType.id), method.getDeclaringClass().getCanonicalName() + "." + method.getName());
    }

    String[] getVMCRSCapabilities() {
        String string = this.sendCommand("getCapabilities", new String[0]);
        return string.isEmpty() ? null : string.split("[, ]+");
    }

    private synchronized String sendCommand(String string, String ... stringArray) {
        try {
            this.cb.clear();
            this.cb.append(string).append("(");
            if (stringArray.length > 0) {
                this.cb.append(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    this.cb.append(',').append(stringArray[i]);
                }
            }
            this.cb.append(")");
            this.cb.flip();
            return this.send(this.cb);
        }
        catch (IOException iOException) {
            logger.debug("Exception in sendCommand", iOException);
            return "";
        }
    }

    private synchronized String send(CharSequence charSequence) throws IOException {
        String string = String.format(LEN_FORMAT, charSequence.length());
        this.out.append(string);
        this.out.append(charSequence);
        this.out.flush();
        int n = Integer.parseInt(this.read(4).trim());
        return n > 0 ? this.read(n) : "";
    }

    private String read(int n) throws IOException {
        this.cb.clear();
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.in.read(this.cb.array(), n3, n2);
            if (n4 == -1) {
                throw new IOException();
            }
            n2 -= n4;
            n3 += n4;
        }
        return this.cb.subSequence(0, n).toString();
    }

    static enum CrsNotificationType {
        EVENT_TO_JAVA_CALL(-98),
        CRS_MESSAGE_CLASS_LOAD(0),
        CRS_MESSAGE_FIRST_CALL(1),
        CRS_MESSAGE_VM_LOG_ENTRY(2);

        private final int id;

        private CrsNotificationType(int n2) {
            this.id = n2;
        }
    }
}

