/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.models;

import com.azul.crs.client.Utils;
import com.azul.crs.util.logging.Logger;
import java.util.Collection;
import java.util.Iterator;

public abstract class Payload {
    public static String toJsonArray(Collection<? extends Payload> collection) {
        return Utils.serializer.serialize(collection);
    }

    public static Iterator<String> toJsonArrays(final Collection<? extends Payload> collection, final int n) {
        return new Iterator<String>(){
            Iterator<? extends Payload> it;
            StringBuilder current;
            StringBuilder sb;
            {
                this.it = collection.iterator();
                this.current = new StringBuilder();
                this.sb = new StringBuilder().append('[');
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext() || this.current.length() > 0;
            }

            @Override
            public String next() {
                this.sb.setLength(1);
                this.fillNext();
                this.sb.setCharAt(this.sb.length() - 1, ']');
                return this.sb.toString();
            }

            private void fillNext() {
                if (this.current.length() > 0) {
                    this.sb.append((CharSequence)this.current).append(',');
                    this.current.setLength(0);
                }
                if (this.sb.length() < n) {
                    while (this.it.hasNext()) {
                        Payload payload = this.it.next();
                        Utils.serializer.serialize(this.current, (Object)payload);
                        if (this.sb.length() + this.current.length() + 1 >= n) {
                            if (this.current.length() + 2 >= n) {
                                Logger.getLogger(Payload.class).error("Single event must not exceed %d. Current event '%s...' has length %d. The event is skipped.", n, this.current.subSequence(0, Math.min(this.current.length(), 100)).toString(), this.current.length());
                                this.current.setLength(0);
                            }
                            return;
                        }
                        this.sb.append((CharSequence)this.current).append(',');
                        this.current.setLength(0);
                    }
                }
            }
        };
    }

    public String toJson() {
        return Utils.serializer.serialize(this);
    }

    public String toJsonUnchecked() {
        return Utils.prettySerializer.serialize(this);
    }

    public String toString() {
        return this.toJsonUnchecked();
    }
}

