/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class ClassLoadMonitor
implements ClientService {
    private static ClassLoadMonitor instance = new ClassLoadMonitor();
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;
    private long _count;
    private final PrintWriter traceOut;

    private ClassLoadMonitor() {
        PrintWriter printWriter = null;
        if (this.logger().isEnabled(Logger.Level.TRACE)) {
            try {
                Path path = Files.createTempFile("CRSClassLoadMonitor", ".log", new FileAttribute[0]);
                this.logger().trace("writing ClassLoadMonitor trace to file %s", path);
                printWriter = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        this.traceOut = printWriter;
    }

    public static ClassLoadMonitor getInstance(Client client) {
        ClassLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent classLoadEvent(String string, String string2, String string3, int n, int n2, String string4, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("className", string);
        if (string2 != null) {
            hashMap.put("transformedHash", string3);
        }
        hashMap.put("hash", string2 != null ? string2 : string3);
        hashMap.put("classId", Integer.toString(n));
        hashMap.put("loaderId", Integer.toString(n2));
        if (string4 != null) {
            hashMap.put("source", string4);
        }
        return new VMEvent().randomEventId().eventType(VMEvent.Type.VM_CLASS_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.logger().debug("total classes loaded count " + this._count, new Object[0]);
        PerformanceMetrics.logClassLoads(this._count);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
        this.started = false;
        this.stopped = true;
    }

    public void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        ++this._count;
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            Logger.getLogger(ClassLoadMonitor.class).error("service is not yet started", new Object[0]);
        }
        long l = Utils.currentTimeMillis();
        String string3 = Utils.encodeToStringOrNull(byArray);
        String string4 = Utils.encodeToStringOrNull(byArray2);
        this.client.postVMEvent(this.classLoadEvent(string, string3, string4, n, n2, string2, l));
        if (this.traceOut != null) {
            this.traceOut.printf("%s [%d:%d]\n", string, n2, n);
        }
    }
}

