/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.QueueService;
import java.io.IOException;
import java.util.Collection;

public class UploadService
implements ClientService {
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int MAX_WORKERS = 1;
    private static final int BATCH_SIZE = 1;
    private final QueueService<Job> queue = new QueueService.Builder().maxQueueSize(50000).maxBatchSize(1).maxWorkers(1).processBatch(this::send).stopMarker(STOP_MARKER).name("UPLOAD").build();
    private final Client client;
    private static final Job STOP_MARKER = new Job(null, null);

    public UploadService(Client client) {
        this.client = client;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        if (!Utils.Deadline.hasExpired(deadline)) {
            this.logger().info("awaiting artifact data to flush to the cloud", new Object[0]);
            this.queue.stop(deadline);
        } else {
            this.logger().debug("skipping flush of artifact data to the cloud because no time left", new Object[0]);
        }
    }

    public void cancel() {
        this.queue.cancel();
    }

    public void connectionEstablished() {
        this.logger().trace("connection established, sending artifact data to the cloud", new Object[0]);
        this.queue.start();
    }

    public void post(VMArtifactChunk vMArtifactChunk, Client.DataWriter dataWriter) {
        this.queue.add(new Job(vMArtifactChunk, dataWriter));
    }

    public void sync(Utils.Deadline deadline) {
        if (!Utils.Deadline.hasExpired(deadline)) {
            this.logger().trace("syncing artifact data to the cloud", new Object[0]);
            this.queue.sync(deadline);
        } else {
            this.logger().debug("not syncing artifact data to the cloud because no time left", new Object[0]);
        }
    }

    private void send(String string, Collection<Job> collection) {
        Job job = collection.iterator().next();
        VMArtifactChunk vMArtifactChunk = job.chunk;
        Client.DataWriter dataWriter = job.writer;
        try {
            this.logger().trace("Uploading Artifact Chunk: " + vMArtifactChunk, new Object[0]);
            Response<String[]> response = this.client.getConnectionManager().sendVMArtifactChunk(vMArtifactChunk, outputStream -> dataWriter.writeData(new Utils.CountingOutputStream(outputStream, PerformanceMetrics::logArtifactBytes)));
            this.logger().trace("Upload finished " + (response.successful() ? "successfully" : "abnormally"), new Object[0]);
            if (!response.successful()) {
                throw new IOException("Failed to upload Artifact Chunk: " + vMArtifactChunk);
            }
        }
        catch (IOException iOException) {
            this.logger().error("An error occurred while uploading data", iOException);
            dataWriter.handleException(iOException);
        }
    }

    private static class Job {
        private final VMArtifactChunk chunk;
        private final Client.DataWriter writer;

        public Job(VMArtifactChunk vMArtifactChunk, Client.DataWriter dataWriter) {
            this.chunk = vMArtifactChunk;
            this.writer = dataWriter;
        }
    }
}

