/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.runtime.utils;

import com.azul.crs.runtime.utils.PackedDataEntriesMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class DataEntriesMap<T extends Enum> {
    private final DirNode<T> root = new DirNode("");
    private final Class<T> dataKindsEnum;
    private final Enum[] usedKinds;
    private DirNode<T> cache = this.root;

    public DataEntriesMap(Class<T> clazz) {
        this.dataKindsEnum = clazz;
        this.usedKinds = new Enum[((Enum[])clazz.getEnumConstants()).length];
    }

    public void put(String string, T t, String string2) throws IllegalArgumentException {
        this.getEntry(string).put(t, string2);
    }

    public DataEntry getEntry(String string2) throws IllegalArgumentException {
        DirNode<T> dirNode;
        if (string2 == null || string2.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(n + 1, string2.length());
        String string4 = string2.substring(0, n + 1);
        if (((DirNode)this.cache).path.equals(string4)) {
            dirNode = this.cache;
        } else {
            this.cache = dirNode = this.findOrCreateDirNode(this.root, 0, string4);
        }
        return new DataEntry(((DirNode)dirNode).files.computeIfAbsent(string3, string -> new String[((Enum[])this.dataKindsEnum.getEnumConstants()).length]));
    }

    public PackedDataEntriesMap<T> pack() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PEM01" + Arrays.stream(this.usedKinds).filter(Objects::nonNull).map(Enum::name).collect(Collectors.joining(":")));
        this.pack(this.root, arrayList);
        return PackedDataEntriesMap.fromExternalForm(arrayList, this.dataKindsEnum);
    }

    private <T extends Enum> void pack(DirNode<T> dirNode2, List<String> list) {
        if (!((DirNode)dirNode2).path.isEmpty()) {
            list.add(((DirNode)dirNode2).path);
        }
        int n = list.size();
        list.add(((DirNode)dirNode2).files.size() + ":");
        ((DirNode)dirNode2).files.forEach((string, stringArray) -> list.add(string + "|" + this.encode((String[])stringArray)));
        ((DirNode)dirNode2).dirs.forEach(dirNode -> this.pack((DirNode<T>)dirNode, list));
        list.set(n, list.get(n) + (list.size() - n - 1));
    }

    private DirNode<T> findOrCreateDirNode(DirNode<T> dirNode, int n, String string) {
        if (n == string.length()) {
            return dirNode;
        }
        n = string.indexOf(47, n);
        String string2 = string.substring(0, n + 1);
        for (DirNode dirNode2 : ((DirNode)dirNode).dirs) {
            if (!dirNode2.path.equals(string2)) continue;
            return this.findOrCreateDirNode(dirNode2, n + 1, string);
        }
        DirNode dirNode3 = new DirNode(string2);
        ((DirNode)dirNode).dirs.add(dirNode3);
        return this.findOrCreateDirNode(dirNode3, n + 1, string);
    }

    private String encode(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Enum enum_ : this.usedKinds) {
            if (enum_ == null) continue;
            String string = stringArray[enum_.ordinal()];
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(':');
        }
        int n = stringBuilder.length();
        while (stringBuilder.charAt(--n) == ':') {
            stringBuilder.setLength(n);
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return ((DirNode)this.root).dirs.isEmpty() && ((DirNode)this.root).files.isEmpty();
    }

    public final class DataEntry<T extends Enum> {
        private final String[] data;

        private DataEntry(String[] stringArray) {
            this.data = stringArray;
        }

        public boolean isEmpty() {
            if (this.data != null) {
                for (String string : this.data) {
                    if (string == null) continue;
                    return false;
                }
            }
            return true;
        }

        public void put(T t, String string) {
            int n = ((Enum)t).ordinal();
            if (DataEntriesMap.this.usedKinds[n] == null) {
                ((DataEntriesMap)DataEntriesMap.this).usedKinds[n] = t;
            }
            this.data[n] = string;
        }
    }

    private static class DirNode<T extends Enum>
    implements Comparable<DirNode> {
        private final String path;
        private final TreeMap<String, String[]> files = new TreeMap();
        private final TreeSet<DirNode<T>> dirs = new TreeSet();

        private DirNode(String string) {
            this.path = string;
        }

        @Override
        public int compareTo(DirNode dirNode) {
            return this.path.compareTo(dirNode.path);
        }
    }
}

