/*
 * Decompiled with CFR 0.152.
 */
package de.mpicbg.imagej;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLStructure;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgs;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class Open_MAT
implements PlugIn {
    public void run(String s) {
        String filename = IJ.getFilePath((String)"MAT file loader");
        if (filename.length() > 0) {
            Open_MAT.read(filename);
        }
    }

    public static void read(String filename) {
        MatFileReader mfr = new MatFileReader();
        try {
            mfr.read(new File(filename));
            MLArray content = (MLArray)mfr.getContent().get("IM_dat");
            Open_MAT.parseArray(content, filename + " > ", "IM_dat");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parseArray(MLArray content, String parent, String name) {
        MLDouble doubl;
        RandomAccessibleInterval img;
        if (content instanceof MLStructure) {
            MLStructure structure = (MLStructure)content;
            for (String key : structure.getFieldNames()) {
                MLArray array = structure.getField(key);
                Open_MAT.parseArray(array, parent + "." + name, key);
            }
        } else if (content instanceof MLDouble && (img = Open_MAT.parseImage(doubl = (MLDouble)content)) != null) {
            RandomAccessibleInterval view = img;
            long[] dims = new long[img.numDimensions()];
            img.dimensions(dims);
            System.out.println("dim before: " + Arrays.toString(dims));
            view = Views.moveAxis(view, (int)0, (int)2);
            view.dimensions(dims);
            System.out.println("dim after: " + Arrays.toString(dims));
            ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)view, (String)(parent + "." + name));
            imp = new Duplicator().run(imp, 1, imp.getNChannels(), 1, imp.getNSlices(), 1, imp.getNFrames());
            imp.show();
            IJ.run((ImagePlus)imp, (String)"Enhance Contrast", (String)"saturated=0.35");
        }
    }

    private static Img<FloatType> parseImage(MLDouble doubl) {
        long[] dimensions = new long[doubl.getDimensions().length];
        for (int d = 0; d < dimensions.length; ++d) {
            dimensions[d] = doubl.getDimensions()[dimensions.length - 1 - d];
        }
        if (dimensions.length > 0 && dimensions[0] > 1L) {
            PlanarImg img = PlanarImgs.floats((long[])dimensions);
            Open_MAT.copyImage((Img<FloatType>)img, doubl, 0, dimensions, new long[0]);
            return img;
        }
        return null;
    }

    private static int copyImage(Img<FloatType> img, MLDouble doubl, int offset, long[] dimensions, long[] position) {
        if (dimensions.length > 1) {
            long[] subdimensions = new long[dimensions.length - 1];
            System.arraycopy(dimensions, 1, subdimensions, 0, subdimensions.length);
            long[] subposition = new long[position.length + 1];
            if (position.length > 0) {
                System.arraycopy(position, 0, subposition, 0, position.length);
            }
            long d = 0L;
            while (d < dimensions[0]) {
                subposition[subposition.length - 1] = d++;
                offset = Open_MAT.copyImage(img, doubl, offset, subdimensions, subposition);
            }
        } else {
            long[] subposition = new long[position.length + 1];
            if (position.length > 0) {
                System.arraycopy(position, 0, subposition, 0, position.length);
            }
            RandomAccess ra = img.randomAccess();
            long d = 0L;
            while (d < dimensions[0]) {
                subposition[subposition.length - 1] = d++;
                ra.setPosition(subposition);
                ((FloatType)ra.get()).set(((Double)doubl.get(offset)).floatValue());
                ++offset;
            }
        }
        return offset;
    }

    public static void main(String[] args) {
        new ImageJ();
        Open_MAT.read("C:/structure/data/test.mat");
    }
}

