/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.process.FloatPolygon;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class RoiProperties
implements TextListener,
WindowListener {
    private ImagePlus imp;
    private Roi roi;
    private Overlay overlay;
    private String title;
    private boolean showName = true;
    private boolean showListCoordinates;
    private boolean addToOverlay;
    private boolean overlayOptions;
    private boolean setPositions;
    private boolean listCoordinates;
    private boolean listProperties;
    private boolean showPointCounts;
    private static final String[] justNames = new String[]{"Left", "Center", "Right"};
    private int nProperties;
    private TextField groupField;
    private TextField colorField;
    private Label groupName;

    public RoiProperties(String title, ImagePlus imp, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = title;
        this.imp = imp;
        this.roi = roi;
        this.showName = title.startsWith("Prop");
        this.showListCoordinates = this.showName && title.endsWith(" ");
        this.nProperties = this.showListCoordinates ? roi.getPropertyCount() : 0;
        this.addToOverlay = title.equals("Add to Overlay");
        this.overlayOptions = title.equals("Overlay Options");
        if (this.overlayOptions) {
            imp = WindowManager.getCurrentImage();
            this.overlay = imp != null ? imp.getOverlay() : null;
            this.setPositions = roi.getPosition() != 0;
        }
    }

    public RoiProperties(String title, Roi roi) {
        this(title, WindowManager.getCurrentImage(), roi);
    }

    public boolean showDialog() {
        boolean newOverlay;
        boolean askShowOnAllSlices;
        double strokeWidth;
        String nameLabel;
        String name = this.roi.getName();
        boolean isRange = name != null && name.startsWith("range:");
        String string = nameLabel = isRange ? "Range:" : "Name:";
        if (isRange) {
            name = name.substring(7);
        }
        if (name == null) {
            name = "";
        }
        if (!isRange && this.roi instanceof ImageRoi && !this.overlayOptions) {
            return this.showImageDialog(name);
        }
        Color strokeColor = this.roi.getStrokeColor();
        Color fillColor = this.roi.getFillColor();
        double strokeWidth2 = strokeWidth = (double)this.roi.getStrokeWidth();
        boolean isText = this.roi instanceof TextRoi;
        boolean isLine = this.roi.isLine();
        boolean isPoint = this.roi instanceof PointRoi;
        int justification = 0;
        double angle = 0.0;
        boolean antialias = true;
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            strokeWidth = font.getSize();
            angle = troi.getAngle();
            justification = troi.getJustification();
            antialias = troi.getAntiAlias();
        }
        String position = this.roi.getPositionAsString();
        String group = "" + this.roi.getGroup();
        if (group.equals("0")) {
            group = "none";
        }
        String linec = Colors.colorToString(strokeColor);
        String fillc = Colors.colorToString(fillColor);
        if (IJ.isMacro()) {
            fillc = "none";
            this.setPositions = false;
        }
        int digits = (double)((int)strokeWidth) == strokeWidth ? 0 : 1;
        GenericDialog gd = new GenericDialog(this.title);
        if (this.showName) {
            gd.addStringField(nameLabel, name, 20);
            String label = "Position:";
            if (position.contains(",") || this.imp != null && this.imp.isHyperStack()) {
                label = "Position (c,z,t):";
            }
            gd.addStringField(label, position, 20);
            gd.addStringField("Group:", group);
            gd.addToSameRow();
            gd.addMessage("wwwwwwwwwwww");
        }
        if (isText) {
            gd.addStringField("Stroke color:", linec);
            gd.addNumericField("Font size:", strokeWidth, digits, 4, "points");
            digits = (double)((int)angle) == angle ? 0 : 1;
            gd.addNumericField("Angle:", angle, digits, 4, "degrees");
            gd.setInsets(0, 0, 0);
            gd.addChoice("Justification:", justNames, justNames[justification]);
        } else if (isPoint) {
            gd.addStringField("Stroke (point) color:", linec);
        } else {
            gd.addStringField("Stroke color:", linec);
            gd.addNumericField("Width:", strokeWidth, digits);
        }
        this.groupName = (Label)gd.getMessage();
        if (this.showName && !IJ.isMacro()) {
            Vector v = gd.getStringFields();
            this.groupField = (TextField)v.elementAt(v.size() - 2);
            this.groupField.addTextListener(this);
            this.colorField = (TextField)v.elementAt(v.size() - 1);
        }
        if (!isLine) {
            if (isPoint) {
                int index = ((PointRoi)this.roi).getPointType();
                gd.addChoice("Point type:", PointRoi.types, PointRoi.types[index]);
                index = ((PointRoi)this.roi).getSize();
                gd.addChoice("Size:", PointRoi.sizes, PointRoi.sizes[index]);
            } else {
                gd.addMessage("");
                gd.addStringField("Fill color:", fillc);
            }
        }
        boolean bl = askShowOnAllSlices = this.addToOverlay && this.imp != null && this.imp.getNSlices() > 1;
        if (askShowOnAllSlices) {
            gd.addCheckbox("Show on all Slices", this.roi.getPosition() == 0 && !this.roi.hasHyperStackPosition());
        }
        if (this.addToOverlay) {
            gd.addCheckbox("New overlay", false);
        }
        if (this.overlayOptions) {
            gd.addCheckbox("Set stack positions", this.setPositions);
            if (this.overlay != null) {
                int size = this.overlay.size();
                gd.setInsets(15, 20, 0);
                if (this.imp != null && this.imp.getHideOverlay()) {
                    gd.addMessage("Current overlay is hidden", null, Color.darkGray);
                } else {
                    gd.addMessage("Current overlay has " + size + " element" + (size > 1 ? "s" : ""), null, Color.darkGray);
                }
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Apply", false);
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Show labels", this.overlay.getDrawLabels());
                gd.setInsets(0, 30, 0);
                gd.addCheckbox("Hide", this.imp != null ? this.imp.getHideOverlay() : false);
            } else {
                gd.addMessage("No overlay", null, Color.darkGray);
            }
        }
        if (isText) {
            gd.addCheckbox("Antialiased text", antialias);
        }
        if (this.showListCoordinates) {
            if (this.roi instanceof PointRoi && Toolbar.getMultiPointMode()) {
                this.showPointCounts = true;
            }
            if (this.showPointCounts) {
                gd.addCheckbox("Show point counts (shortcut: alt+y)", this.listCoordinates);
            } else {
                gd.addCheckbox("List coordinates (" + this.roi.size() + ")", this.listCoordinates);
            }
            if (this.nProperties > 0) {
                gd.addCheckbox("List properties (" + this.nProperties + ")", this.listProperties);
            } else {
                gd.setInsets(5, 20, 0);
                gd.addMessage("No properties");
            }
        }
        if (isText && !isRange) {
            String text = ((TextRoi)this.roi).getText();
            int nLines = Tools.split(text, "\n").length + 1;
            gd.addTextAreas(text, null, Math.min(nLines + 1, 5), 30);
        }
        if (this.showName && "".equals(name) && "none".equals(position) && "none".equals(group) && "none".equals(fillc)) {
            gd.setSmartRecording(true);
        }
        gd.addWindowListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String position2 = "";
        String group2 = "";
        if (this.showName) {
            name = gd.getNextString();
            if (!isRange) {
                this.roi.setName(name.length() > 0 ? name : null);
            }
            position2 = gd.getNextString();
            group2 = gd.getNextString();
        }
        linec = gd.getNextString();
        if (!isPoint) {
            strokeWidth2 = gd.getNextNumber();
        }
        if (isText) {
            angle = gd.getNextNumber();
            justification = gd.getNextChoiceIndex();
        }
        if (!isLine) {
            if (isPoint) {
                int index = gd.getNextChoiceIndex();
                ((PointRoi)this.roi).setPointType(index);
                index = gd.getNextChoiceIndex();
                ((PointRoi)this.roi).setSize(index);
            } else {
                fillc = gd.getNextString();
            }
        }
        if (askShowOnAllSlices) {
            boolean overlayOnAllSlices = gd.getNextBoolean();
            if (overlayOnAllSlices) {
                this.roi.setPosition(0);
            } else if (this.roi.getPosition() == 0) {
                this.roi.setPosition(this.imp);
            }
        }
        boolean applyToOverlay = false;
        boolean bl2 = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (this.overlayOptions) {
            this.setPositions = gd.getNextBoolean();
            if (this.overlay != null) {
                applyToOverlay = gd.getNextBoolean();
                boolean labels = gd.getNextBoolean();
                boolean hideOverlay = gd.getNextBoolean();
                if (hideOverlay && this.imp != null) {
                    if (!this.imp.getHideOverlay()) {
                        this.imp.setHideOverlay(true);
                    }
                } else {
                    this.overlay.drawLabels(labels);
                    Analyzer.drawLabels(labels);
                    this.overlay.drawBackgrounds(true);
                    if (this.imp.getHideOverlay()) {
                        this.imp.setHideOverlay(false);
                    }
                    if (!applyToOverlay && this.imp != null) {
                        this.imp.draw();
                    }
                }
            }
            this.roi.setPosition(this.setPositions ? 1 : 0);
        }
        if (isText) {
            antialias = gd.getNextBoolean();
        }
        if (this.showListCoordinates) {
            this.listCoordinates = gd.getNextBoolean();
            if (this.nProperties > 0) {
                this.listProperties = gd.getNextBoolean();
            }
        }
        strokeColor = Colors.decode(linec, null);
        fillColor = Colors.decode(fillc, null);
        if (isText) {
            TextRoi troi = (TextRoi)this.roi;
            Font font = troi.getCurrentFont();
            if (strokeWidth2 != strokeWidth) {
                font = new Font(font.getName(), font.getStyle(), (int)strokeWidth2);
                troi.setCurrentFont(font);
            }
            troi.setAngle(angle);
            if (justification != troi.getJustification()) {
                troi.setJustification(justification);
            }
            troi.setAntiAlias(antialias);
            if (!isRange) {
                troi.setText(gd.getNextText());
            }
        } else if (strokeWidth2 != strokeWidth) {
            this.roi.setStrokeWidth((float)strokeWidth2);
        }
        this.roi.setFillColor(fillColor);
        this.roi.setStrokeColor(strokeColor);
        if (this.showName) {
            this.setPosition(this.roi, position, position2);
            this.setGroup(this.roi, group, group2);
        }
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        if (applyToOverlay) {
            if (this.imp == null || this.overlay == null) {
                return true;
            }
            Undo.setup(10, this.imp);
            Roi[] rois = this.overlay.toArray();
            for (int i = 0; i < rois.length; ++i) {
                if (strokeColor != null) {
                    rois[i].setStrokeColor(strokeColor);
                }
                if (strokeWidth2 != strokeWidth) {
                    rois[i].setStrokeWidth((float)strokeWidth2);
                }
                rois[i].setFillColor(fillColor);
                if (this.setPositions) {
                    if (rois[i].getPosition() != 0 || rois[i].hasHyperStackPosition()) continue;
                    rois[i].setPosition(this.imp);
                    continue;
                }
                rois[i].setPosition(0);
            }
            this.imp.draw();
            this.imp.getProcessor();
        }
        if (this.listCoordinates) {
            if (this.showPointCounts && this.roi instanceof PointRoi) {
                ((PointRoi)this.roi).displayCounts();
            } else {
                this.listCoordinates(this.roi);
            }
        }
        if (this.listProperties && this.nProperties > 0) {
            this.listProperties(this.roi);
        }
        return true;
    }

    private void setPosition(Roi roi, String pos1, String pos2) {
        if (pos1.equals(pos2)) {
            return;
        }
        if (pos2.equals("none") || pos2.equals("0")) {
            roi.setPosition(0);
            return;
        }
        String[] positions = Tools.split(pos2, " ,");
        if (positions.length == 1) {
            double stackPos = Tools.parseDouble(positions[0]);
            if (!Double.isNaN(stackPos)) {
                roi.setPosition((int)stackPos);
            }
            return;
        }
        if (positions.length == 3) {
            int[] pos = new int[3];
            for (int i = 0; i < 3; ++i) {
                double dpos = Tools.parseDouble(positions[i]);
                if (Double.isNaN(dpos)) {
                    return;
                }
                pos[i] = (int)dpos;
            }
            roi.setPosition(pos[0], pos[1], pos[2]);
            return;
        }
    }

    private void setGroup(Roi roi, String group1, String group2) {
        if (group1.equals(group2)) {
            return;
        }
        if (group2.equals("none") || group2.equals("0")) {
            roi.setGroup(0);
            return;
        }
        double group = Tools.parseDouble(group2);
        if (!Double.isNaN(group)) {
            roi.setGroup((int)group);
        }
    }

    public boolean showImageDialog(String name) {
        boolean newOverlay;
        ImageRoi iRoi = (ImageRoi)this.roi;
        boolean zeroTransparent = iRoi.getZeroTransparent();
        GenericDialog gd = new GenericDialog("Image ROI Properties");
        gd.addStringField("Name:", name, 15);
        gd.addNumericField("Opacity (0-100%):", iRoi.getOpacity() * 100.0, 0);
        gd.addCheckbox("Transparent background", zeroTransparent);
        if (this.addToOverlay) {
            gd.addCheckbox("New Overlay", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        this.roi.setName(name.length() > 0 ? name : null);
        double opacity = gd.getNextNumber() / 100.0;
        iRoi.setOpacity(opacity);
        boolean zeroTransparent2 = gd.getNextBoolean();
        if (zeroTransparent != zeroTransparent2) {
            iRoi.setZeroTransparent(zeroTransparent2);
        }
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        return true;
    }

    void listCoordinates(Roi roi) {
        if (roi == null) {
            return;
        }
        boolean allIntegers = true;
        FloatPolygon fp = roi.getFloatPolygon();
        ImagePlus imp = roi.getImage();
        String title = "Coordinates";
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            int height = imp.getHeight();
            for (int i = 0; i < fp.npoints; ++i) {
                fp.xpoints[i] = (float)cal.getX(fp.xpoints[i]);
                fp.ypoints[i] = (float)cal.getY(fp.ypoints[i], height);
            }
            if (cal.pixelWidth != 1.0 || cal.pixelHeight != 1.0) {
                allIntegers = false;
            }
            title = imp.getTitle();
        }
        if (allIntegers) {
            for (int i = 0; i < fp.npoints; ++i) {
                if ((float)((int)fp.xpoints[i]) == fp.xpoints[i] && (float)((int)fp.ypoints[i]) == fp.ypoints[i]) continue;
                allIntegers = false;
                break;
            }
        }
        ResultsTable rt = new ResultsTable();
        rt.setPrecision(allIntegers ? 0 : Analyzer.getPrecision());
        for (int i = 0; i < fp.npoints; ++i) {
            rt.incrementCounter();
            rt.addValue("X", (double)fp.xpoints[i]);
            rt.addValue("Y", (double)fp.ypoints[i]);
        }
        rt.show("XY_" + title);
    }

    void listProperties(Roi roi) {
        String props = roi.getProperties();
        if (props == null) {
            return;
        }
        props = props.replaceAll(": ", "\t");
        new TextWindow("Properties", "Key\tValue", props, 300, 300);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        if (this.groupName == null) {
            return;
        }
        TextField tf = (TextField)e.getSource();
        String str = tf.getText();
        double group = Tools.parseDouble(str, Double.NaN);
        if (!Double.isNaN(group) && group >= 0.0 && group <= 255.0) {
            this.roi.setGroup((int)group);
            String name = Roi.getGroupName((int)group);
            if (name == null) {
                name = "unnamed";
            }
            if (group == 0.0) {
                name = "";
            }
            this.groupName.setText(" " + name);
            Color strokeColor = this.roi.getStrokeColor();
            this.colorField.setText(Colors.colorToString(strokeColor));
        } else {
            this.groupName.setText("");
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (this.groupName != null) {
            String gname = Roi.getGroupName(this.roi.getGroup());
            this.groupName.setText(gname != null ? " " + gname : "");
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

