/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.StackProcessor;
import ij.util.ThreadUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class Filters3D
implements PlugIn {
    public static final int MEAN = 10;
    public static final int MEDIAN = 11;
    public static final int MIN = 12;
    public static final int MAX = 13;
    public static final int VAR = 14;
    public static final int MAXLOCAL = 15;
    private static float xradius = 2.0f;
    private static float yradius = 2.0f;
    private static float zradius = 2.0f;
    private static boolean doAllFrms = true;
    private static boolean doAllChs = true;

    @Override
    public void run(String arg) {
        String name = null;
        int filter = 0;
        if (arg.equals("mean")) {
            name = "3D Mean";
            filter = 10;
        } else if (arg.equals("median")) {
            name = "3D Median";
            filter = 11;
        } else if (arg.equals("min")) {
            name = "3D Minimum";
            filter = 12;
        } else if (arg.equals("max")) {
            name = "3D Maximum";
            filter = 13;
        } else if (arg.equals("var")) {
            name = "3D Variance";
            filter = 14;
        } else {
            return;
        }
        ImagePlus imp = IJ.getImage();
        if (imp.isComposite() && imp.getNChannels() == imp.getStackSize()) {
            IJ.error(name, "Composite color images not supported");
            return;
        }
        if (!this.showDialog(name)) {
            return;
        }
        imp.startTiming();
        this.run(imp, filter, xradius, yradius, zradius);
        int nProcessedSlices = imp.getStackSize();
        if (!doAllChs) {
            nProcessedSlices /= imp.getNChannels();
        }
        if (!doAllFrms) {
            nProcessedSlices /= imp.getNFrames();
        }
        IJ.showTime(imp, imp.getStartTime(), "", nProcessedSlices);
    }

    private boolean showDialog(String name) {
        ImagePlus imp = IJ.getImage();
        GenericDialog gd = new GenericDialog(name);
        gd.addNumericField("X radius:", xradius, 1);
        gd.addNumericField("Y radius:", yradius, 1);
        gd.addNumericField("Z radius:", zradius, 1);
        if (imp.getNChannels() > 1) {
            gd.addCheckbox("SingleChannel (current channel only)", !doAllChs);
        }
        if (imp.getNFrames() > 1) {
            gd.addCheckbox("SingleFrame (current frame only)", !doAllFrms);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xradius = (float)gd.getNextNumber();
        yradius = (float)gd.getNextNumber();
        zradius = (float)gd.getNextNumber();
        if (imp.getNChannels() > 1) {
            boolean bl = doAllChs = !gd.getNextBoolean();
        }
        if (imp.getNFrames() > 1) {
            doAllFrms = !gd.getNextBoolean();
        }
        return true;
    }

    private void run(ImagePlus imp, int filter, float radX, float radY, float radZ) {
        int cmax = imp.getC();
        int cmin = cmax - 1;
        int tmax = imp.getT();
        int tmin = tmax - 1;
        int nZSlices = imp.getNSlices();
        if (doAllChs) {
            cmin = 0;
            cmax = imp.getNChannels();
        }
        if (doAllFrms) {
            tmin = 0;
            tmax = imp.getNFrames();
        }
        if (imp.getStackSize() == imp.getNFrames()) {
            nZSlices = imp.getNFrames();
        }
        ImageStack res = Filters3D.filter(imp.getStack(), filter, radX, radY, radZ, imp.getNChannels(), nZSlices, cmin, cmax, tmin, tmax);
        imp.setStack(res);
    }

    public static ImageStack filter(ImageStack stackorig, int filter, float vx, float vy, float vz) {
        return Filters3D.filter(stackorig, filter, vx, vy, vz, 1, stackorig.size(), 0, 1, 0, 1);
    }

    public static ImageStack filter(final ImageStack stack, final int filter, final float vx, final float vy, final float vz, final int nChs, int numberOfZSlices, int cmin, int cmax, int tmin, int tmax) {
        if (stack.getBitDepth() == 24) {
            return Filters3D.filterRGB(stack, filter, vx, vy, vz, numberOfZSlices, tmin, tmax);
        }
        int width = stack.getWidth();
        int height = stack.getHeight();
        int depth = stack.size();
        if (numberOfZSlices > depth) {
            numberOfZSlices = depth;
        }
        final int nZSlices = numberOfZSlices;
        if (cmin < 0) {
            cmin = 0;
        }
        if (tmin < 0) {
            tmin = 0;
        }
        if (cmax < nChs) {
            cmax = nChs;
        }
        if (tmax > depth / nChs / nZSlices) {
            tmax = depth / nChs / nZSlices;
        }
        ImageStack res = null;
        if (filter == 10 || filter == 11 || filter == 12 || filter == 13 || filter == 14) {
            res = filter == 14 ? ImageStack.create(width, height, depth, 32) : ImageStack.create(width, height, depth, stack.getBitDepth());
            IJ.showStatus("3D filtering...");
            final ImageStack out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = Prefs.getThreads();
            final int dec = (int)Math.ceil((double)stack.size() / (double)n_cpus);
            for (int fr = 0; fr < depth / nZSlices / nChs; ++fr) {
                for (int ch = 0; ch < nChs; ++ch) {
                    if (fr >= tmin && fr < tmax && ch >= cmin && ch < cmax) {
                        final int chf = ch;
                        final int frf = fr;
                        ai.set(0);
                        Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
                        for (int ithread = 0; ithread < threads.length; ++ithread) {
                            threads[ithread] = new Thread(){

                                @Override
                                public void run() {
                                    StackProcessor processor = new StackProcessor(stack);
                                    int k = ai.getAndIncrement();
                                    while (k < n_cpus) {
                                        processor.filter3D(out, nChs, nZSlices, vx, vy, vz, chf, chf + 1, dec * k, dec * (k + 1), frf, frf + 1, filter);
                                        k = ai.getAndIncrement();
                                    }
                                }
                            };
                        }
                        ThreadUtil.startAndJoin(threads);
                        continue;
                    }
                    for (int sl = 0; sl < nZSlices; ++sl) {
                        int index = 1 + ch + nChs * sl + nChs * nZSlices * fr;
                        out.setProcessor(stack.getProcessor(index), index);
                        out.setSliceLabel(stack.getSliceLabel(index), index);
                    }
                }
            }
        }
        return res;
    }

    private static ImageStack filterRGB(ImageStack rgb_in, int filter, float vx, float vy, float vz, int nZSlices, int tmin, int tmax) {
        ImageStack[] channels = ChannelSplitter.splitRGB(rgb_in, false);
        ImageStack red = Filters3D.filter(channels[0], filter, vx, vy, vz, 1, nZSlices, 0, 1, tmin, tmax);
        ImageStack green = Filters3D.filter(channels[1], filter, vx, vy, vz, 1, nZSlices, 0, 1, tmin, tmax);
        ImageStack blue = Filters3D.filter(channels[2], filter, vx, vy, vz, 1, nZSlices, 0, 1, tmin, tmax);
        return RGBStackMerge.mergeStacks(red, green, blue, false);
    }
}

