/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.StackWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.CompositeConverter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextListener;

public class HyperStackConverter
implements PlugIn {
    public static final int CZT = 0;
    public static final int CTZ = 1;
    public static final int ZCT = 2;
    public static final int ZTC = 3;
    public static final int TCZ = 4;
    public static final int TZC = 5;
    static final int C = 0;
    static final int Z = 1;
    static final int T = 2;
    static final String[] orders = new String[]{"xyczt(default)", "xyctz", "xyzct", "xyztc", "xytcz", "xytzc"};
    static int ordering = 0;
    static boolean splitRGB = true;
    static final String[] DIMENSION_LABELS = new String[]{"Channels (c):", "Slices (z):", "Frames (t):"};
    static final int MAX_DIMENSIONS = DIMENSION_LABELS.length;
    static int lastAutoCbxIndex = -1;

    @Override
    public void run(String arg) {
        if (arg.equals("new")) {
            this.newHyperStack();
            return;
        }
        ImagePlus imp = IJ.getImage();
        if (arg.equals("stacktohs")) {
            this.convertStackToHS(imp);
        } else if (arg.equals("hstostack")) {
            this.convertHSToStack(imp);
        }
    }

    public static ImagePlus toHyperStack(ImagePlus imp, int c, int z, int t) {
        return HyperStackConverter.toHyperStack(imp, c, z, t, null, null);
    }

    public static ImagePlus toHyperStack(ImagePlus imp, int c, int z, int t, String mode) {
        return HyperStackConverter.toHyperStack(imp, c, z, t, null, mode);
    }

    public static ImagePlus toHyperStack(ImagePlus imp, int c, int z, int t, String order, String mode) {
        int n = imp.getStackSize();
        if (n == 1) {
            throw new IllegalArgumentException("Stack required");
        }
        if (imp.getBitDepth() == 24 && mode.equalsIgnoreCase("composite")) {
            mode = "color";
        }
        if (c * z * t != n) {
            throw new IllegalArgumentException("C*Z*T not equal stack size");
        }
        imp.setDimensions(c, z, t);
        if (order == null || order.equals("default") || order.equals("xyczt")) {
            order = orders[0];
        }
        int intOrder = 0;
        for (int i = 0; i < orders.length; ++i) {
            if (!order.equals(orders[i])) continue;
            intOrder = i;
            break;
        }
        if (intOrder != 0 && imp.getStack().isVirtual()) {
            HyperStackConverter.reorderVirtualStack(imp, intOrder);
        } else {
            new HyperStackConverter().shuffle(imp, intOrder);
        }
        ImagePlus imp2 = imp;
        int intMode = 1;
        if (mode != null) {
            if (mode.equalsIgnoreCase("color")) {
                intMode = 2;
            } else if (mode.equalsIgnoreCase("grayscale")) {
                intMode = 3;
            }
        }
        if (c > 1) {
            LUT[] luts = imp.getLuts();
            if (luts != null && luts.length < c) {
                luts = null;
            }
            imp2 = new CompositeImage(imp, intMode);
            if (luts != null) {
                ((CompositeImage)imp2).setLuts(luts);
            }
        }
        imp2.setOpenAsHyperStack(true);
        imp2.setOverlay(imp.getOverlay());
        return imp2;
    }

    public static void toStack(ImagePlus imp) {
        if (imp.isHyperStack() || imp.isComposite()) {
            imp.setDimensions(1, imp.getStackSize(), 1);
            imp.draw();
        }
    }

    private static void reorderVirtualStack(ImagePlus imp, int order) {
        if (!(imp.getStack() instanceof VirtualStack)) {
            return;
        }
        int[] indexes = HyperStackConverter.shuffleVirtual(imp, order);
        VirtualStack vstack = (VirtualStack)imp.getStack();
        vstack.setIndexes(indexes);
    }

    private static int[] shuffleVirtual(ImagePlus imp, int order) {
        int n = imp.getStackSize();
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        int first = 0;
        int middle = 1;
        int last = 2;
        int nFirst = nChannels;
        int nMiddle = nSlices;
        int nLast = nFrames;
        switch (order) {
            case 1: {
                first = 0;
                middle = 2;
                last = 1;
                nFirst = nChannels;
                nMiddle = nFrames;
                nLast = nSlices;
                break;
            }
            case 2: {
                first = 1;
                middle = 0;
                last = 2;
                nFirst = nSlices;
                nMiddle = nChannels;
                nLast = nFrames;
                break;
            }
            case 3: {
                first = 1;
                middle = 2;
                last = 0;
                nFirst = nSlices;
                nMiddle = nFrames;
                nLast = nChannels;
                break;
            }
            case 4: {
                first = 2;
                middle = 0;
                last = 1;
                nFirst = nFrames;
                nMiddle = nChannels;
                nLast = nSlices;
                break;
            }
            case 5: {
                first = 2;
                middle = 1;
                last = 0;
                nFirst = nFrames;
                nMiddle = nSlices;
                nLast = nChannels;
            }
        }
        int[] indexes1 = new int[n];
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes1[i] = i;
            indexes2[i] = i;
        }
        int[] index = new int[3];
        index[2] = 0;
        while (index[2] < nFrames) {
            index[1] = 0;
            while (index[1] < nSlices) {
                index[0] = 0;
                while (index[0] < nChannels) {
                    int dstIndex = index[0] + index[1] * nChannels + index[2] * nChannels * nSlices;
                    int srcIndex = index[first] + index[middle] * nFirst + index[last] * nFirst * nMiddle;
                    indexes1[dstIndex] = indexes2[srcIndex];
                    index[0] = index[0] + 1;
                }
                index[1] = index[1] + 1;
            }
            index[2] = index[2] + 1;
        }
        return indexes1;
    }

    void convertStackToHS(ImagePlus imp) {
        final int stackSize = imp.getImageStackSize();
        boolean rgb = imp.getBitDepth() == 24;
        int[] dimensions = new int[]{imp.getNChannels(), imp.getNSlices(), imp.getNFrames()};
        if (stackSize == 1) {
            IJ.error("Stack to HyperStack", "Stack required");
            return;
        }
        String[] modes = new String[]{"Composite", "Color", "Grayscale"};
        final Checkbox[] autoCbxs = new Checkbox[MAX_DIMENSIONS];
        final GenericDialog gd = new GenericDialog("Convert to HyperStack");
        gd.addChoice("Order:", orders, orders[ordering]);
        for (int i = 0; i < MAX_DIMENSIONS; ++i) {
            Checkbox[] cb;
            gd.addNumericField(DIMENSION_LABELS[i], dimensions[i], 0);
            if (rgb && i == 0) {
                gd.getLabel().setVisible(false);
            }
            if (GraphicsEnvironment.isHeadless()) continue;
            autoCbxs[i] = cb = new Checkbox("auto", i == lastAutoCbxIndex);
            Panel panel = new Panel();
            panel.add((Component)cb);
            gd.addToSameRow();
            gd.addPanel(panel);
        }
        gd.addChoice("Display Mode:", modes, modes[2]);
        if (rgb) {
            gd.setInsets(15, 0, 0);
            gd.addCheckbox("Convert RGB to 3 Channel Hyperstack", splitRGB);
            autoCbxs[0].setVisible(false);
            autoCbxs[0].setState(false);
            ((TextField)gd.getNumericFields().elementAt(0)).setVisible(false);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            final DialogListener dialogListener = new DialogListener(){

                @Override
                public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
                    int numFieldIndex;
                    gd.resetCounters();
                    int autoCbxIndex = -1;
                    for (int i = 0; i < MAX_DIMENSIONS; ++i) {
                        if (!autoCbxs[i].getState()) continue;
                        autoCbxIndex = i;
                        break;
                    }
                    int n = numFieldIndex = e == null ? -1 : gd.getNumericFields().indexOf(e.getSource());
                    if (numFieldIndex >= 0 && numFieldIndex == autoCbxIndex) {
                        autoCbxs[autoCbxIndex].setState(false);
                        autoCbxIndex = -1;
                    }
                    double sizeProduct = 1.0;
                    for (int i = 0; i < MAX_DIMENSIONS; ++i) {
                        double num = gd.getNextNumber();
                        if (i == autoCbxIndex) continue;
                        if (!(num > 0.0) || num != (double)((int)num)) {
                            IJ.showStatus(DIMENSION_LABELS[i] + " Invalid");
                            return false;
                        }
                        sizeProduct *= num;
                    }
                    if (autoCbxIndex >= 0) {
                        TextListener[] listeners;
                        double autoValue = (double)stackSize / sizeProduct;
                        boolean autoOk = autoValue == (double)((int)autoValue);
                        String autoFieldText = autoOk ? Integer.toString((int)autoValue) : "invalid";
                        final TextField autoField = (TextField)gd.getNumericFields().elementAt(autoCbxIndex);
                        for (TextListener l : listeners = autoField.getTextListeners()) {
                            autoField.removeTextListener(l);
                        }
                        autoField.setText(autoFieldText);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (TextListener l : listeners) {
                                    autoField.addTextListener(l);
                                }
                            }
                        });
                        if (!autoOk) {
                            IJ.showStatus(DIMENSION_LABELS[autoCbxIndex] + " No integer result");
                            return false;
                        }
                    } else if (sizeProduct != (double)stackSize) {
                        IJ.showStatus("channels * slices * frames = " + (int)sizeProduct + " differs from stack size (" + stackSize + ")");
                        return false;
                    }
                    lastAutoCbxIndex = autoCbxIndex;
                    IJ.showStatus("");
                    return true;
                }
            };
            gd.addDialogListener(dialogListener);
            for (final Checkbox cb : autoCbxs) {
                cb.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (cb.getState()) {
                            for (Checkbox cb2 : autoCbxs) {
                                if (cb2 == e.getSource()) continue;
                                cb2.setState(false);
                            }
                            gd.getButtons()[0].setEnabled(dialogListener.dialogItemChanged(gd, e));
                        }
                    }
                });
            }
            dialogListener.dialogItemChanged(gd, null);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ordering = gd.getNextChoiceIndex();
        int nChannels = (int)gd.getNextNumber();
        int nSlices = (int)gd.getNextNumber();
        int nFrames = (int)gd.getNextNumber();
        int mode = gd.getNextChoiceIndex();
        if (rgb) {
            splitRGB = gd.getNextBoolean();
        }
        if (rgb && nChannels > 1) {
            IJ.error("HyperStack Converter", "RGB stacks are limited to one channel");
            return;
        }
        if (nChannels * nSlices * nFrames != stackSize) {
            IJ.error("HyperStack Converter", "channels x slices x frames <> stack size");
            return;
        }
        imp.setDimensions(nChannels, nSlices, nFrames);
        if (ordering != 0 && imp.getStack().isVirtual()) {
            HyperStackConverter.reorderVirtualStack(imp, ordering);
        } else {
            this.shuffle(imp, ordering);
        }
        ImagePlus imp2 = imp;
        if (nChannels > 1 && imp.getBitDepth() != 24) {
            LUT[] luts = imp.getLuts();
            if (luts != null && luts.length < nChannels) {
                luts = null;
            }
            imp2 = new CompositeImage(imp, mode + 1);
            if (luts != null) {
                ((CompositeImage)imp2).setLuts(luts);
            }
        } else if (imp.getClass().getName().indexOf("Image5D") != -1) {
            imp2 = imp.createImagePlus();
            imp2.setStack(imp.getTitle(), imp.getImageStack());
            imp2.setDimensions(imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
            imp2.getProcessor().resetMinAndMax();
        }
        imp2.setOpenAsHyperStack(true);
        if (imp.getWindow() != null || imp != imp2) {
            if (Interpreter.isBatchMode()) {
                imp2.show();
            } else {
                new StackWindow(imp2);
            }
        }
        if (imp != imp2) {
            imp2.setOverlay(imp.getOverlay());
            imp.hide();
            WindowManager.setCurrentWindow(imp2.getWindow());
        }
        if (rgb && splitRGB) {
            new CompositeConverter().run(mode == 0 ? "composite" : "color");
            return;
        }
        if (IJ.recording() && Recorder.scriptMode()) {
            String order = orders[ordering];
            if (order.equals(orders[0])) {
                Recorder.recordCall("imp2 = HyperStackConverter.toHyperStack(imp, " + nChannels + ", " + nSlices + ", " + nFrames + ", \"" + modes[mode] + "\");");
            } else {
                Recorder.recordCall("imp2 = HyperStackConverter.toHyperStack(imp, " + nChannels + ", " + nSlices + ", " + nFrames + ", \"" + order + "\", \"" + modes[mode] + "\");");
            }
        }
    }

    public void shuffle(ImagePlus imp, int order) {
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        int first = 0;
        int middle = 1;
        int last = 2;
        int nFirst = nChannels;
        int nMiddle = nSlices;
        int nLast = nFrames;
        switch (order) {
            case 1: {
                first = 0;
                middle = 2;
                last = 1;
                nFirst = nChannels;
                nMiddle = nFrames;
                nLast = nSlices;
                break;
            }
            case 2: {
                first = 1;
                middle = 0;
                last = 2;
                nFirst = nSlices;
                nMiddle = nChannels;
                nLast = nFrames;
                break;
            }
            case 3: {
                first = 1;
                middle = 2;
                last = 0;
                nFirst = nSlices;
                nMiddle = nFrames;
                nLast = nChannels;
                break;
            }
            case 4: {
                first = 2;
                middle = 0;
                last = 1;
                nFirst = nFrames;
                nMiddle = nChannels;
                nLast = nSlices;
                break;
            }
            case 5: {
                first = 2;
                middle = 1;
                last = 0;
                nFirst = nFrames;
                nMiddle = nSlices;
                nLast = nChannels;
            }
        }
        if (order != 0) {
            ImageStack stack = imp.getImageStack();
            Object[] images1 = stack.getImageArray();
            Object[] images2 = new Object[images1.length];
            System.arraycopy(images1, 0, images2, 0, images1.length);
            String[] labels1 = stack.getSliceLabels();
            String[] labels2 = new String[labels1.length];
            System.arraycopy(labels1, 0, labels2, 0, labels1.length);
            int[] index = new int[3];
            index[2] = 0;
            while (index[2] < nFrames) {
                index[1] = 0;
                while (index[1] < nSlices) {
                    index[0] = 0;
                    while (index[0] < nChannels) {
                        int dstIndex = index[0] + index[1] * nChannels + index[2] * nChannels * nSlices;
                        int srcIndex = index[first] + index[middle] * nFirst + index[last] * nFirst * nMiddle;
                        images1[dstIndex] = images2[srcIndex];
                        labels1[dstIndex] = labels2[srcIndex];
                        index[0] = index[0] + 1;
                    }
                    index[1] = index[1] + 1;
                }
                index[2] = index[2] + 1;
            }
        }
    }

    void convertHSToStack(ImagePlus imp) {
        if (!imp.isHyperStack() && !imp.isComposite()) {
            return;
        }
        ImagePlus imp2 = imp;
        if (imp.isComposite()) {
            ImageStack stack = imp.getStack();
            imp2 = imp.createImagePlus();
            imp2.setStack(imp.getTitle(), stack);
            int[] dim = imp.getDimensions();
            imp2.setDimensions(dim[2], dim[3], dim[4]);
            ImageProcessor ip2 = imp2.getProcessor();
            ip2.setColorModel(ip2.getDefaultColorModel());
        }
        imp2.setOpenAsHyperStack(false);
        if (imp.getWindow() != null || imp != imp2) {
            new StackWindow(imp2);
        }
        if (imp != imp2) {
            imp2.setOverlay(imp.getOverlay());
            Calibration cal = imp2.getCalibration();
            if (cal.frameInterval > 0.0) {
                imp2.setDimensions(1, 1, imp2.getStackSize());
            } else {
                imp2.setDimensions(1, imp2.getStackSize(), 1);
            }
            imp.hide();
        }
        if (IJ.recording() && Recorder.scriptMode()) {
            Recorder.recordCall("HyperStackConverter.toStack(imp);");
        }
    }

    void newHyperStack() {
        IJ.runMacroFile("ij.jar:HyperStackMaker", "");
    }
}

