/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

public class PGM_Reader
extends ImagePlus
implements PlugIn {
    private int width;
    private int height;
    private boolean rawBits;
    private boolean sixteenBits;
    private boolean isColor;
    private boolean isBlackWhite;
    private int maxValue;

    @Override
    public void run(String arg) {
        ImageStack stack;
        OpenDialog od = new OpenDialog("PBM/PGM/PPM Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            stack = this.openFile(path);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            IJ.showMessage("PBM/PGM/PPM Reader", msg.equals("") ? "" + e : msg);
            return;
        }
        this.setStack(name, stack);
        FileInfo fi = new FileInfo();
        fi.fileFormat = 8;
        fi.directory = directory;
        fi.fileName = name;
        this.setFileInfo(fi);
        if (arg.equals("")) {
            this.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageStack openFile(String path) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
        try {
            StreamTokenizer tok = new StreamTokenizer(is);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.parseNumbers();
            tok.eolIsSignificant(true);
            tok.commentChar(35);
            this.openHeader(tok);
            if (!this.isColor && this.sixteenBits) {
                if (this.rawBits) {
                    ImageProcessor ip = this.open16bitRawImage(is, this.width, this.height);
                    ImageStack stack = new ImageStack(this.width, this.height);
                    stack.addSlice("", ip);
                    ImageStack imageStack = stack;
                    return imageStack;
                }
                ImageProcessor ip = this.open16bitAsciiImage(tok, this.width, this.height);
                ImageStack stack = new ImageStack(this.width, this.height);
                stack.addSlice("", ip);
                ImageStack imageStack = stack;
                return imageStack;
            }
            if (!this.isColor) {
                byte[] pixels = new byte[this.width * this.height];
                ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels, null);
                if (this.rawBits) {
                    this.openRawImage(is, this.width * this.height, pixels);
                } else {
                    this.openAsciiImage(tok, this.width * this.height, pixels);
                }
                for (int i = pixels.length - 1; i >= 0; --i) {
                    if (this.isBlackWhite) {
                        if (this.rawBits) {
                            if (i >= pixels.length / 8) continue;
                            for (int bit = 7; bit >= 0; --bit) {
                                pixels[8 * i + 7 - bit] = (byte)((pixels[i] & (int)Math.pow(2.0, bit)) == 0 ? 255 : 0);
                            }
                            continue;
                        }
                        pixels[i] = (byte)(pixels[i] == 0 ? 255 : 0);
                        continue;
                    }
                    pixels[i] = (byte)(0xFF & 255 * (0xFF & pixels[i]) / this.maxValue);
                }
                ImageStack stack = new ImageStack(this.width, this.height);
                stack.addSlice("", ip);
                ImageStack bit = stack;
                return bit;
            }
            if (!this.sixteenBits) {
                int[] pixels = new int[this.width * this.height];
                byte[] bytePixels = new byte[3 * this.width * this.height];
                ColorProcessor ip = new ColorProcessor(this.width, this.height, pixels);
                if (this.rawBits) {
                    this.openRawImage(is, 3 * this.width * this.height, bytePixels);
                } else {
                    this.openAsciiImage(tok, 3 * this.width * this.height, bytePixels);
                }
                for (int i = 0; i < this.width * this.height; ++i) {
                    int r = 0xFF & bytePixels[i * 3];
                    int g = 0xFF & bytePixels[i * 3 + 1];
                    int b = 0xFF & bytePixels[i * 3 + 2];
                    r = r * 255 / this.maxValue << 16;
                    g = g * 255 / this.maxValue << 8;
                    b = b * 255 / this.maxValue;
                    pixels[i] = 0xFF000000 | r | g | b;
                }
                ImageStack stack = new ImageStack(this.width, this.height);
                stack.addSlice("", ip);
                ImageStack r = stack;
                return r;
            }
            short[] red = new short[this.width * this.height];
            short[] green = new short[this.width * this.height];
            short[] blue = new short[this.width * this.height];
            if (this.rawBits) {
                byte[] bytePixels = new byte[6 * this.width * this.height];
                this.openRawImage(is, 6 * this.width * this.height, bytePixels);
                for (int i = 0; i < this.width * this.height; ++i) {
                    int r1 = 0xFF & bytePixels[i * 6];
                    int r2 = 0xFF & bytePixels[i * 6 + 1];
                    int g1 = 0xFF & bytePixels[i * 6 + 2];
                    int g2 = 0xFF & bytePixels[i * 6 + 3];
                    int b1 = 0xFF & bytePixels[i * 6 + 4];
                    int b2 = 0xFF & bytePixels[i * 6 + 5];
                    red[i] = (short)(0xFFFF & r1 * 256 + r2);
                    green[i] = (short)(0xFFFF & g1 * 256 + g2);
                    blue[i] = (short)(0xFFFF & b1 * 256 + b2);
                }
            } else {
                ImageProcessor ip = this.open16bitAsciiImage(tok, 3 * this.width, this.height);
                short[] pixels = (short[])ip.getPixels();
                for (int i = 0; i < this.width * this.height; ++i) {
                    red[i] = (short)(pixels[i * 3] & 0xFFFFFF);
                    green[i] = (short)(pixels[i * 3 + 1] & 0xFFFFFF);
                    blue[i] = (short)(pixels[i * 3 + 2] & 0xFFFFFF);
                }
            }
            ImageStack stack = new ImageStack(this.width, this.height);
            stack.addSlice("red", new ShortProcessor(this.width, this.height, red, null));
            stack.addSlice("green", new ShortProcessor(this.width, this.height, green, null));
            stack.addSlice("blue", new ShortProcessor(this.width, this.height, blue, null));
            ImageStack imageStack = stack;
            return imageStack;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public void openHeader(StreamTokenizer tok) throws IOException {
        String magicNumber = this.getWord(tok);
        if (magicNumber.equals("P1")) {
            this.rawBits = false;
            this.isColor = false;
            this.isBlackWhite = true;
        } else if (magicNumber.equals("P4")) {
            this.rawBits = true;
            this.isColor = false;
            this.isBlackWhite = true;
        } else if (magicNumber.equals("P2")) {
            this.rawBits = false;
            this.isColor = false;
            this.isBlackWhite = false;
        } else if (magicNumber.equals("P5")) {
            this.rawBits = true;
            this.isColor = false;
            this.isBlackWhite = false;
        } else if (magicNumber.equals("P3")) {
            this.rawBits = false;
            this.isColor = true;
            this.isBlackWhite = false;
        } else if (magicNumber.equals("P6")) {
            this.rawBits = true;
            this.isColor = true;
            this.isBlackWhite = false;
        } else {
            throw new IOException("PxM files must start with \"P1\" or \"P2\" or \"P3\" or \"P4\" or \"P5\" or \"P6\"");
        }
        this.width = this.getInt(tok);
        this.height = this.getInt(tok);
        if (this.width == -1 || this.height == -1) {
            throw new IOException("Error opening PxM header..");
        }
        if (!this.isBlackWhite) {
            this.maxValue = this.getInt(tok);
            if (this.maxValue == -1) {
                throw new IOException("Error opening PxM header..");
            }
            this.sixteenBits = this.maxValue > 255;
        } else {
            this.maxValue = 255;
        }
        if (this.sixteenBits && this.maxValue > 65535) {
            throw new IOException("The maximum gray value is larger than 65535.");
        }
    }

    public void openAsciiImage(StreamTokenizer tok, int size, byte[] pixels) throws IOException {
        int i = 0;
        int inc = size / 20;
        if (inc == 0) {
            inc = 1;
        }
        while (true) {
            if (tok.nextToken() == -1) break;
            if (tok.ttype != -2) continue;
            pixels[i++] = (byte)((int)tok.nval & 0xFF);
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }

    public void openRawImage(InputStream is, int size, byte[] pixels) throws IOException {
        int count = 0;
        while (count < size && count >= 0) {
            count = is.read(pixels, count, size - count);
        }
    }

    public ImageProcessor open16bitRawImage(InputStream is, int width, int height) throws IOException {
        int size = width * height * 2;
        byte[] bytes = new byte[size];
        int count = 0;
        while (count < size && count >= 0) {
            count = is.read(bytes, count, size - count);
        }
        short[] pixels = new short[size / 2];
        int i = 0;
        int j = 0;
        while (i < size / 2) {
            pixels[i] = (short)((bytes[j] & 0xFF) << 8 | bytes[j + 1] & 0xFF);
            ++i;
            j += 2;
        }
        return new ShortProcessor(width, height, pixels, null);
    }

    public ImageProcessor open16bitAsciiImage(StreamTokenizer tok, int width, int height) throws IOException {
        int i = 0;
        int size = width * height;
        int inc = size / 20;
        if (inc == 0) {
            inc = 1;
        }
        short[] pixels = new short[size];
        while (true) {
            if (tok.nextToken() == -1) break;
            if (tok.ttype != -2) continue;
            pixels[i++] = (short)((int)tok.nval & 0xFFFF);
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
        return new ShortProcessor(width, height, pixels, null);
    }

    String getWord(StreamTokenizer tok) throws IOException {
        block1: {
            do {
                if (tok.nextToken() == -1) break block1;
            } while (tok.ttype != -3);
            return tok.sval;
        }
        return null;
    }

    int getInt(StreamTokenizer tok) throws IOException {
        block1: {
            do {
                if (tok.nextToken() == -1) break block1;
            } while (tok.ttype != -2);
            return (int)tok.nval;
        }
        return -1;
    }
}

