/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.StackConverter;
import java.awt.Image;

public class Straightener
implements PlugIn {
    static boolean processStack;

    @Override
    public void run(String arg) {
        int type;
        boolean rotatedRectangle;
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        boolean bl = rotatedRectangle = roi != null && roi instanceof RotatedRectRoi;
        if (roi == null || !roi.isLine() && !rotatedRectangle) {
            IJ.error("Straightener", "Line, or rotated rectangle, selection required");
            return;
        }
        if (rotatedRectangle) {
            IJ.run(imp, "Duplicate...", " ");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        int width = Math.round(roi.getStrokeWidth());
        boolean isMacro = IJ.macroRunning() && Macro.getOptions() != null;
        int stackSize = imp.getStackSize();
        if (stackSize == 1) {
            processStack = false;
        }
        if (imp.isComposite()) {
            processStack = true;
        }
        String newTitle = WindowManager.getUniqueName(imp.getTitle());
        if (width <= 1 || isMacro || stackSize > 1) {
            if (width <= 1) {
                width = 20;
            }
            GenericDialog gd = new GenericDialog("Straightener");
            gd.addStringField("Title:", newTitle, 15);
            gd.addNumericField("Line Width:", width, 0, 3, "pixels");
            if (stackSize > 1) {
                gd.addCheckbox("Process entire stack", processStack);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.unlock();
                return;
            }
            newTitle = gd.getNextString();
            width = (int)gd.getNextNumber();
            roi.setStrokeWidth(width);
            if (stackSize > 1) {
                processStack = gd.getNextBoolean();
            }
        }
        if ((type = (roi = (Roi)imp.getRoi().clone()).getType()) == 7) {
            IJ.run(imp, "Fit Spline", "");
        }
        ImageProcessor ip2 = null;
        ImagePlus imp2 = null;
        if (processStack) {
            boolean compositeMode;
            boolean bl2 = compositeMode = imp.isComposite() && imp.getDisplayMode() == 1;
            if (compositeMode) {
                imp.setDisplayMode(2);
            }
            ImageStack stack2 = this.straightenStack(imp, roi, width);
            imp2 = new ImagePlus(newTitle, stack2);
            if (compositeMode) {
                imp.setDisplayMode(1);
            }
            if (imp.isComposite()) {
                ImageConverter.setDoScaling(false);
                if (imp.getBitDepth() == 8) {
                    new StackConverter(imp2).convertToGray8();
                } else if (imp.getBitDepth() == 16) {
                    new StackConverter(imp2).convertToGray16();
                }
                ImageConverter.setDoScaling(true);
            }
        } else {
            ip2 = this.straighten(imp, roi, width);
            imp2 = new ImagePlus(newTitle, ip2);
        }
        imp.unlock();
        if (imp2 == null) {
            return;
        }
        Calibration cal = imp.getCalibration();
        if (cal.pixelWidth == cal.pixelHeight) {
            imp2.setCalibration(cal);
        }
        if (imp.isComposite()) {
            LUT[] luts = imp.getLuts();
            CompositeImage cImp = new CompositeImage(imp2);
            cImp.setLuts(luts);
            cImp.setDisplayMode(imp.getDisplayMode());
            cImp.show();
        } else {
            imp2.show();
        }
    }

    public ImageProcessor straighten(ImagePlus imp, Roi roi, int width) {
        ImageProcessor ip2 = imp.getBitDepth() == 24 && roi.getType() != 5 ? this.straightenRGB(imp, width) : (imp.isComposite() && ((CompositeImage)imp).getMode() == 1 ? (roi.getType() == 5 ? this.rotateCompositeLine(imp, width) : this.straightenComposite(imp, width)) : (roi.getType() == 5 ? this.rotateLine(imp, width) : this.straightenLine(imp, width)));
        return ip2;
    }

    public ImageStack straightenStack(ImagePlus imp, Roi roi, int width) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        ImageStack stack2 = null;
        for (int i = 1; i <= n; ++i) {
            IJ.showProgress(i, n);
            imp.setSlice(i);
            ImageProcessor ip2 = this.straighten(imp, roi, width);
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
            }
            stack2.addSlice(null, ip2);
        }
        imp.setSlice(current);
        return stack2;
    }

    public ImageProcessor straightenLine(ImagePlus imp, int width) {
        return this.straightenLine(imp, null, width);
    }

    public ImageProcessor straightenLine(ImagePlus imp, Line line, int width) {
        Roi tempRoi = imp.getRoi();
        if (line != null) {
            tempRoi = line;
            width = (int)line.getStrokeWidth();
        }
        if (tempRoi == null) {
            return null;
        }
        if (tempRoi instanceof Line) {
            FloatPolygon fp = ((Line)tempRoi).getFloatPoints();
            tempRoi = new PolygonRoi(fp.xpoints, fp.ypoints, 2, 6);
        } else if (!(tempRoi instanceof PolygonRoi)) {
            return null;
        }
        PolygonRoi roi = (PolygonRoi)tempRoi;
        if (roi == null) {
            return null;
        }
        if (roi.getState() == 0) {
            roi.exitConstructingMode();
        }
        if (roi.isSplineFit()) {
            roi.removeSplineFit();
        }
        int type = roi.getType();
        int n = roi.getNCoordinates();
        double len = roi.getLength();
        roi.fitSplineForStraightening();
        if (roi.getNCoordinates() < 2) {
            return null;
        }
        FloatPolygon p = roi.getFloatPolygon();
        n = p.npoints;
        ImageProcessor ip = imp.getProcessor();
        FloatProcessor ip2 = new FloatProcessor(n, width);
        float[] pixels = (float[])((ImageProcessor)ip2).getPixels();
        double x2 = p.xpoints[0] - (p.xpoints[1] - p.xpoints[0]);
        double y2 = p.ypoints[0] - (p.ypoints[1] - p.ypoints[0]);
        if (width <= 1) {
            ((ImageProcessor)ip2).putPixelValue(0, 0, ip.getInterpolatedValue(x2, y2));
        }
        for (int i = 0; i < n; ++i) {
            if (!processStack && i % 10 == 0) {
                IJ.showProgress(i, n);
            }
            double x1 = x2;
            double y1 = y2;
            x2 = p.xpoints[i];
            y2 = p.ypoints[i];
            if (width == 1) {
                ((ImageProcessor)ip2).putPixelValue(i, 0, ip.getInterpolatedValue(x2, y2));
                continue;
            }
            double dx = x2 - x1;
            double dy = y1 - y2;
            double length = (float)Math.sqrt(dx * dx + dy * dy);
            double x = x2 - (dy /= length) * (double)(width - 1) / 2.0;
            double y = y2 - (dx /= length) * (double)(width - 1) / 2.0;
            int j = 0;
            int n2 = width;
            do {
                ((ImageProcessor)ip2).putPixelValue(i, j++, ip.getInterpolatedValue(x, y));
                x += dy;
                y += dx;
            } while (--n2 > 0);
        }
        if (!processStack) {
            IJ.showProgress(n, n);
        }
        if (type == 7) {
            roi.removeSplineFit();
        } else {
            imp.draw();
        }
        if (imp.getBitDepth() != 24) {
            ip2.setColorModel(ip.getColorModel());
            ((ImageProcessor)ip2).resetMinAndMax();
        }
        return ip2;
    }

    public ImageProcessor rotateLine(ImagePlus imp, int width) {
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 5) {
            throw new IllegalArgumentException("Straight line selection expected");
        }
        ImageProcessor ip2 = imp.getBitDepth() == 24 ? this.straightenRGB(imp, width) : this.straightenLine(imp, width);
        return ip2;
    }

    ImageProcessor straightenRGB(ImagePlus imp, int width) {
        int w = imp.getWidth();
        int h = imp.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)imp.getProcessor();
        cp.getRGB(r, g, b);
        Roi roi = imp.getRoi();
        if (roi == null) {
            return null;
        }
        ImagePlus imp2 = new ImagePlus("red", new ByteProcessor(w, h, r, null));
        imp2.setRoi((Roi)roi.clone());
        ImageProcessor red = this.straightenLine(imp2, width);
        if (red == null) {
            return null;
        }
        imp2 = new ImagePlus("green", new ByteProcessor(w, h, g, null));
        imp2.setRoi((Roi)roi.clone());
        ImageProcessor green = this.straightenLine(imp2, width);
        if (green == null) {
            return null;
        }
        imp2 = new ImagePlus("blue", new ByteProcessor(w, h, b, null));
        imp2.setRoi((Roi)roi.clone());
        ImageProcessor blue = this.straightenLine(imp2, width);
        if (blue == null) {
            return null;
        }
        ColorProcessor cp2 = new ColorProcessor(red.getWidth(), red.getHeight());
        red = red.convertToByte(false);
        green = green.convertToByte(false);
        blue = blue.convertToByte(false);
        cp2.setRGB((byte[])red.getPixels(), (byte[])green.getPixels(), (byte[])blue.getPixels());
        imp.setRoi(imp2.getRoi());
        return cp2;
    }

    ImageProcessor straightenComposite(ImagePlus imp, int width) {
        Image img = imp.getImage();
        ImagePlus imp2 = new ImagePlus("temp", new ColorProcessor(img));
        imp2.setRoi(imp.getRoi());
        ImageProcessor ip2 = this.straightenRGB(imp2, width);
        imp.setRoi(imp2.getRoi());
        return ip2;
    }

    ImageProcessor rotateCompositeLine(ImagePlus imp, int width) {
        Image img = imp.getImage();
        ImagePlus imp2 = new ImagePlus("temp", new ColorProcessor(img));
        imp2.setRoi(imp.getRoi());
        ImageProcessor ip2 = this.rotateLine(imp2, width);
        return ip2;
    }
}

