/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ContrastPlot
extends Canvas
implements MouseListener {
    Color[] hColors;
    static final int WIDTH = 128;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;
    Color color = Color.gray;
    double scale = Prefs.getGuiScale();
    int width = 128;
    int height = 64;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.width = (int)((double)this.width * 1.3);
        this.height = (int)((double)this.height * 1.3);
        if (this.scale > 1.0) {
            this.width = (int)((double)this.width * this.scale);
            this.height = (int)((double)this.height * this.scale);
        }
        this.setSize(this.width + 1, this.height + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + 1, this.height + 1);
    }

    void setHistogram(ImageStatistics stats, boolean isLogHist) {
        this.histogram = stats.histogram;
        if (isLogHist) {
            for (int j = 0; j < 256; ++j) {
                this.histogram[j] = (int)(Math.log(this.histogram[j]) * 100.0);
            }
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        this.hColors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.hColors[i] = new Color(110, 110, 150);
        }
        int impType = imp.getType();
        if (impType == 0 || impType == 1 || impType == 2) {
            ImageProcessor ip = imp.getProcessor();
            ColorModel cm = ip.getColorModel();
            IndexColorModel icm = (IndexColorModel)cm;
            int mapSize = icm.getMapSize();
            if (mapSize != 256) {
                return;
            }
            byte[] red = new byte[256];
            byte[] green = new byte[256];
            byte[] blue = new byte[256];
            icm.getReds(red);
            icm.getGreens(green);
            icm.getBlues(blue);
            for (int i = 0; i < 256; ++i) {
                this.hColors[i] = new Color(red[i] & 0xFF, green[i] & 0xFF, blue[i] & 0xFF);
            }
        }
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = isLogHist ? (int)(Math.log(stats.maxCount) * 100.0) : stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = (double)this.width / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        int j2 = (int)((this.max - this.defaultMin) / (this.defaultMax - this.defaultMin) * 255.0);
        int j1 = (int)((this.min - this.defaultMin) / (this.defaultMax - this.defaultMin) * 255.0);
        double colscale = j2 > j1 ? 255.0 / (double)(j2 - j1) : 1.0;
        if (this.max != this.min) {
            slope = (double)this.height / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = this.height;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? this.height - (int)((this.defaultMin - this.min) * slope) : this.height;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = this.width;
            y2 = this.max > this.min ? this.height - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(this.width, this.height);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, this.width, this.height);
                double scale2 = (double)this.width / 256.0;
                for (int i = 0; i < 256; ++i) {
                    int x = (int)((double)i * scale2);
                    int j = (int)((double)(i - j1) * colscale);
                    if (i < j1) {
                        j = 0;
                    }
                    if (i > j2) {
                        j = 255;
                    }
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[j]);
                    }
                    int y = this.height - this.height * this.histogram[i] / this.hmax;
                    this.osg.drawLine(x, this.height, x, y);
                    this.osg.setColor(Color.black);
                    this.osg.fillRect(x, y, 1, 1);
                }
                this.osg.dispose();
            }
            if (this.os != null) {
                g.drawImage(this.os, 0, 0, this);
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.width, this.height);
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, this.height - 5, x2, this.height);
        g.drawRect(0, 0, this.width, this.height);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

