/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ShortProcessor;
import java.awt.Image;

public class SignedShortProcessor
extends ShortProcessor {
    public SignedShortProcessor(int width, int height) {
        super(width, height);
    }

    public SignedShortProcessor(ShortProcessor ip) {
        super(ip.getWidth(), ip.getHeight());
        for (int i = 0; i < this.getPixelCount(); ++i) {
            this.set(i, ip.get(i));
        }
    }

    @Override
    public void findMinAndMax() {
        if (this.fixedScale || this.pixels == null) {
            return;
        }
        int size = this.width * this.height;
        int min = this.pixels[0];
        int max = this.pixels[0];
        for (int i = 1; i < size; ++i) {
            int value = this.pixels[i];
            if (value < min) {
                min = value;
                continue;
            }
            if (value <= max) continue;
            max = value;
        }
        this.min = min;
        this.max = max;
        this.minMaxSet = true;
    }

    @Override
    public Image createImage() {
        block7: {
            boolean thresholding;
            if (!this.minMaxSet) {
                this.findMinAndMax();
            }
            boolean firstTime = this.pixels8 == null;
            boolean bl = thresholding = this.minThreshold != -808080.0 && this.lutUpdateMode < 2;
            if (firstTime || !this.lutAnimation) {
                this.create8BitImage(thresholding && this.lutUpdateMode == 0);
            }
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            if (!thresholding) break block7;
            int t1 = (int)this.minThreshold;
            int t2 = (int)this.maxThreshold;
            int size = this.width * this.height;
            if (this.lutUpdateMode == 1) {
                for (int i = 0; i < size; ++i) {
                    short value = this.pixels[i];
                    this.pixels8[i] = value >= t1 && value <= t2 ? -1 : 0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    short value = this.pixels[i];
                    if (value < t1 || value > t2) continue;
                    this.pixels8[i] = -1;
                }
            }
        }
        return this.createBufferedImage();
    }

    private byte[] create8BitImage(boolean thresholding) {
        int size = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[size];
        }
        int min2 = (int)this.getMin();
        int max2 = (int)this.getMax();
        int maxValue = 255;
        double scale = 256.0 / (double)(max2 - min2 + 1);
        if (thresholding) {
            maxValue = 254;
            scale = 255.0 / (double)(max2 - min2 + 1);
        }
        for (int i = 0; i < size; ++i) {
            int value = this.pixels[i] - min2;
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * scale + 0.5)) > maxValue) {
                value = maxValue;
            }
            this.pixels8[i] = (byte)value;
        }
        return this.pixels8;
    }

    @Override
    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return 0;
    }

    @Override
    public final int get(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    @Override
    protected void process(int op, double value) {
        double range = this.getMax() - this.getMin();
        int min2 = (int)this.getMin();
        int max2 = (int)this.getMax();
        int fgColor2 = this.fgColor;
        int intValue = (int)value;
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                int v2;
                int v1 = this.pixels[i];
                switch (op) {
                    case 0: {
                        v2 = max2 - (v1 - min2);
                        break;
                    }
                    case 1: {
                        v2 = fgColor2;
                        break;
                    }
                    case 15: {
                        v2 = intValue;
                        break;
                    }
                    case 2: {
                        v2 = v1 + intValue;
                        break;
                    }
                    case 3: {
                        v2 = (int)Math.round((double)v1 * value);
                        break;
                    }
                    case 4: {
                        v2 = v1 & intValue;
                        break;
                    }
                    case 5: {
                        v2 = v1 | intValue;
                        break;
                    }
                    case 6: {
                        v2 = v1 ^ intValue;
                        break;
                    }
                    case 7: {
                        if (range <= 0.0 || v1 == min2) {
                            v2 = v1;
                            break;
                        }
                        v2 = (int)(Math.exp(value * Math.log((double)(v1 - min2) / range)) * range + (double)min2);
                        break;
                    }
                    case 8: {
                        if (v1 <= 0) {
                            v2 = 0;
                            break;
                        }
                        v2 = (int)(Math.log(v1) * ((double)max2 / Math.log(max2)));
                        break;
                    }
                    case 13: {
                        v2 = (int)Math.exp((double)v1 * (Math.log(max2) / (double)max2));
                        break;
                    }
                    case 11: {
                        double d1 = v1;
                        v2 = (int)(d1 * d1);
                        break;
                    }
                    case 12: {
                        v2 = (int)Math.sqrt(v1);
                        break;
                    }
                    case 14: {
                        v2 = Math.abs(v1);
                        break;
                    }
                    case 9: {
                        if ((double)v1 < value) {
                            v2 = intValue;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    case 10: {
                        if ((double)v1 > value) {
                            v2 = intValue;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    default: {
                        v2 = v1;
                    }
                }
                if (v2 < Short.MIN_VALUE) {
                    v2 = Short.MIN_VALUE;
                }
                if (v2 > Short.MAX_VALUE) {
                    v2 = Short.MAX_VALUE;
                }
                this.pixels[i++] = (short)v2;
            }
        }
    }
}

