/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;
import ij.util.ArrayUtil;
import java.awt.Rectangle;

public class StackProcessor {
    public static final int FILTER_MEAN = 10;
    public static final int FILTER_MEDIAN = 11;
    public static final int FILTER_MIN = 12;
    public static final int FILTER_MAX = 13;
    public static final int FILTER_VAR = 14;
    public static final int FILTER_MAXLOCAL = 15;
    private ImageStack stack;
    private ImageProcessor ip;
    int nSlices;
    double xScale;
    double yScale;
    int[] table;
    double fillValue;
    float[] voxels;
    static final int FLIPH = 0;
    static final int FLIPV = 1;
    static final int SCALE = 2;
    static final int INVERT = 3;
    static final int APPLY_TABLE = 4;
    static final int SCALE_WITH_FILL = 5;

    public StackProcessor(ImageStack stack) {
        this(stack, null);
    }

    public StackProcessor(ImageStack stack, ImageProcessor ip) {
        this.stack = stack;
        this.ip = ip;
        this.nSlices = stack.size();
        if (this.nSlices > 1 && ip != null) {
            ip.setProgressBar(null);
        }
    }

    void process(int command) {
        String s = "";
        ImageProcessor ip2 = this.stack.getProcessor(1);
        switch (command) {
            case 0: 
            case 1: {
                s = "Flip: ";
                break;
            }
            case 2: {
                s = "Scale: ";
                break;
            }
            case 5: {
                s = "Scale: ";
                ip2.setBackgroundValue(this.fillValue);
                break;
            }
            case 3: {
                s = "Invert: ";
                break;
            }
            case 4: {
                s = "Apply: ";
            }
        }
        if (this.ip == null) {
            this.ip = ip2;
        }
        ip2.setRoi(this.ip.getRoi());
        ip2.setInterpolate(this.ip.getInterpolate());
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus(s, i, this.nSlices);
            ip2.setPixels(this.stack.getPixels(i));
            if (this.nSlices == 1 && i == 1 && command == 2) {
                ip2.snapshot();
            }
            switch (command) {
                case 0: {
                    ip2.flipHorizontal();
                    break;
                }
                case 1: {
                    ip2.flipVertical();
                    break;
                }
                case 2: 
                case 5: {
                    ip2.scale(this.xScale, this.yScale);
                    break;
                }
                case 3: {
                    ip2.invert();
                    break;
                }
                case 4: {
                    ip2.applyTable(this.table);
                }
            }
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    public void invert() {
        this.process(3);
    }

    public void flipHorizontal() {
        this.process(0);
    }

    public void flipVertical() {
        this.process(1);
    }

    public void applyTable(int[] table) {
        this.table = table;
        this.process(4);
    }

    public void scale(double xScale, double yScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.process(2);
    }

    public void scale(double xScale, double yScale, double fillValue) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.fillValue = fillValue;
        this.process(5);
    }

    public ImageStack resize(int newWidth, int newHeight) {
        return this.resize(newWidth, newHeight, false);
    }

    public ImageStack resize(int newWidth, int newHeight, boolean averageWhenDownsizing) {
        Rectangle roi;
        ImageStack stack2 = new ImageStack(newWidth, newHeight);
        Rectangle rectangle = roi = this.ip != null ? this.ip.getRoi() : null;
        if (this.ip == null) {
            this.ip = this.stack.getProcessor(1).duplicate();
        }
        try {
            for (int i = 1; i <= this.nSlices; ++i) {
                this.showStatus("Resize: ", i, this.nSlices);
                this.ip.setPixels(this.stack.getPixels(1));
                String label = this.stack.getSliceLabel(1);
                this.stack.deleteSlice(1);
                ImageProcessor ip2 = this.ip.resize(newWidth, newHeight, averageWhenDownsizing);
                if (ip2 != null) {
                    stack2.addSlice(label, ip2);
                }
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            while (this.stack.size() > 1) {
                this.stack.deleteLastSlice();
            }
            IJ.outOfMemory("StackProcessor.resize");
            IJ.showProgress(1.0);
        }
        return stack2;
    }

    public ImageStack crop(int x, int y, int width, int height) {
        ImageStack stack2 = new ImageStack(width, height);
        for (int i = 1; i <= this.nSlices; ++i) {
            ImageProcessor ip1 = this.stack.getProcessor(1);
            ip1.setRoi(x, y, width, height);
            String label = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor ip2 = ip1.crop();
            stack2.addSlice(label, ip2);
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
        return stack2;
    }

    ImageStack rotate90Degrees(boolean clockwise) {
        ImageStack stack2 = new ImageStack(this.stack.getHeight(), this.stack.getWidth());
        if (this.ip == null) {
            this.ip = this.stack.getProcessor(1).duplicate();
        }
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus("Rotate: ", i, this.nSlices);
            this.ip.setPixels(this.stack.getPixels(1));
            String label = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor ip2 = clockwise ? this.ip.rotateRight() : this.ip.rotateLeft();
            if (ip2 != null) {
                stack2.addSlice(label, ip2);
            }
            if (Interpreter.isBatchMode()) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showProgress(1.0);
        }
        return stack2;
    }

    public ImageStack rotateRight() {
        return this.rotate90Degrees(true);
    }

    public ImageStack rotateLeft() {
        return this.rotate90Degrees(false);
    }

    public void copyBits(ImageProcessor src, int xloc, int yloc, int mode) {
        this.copyBits(src, null, xloc, yloc, mode);
    }

    public void copyBits(ImageStack src, int xloc, int yloc, int mode) {
        this.copyBits(null, src, xloc, yloc, mode);
    }

    private void copyBits(ImageProcessor srcIp, ImageStack srcStack, int xloc, int yloc, int mode) {
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        boolean stackSource = srcIp == null;
        for (int i = 1; i <= this.nSlices; ++i) {
            if (stackSource) {
                srcIp = srcStack.getProcessor(i);
            }
            ImageProcessor dstIp = this.stack.getProcessor(i);
            dstIp.copyBits(srcIp, xloc, yloc, mode);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    void showStatus(String s, int n, int total) {
        IJ.showStatus(s + n + "/" + total);
    }

    private int[] createKernelEllipsoid(float radx, float rady, float radz) {
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int[] ker = new int[(2 * vx + 1) * (2 * vy + 1) * (2 * vz + 1)];
        double rx2 = radx * radx;
        double ry2 = rady * rady;
        double rz2 = radz * radz;
        rx2 = rx2 != 0.0 ? 1.0 / rx2 : 0.0;
        ry2 = ry2 != 0.0 ? 1.0 / ry2 : 0.0;
        rz2 = rz2 != 0.0 ? 1.0 / rz2 : 0.0;
        int idx = 0;
        for (int k = -vz; k <= vz; ++k) {
            for (int j = -vy; j <= vy; ++j) {
                for (int i = -vx; i <= vx; ++i) {
                    double dist = (double)(i * i) * rx2 + (double)(j * j) * ry2 + (double)(k * k) * rz2;
                    ker[idx] = dist <= 1.0 ? 1 : 0;
                    ++idx;
                }
            }
        }
        return ker;
    }

    public void filter3D(ImageStack out, float radx, float rady, float radz, int zmin, int zmax, int filter) {
        this.filter3D(out, 1, this.stack.getSize(), radx, rady, radz, 0, 1, zmin, zmax, 0, 1, filter);
    }

    public void filter3D(ImageStack out, int nChs, int nZSlices, float radx, float rady, float radz, int cmin, int cmax, int zmin, int zmax, int tmin, int tmax, int filter) {
        int[] ker = this.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int i = 0; i < ker.length; ++i) {
            nb += ker[i];
        }
        if (nZSlices > this.stack.getSize()) {
            nZSlices = this.stack.getSize();
        }
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > nZSlices) {
            zmax = nZSlices;
        }
        if (cmin < 0) {
            cmin = 0;
        }
        if (cmax > nChs) {
            cmax = nChs;
        }
        if (tmin < 0) {
            tmin = 0;
        }
        if (tmax > this.stack.getSize() / nChs / nZSlices) {
            tmax = this.stack.getSize() / nChs / nZSlices;
        }
        int sizex = this.stack.getWidth();
        int sizey = this.stack.getHeight();
        for (int t = tmin; t < tmax; ++t) {
            for (int c = cmin; c < cmax; ++c) {
                for (int z = zmin; z < zmax; ++z) {
                    if (zmin == 0) {
                        IJ.showProgress(z + 1, zmax);
                    }
                    int stackIndex = c + nChs * z + nChs * nZSlices * t;
                    for (int y = 0; y < sizey; ++y) {
                        block13: for (int x = 0; x < sizex; ++x) {
                            ArrayUtil tab = this.getNeighborhood(c, t, nChs, nZSlices, ker, nb, x, y, z, radx, rady, radz);
                            switch (filter) {
                                case 10: {
                                    out.setVoxel(x, y, stackIndex, tab.getMean());
                                    continue block13;
                                }
                                case 11: {
                                    out.setVoxel(x, y, stackIndex, tab.medianSort());
                                    continue block13;
                                }
                                case 12: {
                                    out.setVoxel(x, y, stackIndex, tab.getMinimum());
                                    continue block13;
                                }
                                case 13: {
                                    out.setVoxel(x, y, stackIndex, tab.getMaximum());
                                    continue block13;
                                }
                                case 14: {
                                    out.setVoxel(x, y, stackIndex, tab.getVariance());
                                    continue block13;
                                }
                                case 15: {
                                    double value = this.stack.getVoxel(x, y, stackIndex);
                                    if (tab.isMaximum(value)) {
                                        out.setVoxel(x, y, stackIndex, value);
                                        continue block13;
                                    }
                                    out.setVoxel(x, y, stackIndex, 0.0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private ArrayUtil getNeighborhood(int ch, int fr, int nChs, int nZSlices, int[] ker, int nbval, int x, int y, int z, float radx, float rady, float radz) {
        ArrayUtil pix = new ArrayUtil(nbval);
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int index = 0;
        int c = 0;
        int sizex = this.stack.getWidth();
        int sizey = this.stack.getHeight();
        int sizez = nZSlices;
        for (int k = z - vz; k <= z + vz; ++k) {
            int sliceIndex = ch + nChs * k + nChs * nZSlices * fr;
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    if (ker[c] > 0 && i >= 0 && j >= 0 && k >= 0 && i < sizex && j < sizey && k < sizez) {
                        pix.putValue(index, (float)this.stack.getVoxel(i, j, sliceIndex));
                        ++index;
                    }
                    ++c;
                }
            }
        }
        pix.setSize(index);
        return pix;
    }
}

